/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.container.AmountContainer;
import com.refinedmods.refinedstorage.network.SetFilterSlotMessage;
import com.refinedmods.refinedstorage.screen.AmountSpecifyingScreen;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class ItemAmountScreen
extends AmountSpecifyingScreen<AmountContainer> {
    private final int containerSlot;
    private final ItemStack stack;
    private final int maxAmount;
    @Nullable
    private final Function<Screen, Screen> alternativesScreenFactory;

    public ItemAmountScreen(BaseScreen parent, PlayerEntity player, int containerSlot, ItemStack stack, int maxAmount, @Nullable Function<Screen, Screen> alternativesScreenFactory) {
        super(parent, new AmountContainer(player, stack), alternativesScreenFactory != null ? 194 : 172, 99, player.field_71071_by, (ITextComponent)new TranslationTextComponent("gui.refinedstorage.item_amount", new Object[0]));
        this.containerSlot = containerSlot;
        this.stack = stack;
        this.maxAmount = maxAmount;
        this.alternativesScreenFactory = alternativesScreenFactory;
    }

    @Override
    protected int getOkCancelButtonWidth() {
        return this.alternativesScreenFactory != null ? 75 : super.getOkCancelButtonWidth();
    }

    @Override
    public void onPostInit(int x, int y) {
        super.onPostInit(x, y);
        if (this.alternativesScreenFactory != null) {
            this.addButton(x + 114, this.cancelButton.y + 24, this.getOkCancelButtonWidth(), 20, I18n.func_135052_a((String)"gui.refinedstorage.alternatives", (Object[])new Object[0]), true, true, btn -> this.minecraft.func_147108_a(this.alternativesScreenFactory.apply((Screen)this)));
        }
    }

    @Override
    protected Pair<Integer, Integer> getOkCancelPos() {
        if (this.alternativesScreenFactory == null) {
            return super.getOkCancelPos();
        }
        return Pair.of((Object)114, (Object)22);
    }

    @Override
    protected int getDefaultAmount() {
        return this.stack.func_190916_E();
    }

    @Override
    protected boolean canAmountGoNegative() {
        return false;
    }

    @Override
    protected int getMaxAmount() {
        return this.maxAmount;
    }

    @Override
    protected String getOkButtonText() {
        return I18n.func_135052_a((String)"misc.refinedstorage.set", (Object[])new Object[0]);
    }

    @Override
    protected String getTexture() {
        return this.alternativesScreenFactory != null ? "gui/amount_specifying_wide.png" : "gui/amount_specifying.png";
    }

    @Override
    protected int[] getIncrements() {
        return new int[]{1, 10, 64, -1, -10, -64};
    }

    @Override
    protected void onOkButtonPressed(boolean shiftDown) {
        try {
            int amount = Integer.parseInt(this.amountField.func_146179_b());
            RS.NETWORK_HANDLER.sendToServer(new SetFilterSlotMessage(this.containerSlot, ItemHandlerHelper.copyStackWithSize((ItemStack)this.stack, (int)amount)));
            this.close();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

