/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen;

import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.container.FluidInterfaceContainer;
import com.refinedmods.refinedstorage.render.FluidRenderer;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.RedstoneModeSideButton;
import com.refinedmods.refinedstorage.tile.FluidInterfaceTile;
import com.refinedmods.refinedstorage.util.RenderUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class FluidInterfaceScreen
extends BaseScreen<FluidInterfaceContainer> {
    private static final FluidRenderer TANK_RENDERER = new FluidRenderer(16000, 12, 47, 1);

    public FluidInterfaceScreen(FluidInterfaceContainer container, PlayerInventory inventory, ITextComponent title) {
        super(container, 211, 204, inventory, title);
    }

    @Override
    public void onPostInit(int x, int y) {
        this.addSideButton(new RedstoneModeSideButton(this, FluidInterfaceTile.REDSTONE_MODE));
    }

    @Override
    public void tick(int x, int y) {
    }

    @Override
    public void renderBackground(int x, int y, int mouseX, int mouseY) {
        this.bindTexture("refinedstorage", "gui/fluid_interface.png");
        this.blit(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        if (!FluidInterfaceTile.TANK_IN.getValue().isEmpty()) {
            TANK_RENDERER.render(x + 46, y + 56, FluidInterfaceTile.TANK_IN.getValue());
        }
        if (!FluidInterfaceTile.TANK_OUT.getValue().isEmpty()) {
            TANK_RENDERER.render(x + 118, y + 56, FluidInterfaceTile.TANK_OUT.getValue());
        }
    }

    @Override
    public void renderForeground(int mouseX, int mouseY) {
        this.renderString(7, 7, this.title.func_150254_d());
        this.renderString(47, 20, I18n.func_135052_a((String)"gui.refinedstorage.fluid_interface.in", (Object[])new Object[0]));
        this.renderString(116, 20, I18n.func_135052_a((String)"gui.refinedstorage.fluid_interface.out", (Object[])new Object[0]));
        this.renderString(7, 111, I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]));
        if (RenderUtils.inBounds(46, 56, 12, 47, mouseX, mouseY) && !FluidInterfaceTile.TANK_IN.getValue().isEmpty()) {
            this.renderTooltip(mouseX, mouseY, FluidInterfaceTile.TANK_IN.getValue().getDisplayName().func_150254_d() + "\n" + TextFormatting.GRAY + API.instance().getQuantityFormatter().formatInBucketForm(FluidInterfaceTile.TANK_IN.getValue().getAmount()) + TextFormatting.RESET);
        }
        if (RenderUtils.inBounds(118, 56, 12, 47, mouseX, mouseY) && !FluidInterfaceTile.TANK_OUT.getValue().isEmpty()) {
            this.renderTooltip(mouseX, mouseY, FluidInterfaceTile.TANK_OUT.getValue().getDisplayName().func_150254_d() + "\n" + TextFormatting.GRAY + API.instance().getQuantityFormatter().formatInBucketForm(FluidInterfaceTile.TANK_OUT.getValue().getAmount()) + TextFormatting.RESET);
        }
    }
}

