/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.integration.jei;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.container.GridContainer;
import com.refinedmods.refinedstorage.network.grid.GridProcessingTransferMessage;
import com.refinedmods.refinedstorage.network.grid.GridTransferMessage;
import java.util.LinkedList;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GridRecipeTransferHandler
implements IRecipeTransferHandler<GridContainer> {
    public static final long TRANSFER_SCROLLBAR_DELAY_MS = 200L;
    public static long LAST_TRANSFER_TIME;

    public Class<GridContainer> getContainerClass() {
        return GridContainer.class;
    }

    public IRecipeTransferError transferRecipe(@Nonnull GridContainer container, @Nonnull IRecipeLayout recipeLayout, @Nonnull PlayerEntity player, boolean maxTransfer, boolean doTransfer) {
        IGrid grid = container.getGrid();
        if (doTransfer) {
            LAST_TRANSFER_TIME = System.currentTimeMillis();
            if (grid.getGridType() == GridType.PATTERN && !this.isCraftingRecipe(recipeLayout.getRecipeCategory())) {
                ItemStack ingredient;
                LinkedList<ItemStack> inputs = new LinkedList<ItemStack>();
                LinkedList<ItemStack> outputs = new LinkedList<ItemStack>();
                LinkedList<FluidStack> fluidInputs = new LinkedList<FluidStack>();
                LinkedList<FluidStack> fluidOutputs = new LinkedList<FluidStack>();
                for (IGuiIngredient guiIngredient : recipeLayout.getItemStacks().getGuiIngredients().values()) {
                    if (guiIngredient == null || guiIngredient.getDisplayedIngredient() == null) continue;
                    ingredient = ((ItemStack)guiIngredient.getDisplayedIngredient()).func_77946_l();
                    if (guiIngredient.isInput()) {
                        inputs.add(ingredient);
                        continue;
                    }
                    outputs.add(ingredient);
                }
                for (IGuiIngredient guiIngredient : recipeLayout.getFluidStacks().getGuiIngredients().values()) {
                    if (guiIngredient == null || guiIngredient.getDisplayedIngredient() == null) continue;
                    ingredient = ((FluidStack)guiIngredient.getDisplayedIngredient()).copy();
                    if (guiIngredient.isInput()) {
                        fluidInputs.add((FluidStack)ingredient);
                        continue;
                    }
                    fluidOutputs.add((FluidStack)ingredient);
                }
                RS.NETWORK_HANDLER.sendToServer(new GridProcessingTransferMessage(inputs, outputs, fluidInputs, fluidOutputs));
            } else {
                RS.NETWORK_HANDLER.sendToServer(new GridTransferMessage(recipeLayout.getItemStacks().getGuiIngredients(), container.field_75151_b.stream().filter(s -> s.field_75224_c instanceof CraftingInventory).collect(Collectors.toList())));
            }
        }
        return null;
    }

    private boolean isCraftingRecipe(IRecipeCategory<?> recipeCategory) {
        return recipeCategory.getUid().equals((Object)VanillaRecipeCategoryUid.CRAFTING);
    }
}

