/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.container.factory;

import com.refinedmods.refinedstorage.apiimpl.network.node.CrafterManagerNetworkNode;
import com.refinedmods.refinedstorage.container.CrafterManagerContainer;
import com.refinedmods.refinedstorage.screen.EmptyScreenInfoProvider;
import com.refinedmods.refinedstorage.tile.CrafterManagerTile;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandlerModifiable;

public class CrafterManagerContainerProvider
implements INamedContainerProvider {
    private final CrafterManagerTile tile;

    public CrafterManagerContainerProvider(CrafterManagerTile tile) {
        this.tile = tile;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("gui.refinedstorage.crafter_manager", new Object[0]);
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        CrafterManagerContainer container = new CrafterManagerContainer(this.tile, playerEntity, windowId);
        container.setScreenInfoProvider(new EmptyScreenInfoProvider());
        container.initSlotsServer();
        return container;
    }

    public static void writeToBuffer(PacketBuffer buf, World world, BlockPos pos) {
        buf.func_179255_a(pos);
        Map<ITextComponent, List<IItemHandlerModifiable>> containerData = ((CrafterManagerNetworkNode)((CrafterManagerTile)world.func_175625_s(pos)).getNode()).getNetwork().getCraftingManager().getNamedContainers();
        buf.writeInt(containerData.size());
        for (Map.Entry<ITextComponent, List<IItemHandlerModifiable>> entry : containerData.entrySet()) {
            buf.func_179256_a(entry.getKey());
            int slots = 0;
            for (IItemHandlerModifiable handler : entry.getValue()) {
                slots += handler.getSlots();
            }
            buf.writeInt(slots);
        }
    }
}

