/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.container;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.container.slot.filter.FilterSlot;
import com.refinedmods.refinedstorage.container.slot.filter.FluidFilterSlot;
import com.refinedmods.refinedstorage.container.slot.legacy.LegacyDisabledSlot;
import com.refinedmods.refinedstorage.container.slot.legacy.LegacyFilterSlot;
import com.refinedmods.refinedstorage.container.transfer.TransferManager;
import com.refinedmods.refinedstorage.network.FluidFilterSlotUpdateMessage;
import com.refinedmods.refinedstorage.tile.BaseTile;
import com.refinedmods.refinedstorage.tile.data.TileDataWatcher;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public abstract class BaseContainer
extends Container {
    @Nullable
    private final BaseTile tile;
    @Nullable
    private TileDataWatcher listener;
    private final PlayerEntity player;
    protected final TransferManager transferManager = new TransferManager(this);
    private final List<FluidFilterSlot> fluidSlots = new ArrayList<FluidFilterSlot>();
    private final List<FluidStack> fluids = new ArrayList<FluidStack>();

    public BaseContainer(@Nullable ContainerType<?> type, @Nullable BaseTile tile, PlayerEntity player, int windowId) {
        super(type, windowId);
        this.tile = tile;
        if (tile != null && player instanceof ServerPlayerEntity) {
            this.listener = new TileDataWatcher((ServerPlayerEntity)player, tile.getDataManager());
        }
        this.player = player;
    }

    public PlayerEntity getPlayer() {
        return this.player;
    }

    @Nullable
    public BaseTile getTile() {
        return this.tile;
    }

    protected void addPlayerInventory(int xInventory, int yInventory) {
        int x;
        int disabledSlotNumber = this.getDisabledSlotNumber();
        int id = 9;
        for (int y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                if (id == disabledSlotNumber) {
                    this.func_75146_a(new LegacyDisabledSlot((IInventory)this.player.field_71071_by, id, xInventory + x * 18, yInventory + y * 18));
                } else {
                    this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, id, xInventory + x * 18, yInventory + y * 18));
                }
                ++id;
            }
        }
        id = 0;
        for (int i = 0; i < 9; ++i) {
            x = xInventory + i * 18;
            int y = yInventory + 4 + 54;
            if (id == disabledSlotNumber) {
                this.func_75146_a(new LegacyDisabledSlot((IInventory)this.player.field_71071_by, id, x, y));
            } else {
                this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, id, x, y));
            }
            ++id;
        }
    }

    public List<FluidFilterSlot> getFluidSlots() {
        return this.fluidSlots;
    }

    public ItemStack func_184996_a(int id, int dragType, ClickType clickType, PlayerEntity player) {
        Slot slot = id >= 0 ? this.func_75139_a(id) : null;
        int disabledSlotNumber = this.getDisabledSlotNumber();
        if (disabledSlotNumber != -1 && clickType == ClickType.SWAP && dragType == disabledSlotNumber) {
            return ItemStack.field_190927_a;
        }
        if (slot instanceof FilterSlot) {
            if (((FilterSlot)slot).isSizeAllowed()) {
                if (clickType == ClickType.QUICK_MOVE) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                } else if (!player.field_71071_by.func_70445_o().func_190926_b()) {
                    slot.func_75215_d(player.field_71071_by.func_70445_o().func_77946_l());
                }
            } else if (player.field_71071_by.func_70445_o().func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else if (slot.func_75214_a(player.field_71071_by.func_70445_o())) {
                slot.func_75215_d(player.field_71071_by.func_70445_o().func_77946_l());
            }
            return player.field_71071_by.func_70445_o();
        }
        if (slot instanceof FluidFilterSlot) {
            if (((FluidFilterSlot)slot).isSizeAllowed()) {
                if (clickType == ClickType.QUICK_MOVE) {
                    ((FluidFilterSlot)slot).onContainerClicked(ItemStack.field_190927_a);
                } else if (!player.field_71071_by.func_70445_o().func_190926_b()) {
                    ((FluidFilterSlot)slot).onContainerClicked(player.field_71071_by.func_70445_o());
                }
            } else if (player.field_71071_by.func_70445_o().func_190926_b()) {
                ((FluidFilterSlot)slot).onContainerClicked(ItemStack.field_190927_a);
            } else {
                ((FluidFilterSlot)slot).onContainerClicked(player.field_71071_by.func_70445_o());
            }
            return player.field_71071_by.func_70445_o();
        }
        if (slot instanceof LegacyFilterSlot) {
            if (player.field_71071_by.func_70445_o().func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else if (slot.func_75214_a(player.field_71071_by.func_70445_o())) {
                slot.func_75215_d(player.field_71071_by.func_70445_o().func_77946_l());
            }
            return player.field_71071_by.func_70445_o();
        }
        if (slot instanceof LegacyDisabledSlot) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(id, dragType, clickType, player);
    }

    public ItemStack func_82846_b(PlayerEntity player, int slotIndex) {
        return this.transferManager.transfer(slotIndex);
    }

    public boolean func_75145_c(PlayerEntity player) {
        return this.isTileStillThere();
    }

    private boolean isTileStillThere() {
        if (this.tile != null) {
            return this.tile.func_145831_w().func_175625_s(this.tile.func_174877_v()) == this.tile;
        }
        return true;
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        if (slot instanceof FilterSlot || slot instanceof FluidFilterSlot || slot instanceof LegacyFilterSlot) {
            return false;
        }
        return super.func_94530_a(stack, slot);
    }

    protected int getDisabledSlotNumber() {
        return -1;
    }

    protected Slot func_75146_a(Slot slot) {
        if (slot instanceof FluidFilterSlot) {
            this.fluids.add(FluidStack.EMPTY);
            this.fluidSlots.add((FluidFilterSlot)slot);
        }
        return super.func_75146_a(slot);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.listener != null && this.isTileStillThere()) {
            this.listener.detectAndSendChanges();
        }
        if (this.getPlayer() instanceof ServerPlayerEntity) {
            for (int i = 0; i < this.fluidSlots.size(); ++i) {
                FluidFilterSlot slot = this.fluidSlots.get(i);
                FluidStack cached = this.fluids.get(i);
                FluidStack actual = slot.getFluidInventory().getFluid(slot.getSlotIndex());
                if (API.instance().getComparer().isEqual(cached, actual, 3)) continue;
                this.fluids.set(i, actual.copy());
                RS.NETWORK_HANDLER.sendTo((ServerPlayerEntity)this.getPlayer(), new FluidFilterSlotUpdateMessage(slot.field_75222_d, actual));
            }
        }
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        if (this.listener != null) {
            this.listener.onClosed();
        }
    }
}

