/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class ClientConfig {
    private final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    private final ForgeConfigSpec spec;
    private final Grid grid = new Grid();
    private final CrafterManager crafterManager = new CrafterManager();

    public ClientConfig() {
        this.spec = this.builder.build();
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }

    public Grid getGrid() {
        return this.grid;
    }

    public CrafterManager getCrafterManager() {
        return this.crafterManager;
    }

    public class CrafterManager {
        private final ForgeConfigSpec.IntValue maxRowsStretch;

        public CrafterManager() {
            ClientConfig.this.builder.push("crafterManager");
            this.maxRowsStretch = ClientConfig.this.builder.comment("The maximum amount of rows that the Crafter Manager can show when stretched").defineInRange("maxRowsStretch", Integer.MAX_VALUE, 3, Integer.MAX_VALUE);
            ClientConfig.this.builder.pop();
        }

        public int getMaxRowsStretch() {
            return (Integer)this.maxRowsStretch.get();
        }
    }

    public class Grid {
        private final ForgeConfigSpec.IntValue maxRowsStretch;
        private final ForgeConfigSpec.BooleanValue detailedTooltip;
        private final ForgeConfigSpec.BooleanValue largeFont;
        private final ForgeConfigSpec.BooleanValue preventSortingWhileShiftIsDown;

        public Grid() {
            ClientConfig.this.builder.push("grid");
            this.maxRowsStretch = ClientConfig.this.builder.comment("The maximum amount of rows that the Grid can show when stretched").defineInRange("maxRowsStretch", Integer.MAX_VALUE, 3, Integer.MAX_VALUE);
            this.detailedTooltip = ClientConfig.this.builder.comment("Whether the Grid should display a detailed tooltip when hovering over an item or fluid").define("detailedTooltip", true);
            this.largeFont = ClientConfig.this.builder.comment("Whether the Grid should use a large font for stack quantity display").define("largeFont", false);
            this.preventSortingWhileShiftIsDown = ClientConfig.this.builder.comment("Whether the Grid should prevent sorting while the shift key is held down").define("preventSortingWhileShiftIsDown", true);
            ClientConfig.this.builder.pop();
        }

        public int getMaxRowsStretch() {
            return (Integer)this.maxRowsStretch.get();
        }

        public boolean getDetailedTooltip() {
            return (Boolean)this.detailedTooltip.get();
        }

        public boolean getLargeFont() {
            return (Boolean)this.largeFont.get();
        }

        public boolean getPreventSortingWhileShiftIsDown() {
            return (Boolean)this.preventSortingWhileShiftIsDown.get();
        }
    }
}

