/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.block;

import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.apiimpl.network.node.CrafterNetworkNode;
import com.refinedmods.refinedstorage.block.BlockDirection;
import com.refinedmods.refinedstorage.block.NetworkNodeBlock;
import com.refinedmods.refinedstorage.container.CrafterContainer;
import com.refinedmods.refinedstorage.container.factory.PositionalTileContainerProvider;
import com.refinedmods.refinedstorage.tile.CrafterTile;
import com.refinedmods.refinedstorage.util.BlockUtils;
import com.refinedmods.refinedstorage.util.NetworkUtils;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class CrafterBlock
extends NetworkNodeBlock {
    public CrafterBlock() {
        super(BlockUtils.DEFAULT_ROCK_PROPERTIES);
        this.setRegistryName("refinedstorage", "crafter");
    }

    @Override
    public BlockDirection getDirection() {
        return BlockDirection.ANY_FACE_PLAYER;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CrafterTile();
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tile;
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof CrafterTile && stack.func_82837_s()) {
            ((CrafterNetworkNode)((CrafterTile)tile).getNode()).setDisplayName(stack.func_200301_q());
            ((CrafterNetworkNode)((CrafterTile)tile).getNode()).markDirty();
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!world.field_72995_K) {
            return NetworkUtils.attempt(world, pos, hit.func_216354_b(), player, () -> NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), new PositionalTileContainerProvider<CrafterTile>(((CrafterNetworkNode)((CrafterTile)world.func_175625_s(pos)).getNode()).getName(), (tile, windowId, inventory, p) -> new CrafterContainer((CrafterTile)tile, player, windowId), pos), (BlockPos)pos), Permission.MODIFY, Permission.AUTOCRAFTING);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public boolean hasConnectedState() {
        return true;
    }
}

