/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.storage.disk;

import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskFactory;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskManager;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskProvider;
import com.refinedmods.refinedstorage.apiimpl.API;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;

public class StorageDiskManager
extends WorldSavedData
implements IStorageDiskManager {
    public static final String NAME = "refinedstorage_disks";
    private static final String NBT_DISKS = "Disks";
    private static final String NBT_DISK_ID = "Id";
    private static final String NBT_DISK_TYPE = "Type";
    private static final String NBT_DISK_DATA = "Data";
    private final Map<UUID, IStorageDisk> disks = new HashMap<UUID, IStorageDisk>();
    private final ServerWorld world;

    public StorageDiskManager(String name, ServerWorld world) {
        super(name);
        this.world = world;
    }

    @Override
    @Nullable
    public IStorageDisk get(UUID id) {
        return this.disks.get(id);
    }

    @Override
    @Nullable
    public IStorageDisk getByStack(ItemStack disk) {
        if (!(disk.func_77973_b() instanceof IStorageDiskProvider)) {
            return null;
        }
        IStorageDiskProvider provider = (IStorageDiskProvider)disk.func_77973_b();
        if (!provider.isValid(disk)) {
            return null;
        }
        return this.get(provider.getId(disk));
    }

    @Override
    public Map<UUID, IStorageDisk> getAll() {
        return this.disks;
    }

    @Override
    public void set(UUID id, IStorageDisk disk) {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (disk == null) {
            throw new IllegalArgumentException("Disk cannot be null");
        }
        if (this.disks.containsKey(id)) {
            throw new IllegalArgumentException("Disks already contains id '" + id + "'");
        }
        this.disks.put(id, disk);
    }

    @Override
    public void remove(UUID id) {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        this.disks.remove(id);
    }

    @Override
    public void markForSaving() {
        this.func_76185_a();
    }

    public void func_76184_a(CompoundNBT tag) {
        if (tag.func_74764_b(NBT_DISKS)) {
            ListNBT disksTag = tag.func_150295_c(NBT_DISKS, 10);
            for (int i = 0; i < disksTag.size(); ++i) {
                CompoundNBT diskTag = disksTag.func_150305_b(i);
                UUID id = diskTag.func_186857_a(NBT_DISK_ID);
                CompoundNBT data = diskTag.func_74775_l(NBT_DISK_DATA);
                String type = diskTag.func_74779_i(NBT_DISK_TYPE);
                IStorageDiskFactory factory = API.instance().getStorageDiskRegistry().get(new ResourceLocation(type));
                if (factory == null) continue;
                this.disks.put(id, factory.createFromNbt(this.world, data));
            }
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT tag) {
        ListNBT disks = new ListNBT();
        for (Map.Entry<UUID, IStorageDisk> entry : this.disks.entrySet()) {
            CompoundNBT diskTag = new CompoundNBT();
            diskTag.func_186854_a(NBT_DISK_ID, entry.getKey());
            diskTag.func_218657_a(NBT_DISK_DATA, (INBT)entry.getValue().writeToNbt());
            diskTag.func_74778_a(NBT_DISK_TYPE, entry.getValue().getFactoryId().toString());
            disks.add((Object)diskTag);
        }
        tag.func_218657_a(NBT_DISKS, (INBT)disks);
        return tag;
    }
}

