/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node.storage;

import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskListener;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.network.node.storage.StorageNetworkNode;
import com.refinedmods.refinedstorage.tile.config.IWhitelistBlacklist;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemStorageWrapperStorageDisk
implements IStorageDisk<ItemStack> {
    private final StorageNetworkNode storage;
    private final IStorageDisk<ItemStack> parent;

    public ItemStorageWrapperStorageDisk(StorageNetworkNode storage, IStorageDisk<ItemStack> parent) {
        this.storage = storage;
        this.parent = parent;
        this.setSettings(null, storage);
    }

    @Override
    public int getPriority() {
        return this.storage.getPriority();
    }

    @Override
    public AccessType getAccessType() {
        return this.parent.getAccessType();
    }

    @Override
    public Collection<ItemStack> getStacks() {
        return this.parent.getStacks();
    }

    @Override
    @Nonnull
    public ItemStack insert(@Nonnull ItemStack stack, int size, Action action) {
        if (!IWhitelistBlacklist.acceptsItem((IItemHandler)this.storage.getFilters(), this.storage.getWhitelistBlacklistMode(), this.storage.getCompare(), stack)) {
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
        }
        return this.parent.insert(stack, size, action);
    }

    @Override
    @Nonnull
    public ItemStack extract(@Nonnull ItemStack stack, int size, int flags, Action action) {
        return this.parent.extract(stack, size, flags, action);
    }

    @Override
    public int getStored() {
        return this.parent.getStored();
    }

    @Override
    public int getCacheDelta(int storedPreInsertion, int size, @Nullable ItemStack remainder) {
        return this.parent.getCacheDelta(storedPreInsertion, size, remainder);
    }

    @Override
    public int getCapacity() {
        return this.parent.getCapacity();
    }

    @Override
    public void setSettings(@Nullable IStorageDiskListener listener, IStorageDiskContainerContext context) {
        this.parent.setSettings(listener, context);
    }

    @Override
    public CompoundNBT writeToNbt() {
        return this.parent.writeToNbt();
    }

    @Override
    public ResourceLocation getFactoryId() {
        return this.parent.getFactoryId();
    }
}

