/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.ConnectivityStateChangeCause;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.UpgradeItemHandler;
import com.refinedmods.refinedstorage.inventory.item.validator.PatternItemValidator;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.util.StackUtils;
import com.refinedmods.refinedstorage.util.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.INameable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class CrafterNetworkNode
extends NetworkNode
implements ICraftingPatternContainer {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "crafter");
    private static final ITextComponent DEFAULT_NAME = new TranslationTextComponent("gui.refinedstorage.crafter", new Object[0]);
    private static final String NBT_DISPLAY_NAME = "DisplayName";
    private static final String NBT_UUID = "CrafterUuid";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_LOCKED = "Locked";
    private static final String NBT_WAS_POWERED = "WasPowered";
    private final BaseItemHandler patternsInventory;
    private final List<ICraftingPattern> patterns;
    private final UpgradeItemHandler upgrades;
    private boolean visited;
    private CrafterMode mode;
    private boolean locked;
    private boolean wasPowered;
    @Nullable
    private ITextComponent displayName;
    @Nullable
    private UUID uuid;

    public CrafterNetworkNode(World world, BlockPos pos) {
        super(world, pos);
        this.patternsInventory = new BaseItemHandler(9){

            public int getSlotLimit(int slot) {
                return 1;
            }
        }.addValidator(new PatternItemValidator(this.world)).addListener(new NetworkNodeInventoryListener(this)).addListener((handler, slot, reading) -> {
            if (!reading) {
                if (!this.world.field_72995_K) {
                    this.invalidate();
                }
                if (this.network != null) {
                    this.network.getCraftingManager().invalidate();
                }
            }
        });
        this.patterns = new ArrayList<ICraftingPattern>();
        this.upgrades = (UpgradeItemHandler)new UpgradeItemHandler(4, UpgradeItem.Type.SPEED).addListener(new NetworkNodeInventoryListener(this));
        this.visited = false;
        this.mode = CrafterMode.IGNORE;
        this.locked = false;
        this.uuid = null;
    }

    private void invalidate() {
        this.patterns.clear();
        for (int i = 0; i < this.patternsInventory.getSlots(); ++i) {
            ICraftingPattern pattern;
            ItemStack patternStack = this.patternsInventory.getStackInSlot(i);
            if (patternStack.func_190926_b() || !(pattern = ((ICraftingPatternProvider)patternStack.func_77973_b()).create(this.world, patternStack, this)).isValid()) continue;
            this.patterns.add(pattern);
        }
    }

    @Override
    public int getEnergyUsage() {
        return RS.SERVER_CONFIG.getCrafter().getUsage() + this.upgrades.getEnergyUsage() + RS.SERVER_CONFIG.getCrafter().getPatternUsage() * this.patterns.size();
    }

    @Override
    public void update() {
        super.update();
        if (this.ticks == 1) {
            this.invalidate();
        }
        if (this.mode == CrafterMode.PULSE_INSERTS_NEXT_SET) {
            if (this.world.func_175640_z(this.pos)) {
                this.wasPowered = true;
                this.markDirty();
            } else if (this.wasPowered) {
                this.wasPowered = false;
                this.locked = false;
                this.markDirty();
            }
        }
    }

    @Override
    protected void onConnectedStateChange(INetwork network, boolean state, ConnectivityStateChangeCause cause) {
        super.onConnectedStateChange(network, state, cause);
        network.getCraftingManager().invalidate();
    }

    @Override
    public void onDisconnected(INetwork network) {
        super.onDisconnected(network);
        network.getCraftingManager().getTasks().stream().filter(task -> task.getPattern().getContainer().getPosition().equals((Object)this.pos)).forEach(task -> network.getCraftingManager().cancel(task.getId()));
    }

    @Override
    public void onDirectionChanged(Direction direction) {
        super.onDirectionChanged(direction);
        if (this.network != null) {
            this.network.getCraftingManager().invalidate();
        }
    }

    @Override
    public void read(CompoundNBT tag) {
        super.read(tag);
        StackUtils.readItems(this.patternsInventory, 0, tag);
        this.invalidate();
        StackUtils.readItems(this.upgrades, 1, tag);
        if (tag.func_74764_b(NBT_DISPLAY_NAME)) {
            this.displayName = ITextComponent.Serializer.func_150699_a((String)tag.func_74779_i(NBT_DISPLAY_NAME));
        }
        if (tag.func_186855_b(NBT_UUID)) {
            this.uuid = tag.func_186857_a(NBT_UUID);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = CrafterMode.getById(tag.func_74762_e(NBT_MODE));
        }
        if (tag.func_74764_b(NBT_LOCKED)) {
            this.locked = tag.func_74767_n(NBT_LOCKED);
        }
        if (tag.func_74764_b(NBT_WAS_POWERED)) {
            this.wasPowered = tag.func_74767_n(NBT_WAS_POWERED);
        }
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CompoundNBT write(CompoundNBT tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.patternsInventory, 0, tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 1, tag);
        if (this.displayName != null) {
            tag.func_74778_a(NBT_DISPLAY_NAME, ITextComponent.Serializer.func_150696_a((ITextComponent)this.displayName));
        }
        if (this.uuid != null) {
            tag.func_186854_a(NBT_UUID, this.uuid);
        }
        tag.func_74768_a(NBT_MODE, this.mode.ordinal());
        tag.func_74757_a(NBT_LOCKED, this.locked);
        tag.func_74757_a(NBT_WAS_POWERED, this.wasPowered);
        return tag;
    }

    @Override
    public int getUpdateInterval() {
        switch (this.upgrades.getUpgradeCount(UpgradeItem.Type.SPEED)) {
            case 0: {
                return 10;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public int getMaximumSuccessfulCraftingUpdates() {
        switch (this.upgrades.getUpgradeCount(UpgradeItem.Type.SPEED)) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
        }
        return 1;
    }

    @Override
    @Nullable
    public IItemHandler getConnectedInventory() {
        ICraftingPatternContainer proxy = this.getRootContainer();
        if (proxy == null) {
            return null;
        }
        return WorldUtils.getItemHandler(proxy.getFacingTile(), proxy.getDirection().func_176734_d());
    }

    @Override
    @Nullable
    public IFluidHandler getConnectedFluidInventory() {
        ICraftingPatternContainer proxy = this.getRootContainer();
        if (proxy == null) {
            return null;
        }
        return WorldUtils.getFluidHandler(proxy.getFacingTile(), proxy.getDirection().func_176734_d());
    }

    @Override
    @Nullable
    public TileEntity getConnectedTile() {
        ICraftingPatternContainer proxy = this.getRootContainer();
        if (proxy == null) {
            return null;
        }
        return proxy.getFacingTile();
    }

    @Override
    public List<ICraftingPattern> getPatterns() {
        return this.patterns;
    }

    @Override
    @Nullable
    public IItemHandlerModifiable getPatternInventory() {
        return this.patternsInventory;
    }

    @Override
    public ITextComponent getName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        TileEntity facing = this.getConnectedTile();
        if (facing instanceof INameable && ((INameable)facing).func_200200_C_() != null) {
            return ((INameable)facing).func_200200_C_();
        }
        if (facing != null) {
            return new TranslationTextComponent(this.world.func_180495_p(facing.func_174877_v()).func_177230_c().func_149739_a(), new Object[0]);
        }
        return DEFAULT_NAME;
    }

    public void setDisplayName(ITextComponent displayName) {
        this.displayName = displayName;
    }

    @Nullable
    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    @Override
    public BlockPos getPosition() {
        return this.pos;
    }

    public CrafterMode getMode() {
        return this.mode;
    }

    public void setMode(CrafterMode mode) {
        this.mode = mode;
        this.wasPowered = false;
        this.locked = false;
        this.markDirty();
    }

    public IItemHandler getPatternItems() {
        return this.patternsInventory;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.patternsInventory, this.upgrades});
    }

    @Override
    @Nullable
    public ICraftingPatternContainer getRootContainer() {
        if (this.visited) {
            return null;
        }
        INetworkNode facing = API.instance().getNetworkNodeManager((ServerWorld)this.world).getNode(this.pos.func_177972_a(this.getDirection()));
        if (!(facing instanceof ICraftingPatternContainer) || facing.getNetwork() != this.network) {
            return this;
        }
        this.visited = true;
        ICraftingPatternContainer facingContainer = ((ICraftingPatternContainer)((Object)facing)).getRootContainer();
        this.visited = false;
        return facingContainer;
    }

    public Optional<ICraftingPatternContainer> getRootContainerNotSelf() {
        ICraftingPatternContainer root = this.getRootContainer();
        if (root != null && root != this) {
            return Optional.of(root);
        }
        return Optional.empty();
    }

    @Override
    public UUID getUuid() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
            this.markDirty();
        }
        return this.uuid;
    }

    @Override
    public boolean isLocked() {
        Optional<ICraftingPatternContainer> root = this.getRootContainerNotSelf();
        if (root.isPresent()) {
            return root.get().isLocked();
        }
        switch (this.mode) {
            case IGNORE: {
                return false;
            }
            case SIGNAL_LOCKS_AUTOCRAFTING: {
                return this.world.func_175640_z(this.pos);
            }
            case SIGNAL_UNLOCKS_AUTOCRAFTING: {
                return !this.world.func_175640_z(this.pos);
            }
            case PULSE_INSERTS_NEXT_SET: {
                return this.locked;
            }
        }
        return false;
    }

    @Override
    public void unlock() {
        this.locked = false;
    }

    @Override
    public void onUsedForProcessing() {
        Optional<ICraftingPatternContainer> root = this.getRootContainerNotSelf();
        if (root.isPresent()) {
            root.get().onUsedForProcessing();
            return;
        }
        if (this.mode == CrafterMode.PULSE_INSERTS_NEXT_SET) {
            this.locked = true;
            this.markDirty();
        }
    }

    public static enum CrafterMode {
        IGNORE,
        SIGNAL_UNLOCKS_AUTOCRAFTING,
        SIGNAL_LOCKS_AUTOCRAFTING,
        PULSE_INSERTS_NEXT_SET;


        public static CrafterMode getById(int id) {
            if (id >= 0 && id < CrafterMode.values().length) {
                return CrafterMode.values()[id];
            }
            return IGNORE;
        }
    }
}

