/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.item;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.IWirelessTransmitter;
import com.refinedmods.refinedstorage.api.network.item.INetworkItem;
import com.refinedmods.refinedstorage.api.network.item.INetworkItemManager;
import com.refinedmods.refinedstorage.api.network.item.INetworkItemProvider;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class NetworkItemManager
implements INetworkItemManager {
    private final INetwork network;
    private final Map<PlayerEntity, INetworkItem> items = new ConcurrentHashMap<PlayerEntity, INetworkItem>();

    public NetworkItemManager(INetwork network) {
        this.network = network;
    }

    @Override
    public void open(PlayerEntity player, ItemStack stack, int slotId) {
        boolean inRange = false;
        for (INetworkNode node : this.network.getNodeGraph().all()) {
            if (!(node instanceof IWirelessTransmitter) || !this.network.canRun() || !node.isActive() || ((IWirelessTransmitter)((Object)node)).getDimension() != player.field_71093_bK) continue;
            IWirelessTransmitter transmitter = (IWirelessTransmitter)((Object)node);
            Vec3d pos = player.func_213303_ch();
            double distance = Math.sqrt(Math.pow((double)transmitter.getOrigin().func_177958_n() - pos.func_82615_a(), 2.0) + Math.pow((double)transmitter.getOrigin().func_177956_o() - pos.func_82617_b(), 2.0) + Math.pow((double)transmitter.getOrigin().func_177952_p() - pos.func_82616_c(), 2.0));
            if (!(distance < (double)transmitter.getRange())) continue;
            inRange = true;
            break;
        }
        if (!inRange) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("misc.refinedstorage.network_item.out_of_range", new Object[0]));
            return;
        }
        INetworkItem item = ((INetworkItemProvider)stack.func_77973_b()).provide(this, player, stack, slotId);
        if (item.onOpen(this.network)) {
            this.items.put(player, item);
        }
    }

    @Override
    public void close(PlayerEntity player) {
        this.items.remove(player);
    }

    @Override
    public INetworkItem getItem(PlayerEntity player) {
        return this.items.get(player);
    }

    @Override
    public void drainEnergy(PlayerEntity player, int energy) {
        INetworkItem item = this.getItem(player);
        if (item != null) {
            item.drainEnergy(energy);
        }
    }
}

