/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.grid.handler;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.tile.grid.portable.IPortableGrid;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.tuple.Pair;

public class PortableFluidGridHandler
implements IFluidGridHandler {
    private final IPortableGrid portableGrid;

    public PortableFluidGridHandler(IPortableGrid portableGrid) {
        this.portableGrid = portableGrid;
    }

    @Override
    public void onExtract(ServerPlayerEntity player, UUID id, boolean shift) {
        FluidStack stack = this.portableGrid.getFluidCache().getList().get(id);
        if (stack == null || stack.getAmount() < 1000) {
            return;
        }
        ItemStack bucket = ItemStack.field_190927_a;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack slot = player.field_71071_by.func_70301_a(i);
            if (!API.instance().getComparer().isEqualNoQuantity(StackUtils.EMPTY_BUCKET, slot)) continue;
            bucket = StackUtils.EMPTY_BUCKET.func_77946_l();
            player.field_71071_by.func_70298_a(i, 1);
            break;
        }
        if (!bucket.func_190926_b()) {
            bucket.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).ifPresent(fluidHandler -> {
                this.portableGrid.getFluidStorageTracker().changed((PlayerEntity)player, stack.copy());
                fluidHandler.fill(this.portableGrid.getFluidStorage().extract(stack, 1000, 1, Action.PERFORM), IFluidHandler.FluidAction.EXECUTE);
                if (shift) {
                    if (!player.field_71071_by.func_70441_a(fluidHandler.getContainer().func_77946_l())) {
                        InventoryHelper.func_180173_a((World)player.func_130014_f_(), (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)fluidHandler.getContainer());
                    }
                } else {
                    player.field_71071_by.func_70437_b(fluidHandler.getContainer());
                    player.func_71113_k();
                }
                this.portableGrid.drainEnergy(RS.SERVER_CONFIG.getPortableGrid().getExtractUsage());
            });
        }
    }

    @Override
    @Nonnull
    public ItemStack onInsert(ServerPlayerEntity player, ItemStack container) {
        Pair<ItemStack, FluidStack> result = StackUtils.getFluid(container, true);
        if (!((FluidStack)result.getValue()).isEmpty() && this.portableGrid.getFluidStorage().insert((FluidStack)result.getValue(), ((FluidStack)result.getValue()).getAmount(), Action.SIMULATE).isEmpty()) {
            this.portableGrid.getFluidStorageTracker().changed((PlayerEntity)player, ((FluidStack)result.getValue()).copy());
            result = StackUtils.getFluid(container, false);
            this.portableGrid.getFluidStorage().insert((FluidStack)result.getValue(), ((FluidStack)result.getValue()).getAmount(), Action.PERFORM);
            this.portableGrid.drainEnergy(RS.SERVER_CONFIG.getPortableGrid().getInsertUsage());
            return (ItemStack)result.getLeft();
        }
        return container;
    }

    @Override
    public void onInsertHeldContainer(ServerPlayerEntity player) {
        player.field_71071_by.func_70437_b(this.onInsert(player, player.field_71071_by.func_70445_o()));
        player.func_71113_k();
    }

    @Override
    public void onCraftingPreviewRequested(ServerPlayerEntity player, UUID id, int quantity, boolean noPreview) {
    }

    @Override
    public void onCraftingRequested(ServerPlayerEntity player, UUID id, int quantity) {
    }
}

