/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.grid.handler;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICraftingTaskError;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.preview.ErrorCraftingPreviewElement;
import com.refinedmods.refinedstorage.network.grid.GridCraftingPreviewResponseMessage;
import com.refinedmods.refinedstorage.network.grid.GridCraftingStartResponseMessage;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemGridHandler
implements IItemGridHandler {
    private final INetwork network;

    public ItemGridHandler(INetwork network) {
        this.network = network;
    }

    @Override
    public void onExtract(ServerPlayerEntity player, UUID id, int flags) {
        ItemStack item = this.network.getItemStorageCache().getList().get(id);
        if (item == null || !this.network.getSecurityManager().hasPermission(Permission.EXTRACT, (PlayerEntity)player)) {
            return;
        }
        int itemSize = item.func_190916_E();
        int maxItemSize = item.func_77973_b().getItemStackLimit(item.func_77946_l());
        boolean single = (flags & 2) == 2;
        ItemStack held = player.field_71071_by.func_70445_o();
        if (single ? !held.func_190926_b() && (!API.instance().getComparer().isEqualNoQuantity(item, held) || held.func_190916_E() + 1 > held.func_77976_d()) : !player.field_71071_by.func_70445_o().func_190926_b()) {
            return;
        }
        int size = 64;
        if ((flags & 1) == 1 && itemSize > 1) {
            size = itemSize / 2;
            if (size > maxItemSize / 2 && maxItemSize != 1) {
                size = maxItemSize / 2;
            }
        } else if (single) {
            size = 1;
        } else if ((flags & 4) == 4) {
            // empty if block
        }
        size = Math.min(size, maxItemSize);
        this.network.getItemStorageTracker().changed((PlayerEntity)player, item.func_77946_l());
        ItemStack took = this.network.extractItem(item, size, Action.SIMULATE);
        if (!took.func_190926_b()) {
            if ((flags & 4) == 4) {
                IItemHandler playerInventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).orElse(null);
                if (playerInventory != null && ItemHandlerHelper.insertItem((IItemHandler)playerInventory, (ItemStack)took, (boolean)true).func_190926_b()) {
                    took = this.network.extractItem(item, size, Action.PERFORM);
                    ItemHandlerHelper.insertItem((IItemHandler)playerInventory, (ItemStack)took, (boolean)false);
                }
            } else {
                took = this.network.extractItem(item, size, Action.PERFORM);
                if (!took.func_190926_b()) {
                    if (single && !held.func_190926_b()) {
                        held.func_190917_f(1);
                    } else {
                        player.field_71071_by.func_70437_b(took);
                    }
                    player.func_71113_k();
                }
            }
            this.network.getNetworkItemManager().drainEnergy((PlayerEntity)player, RS.SERVER_CONFIG.getWirelessGrid().getExtractUsage());
        }
    }

    @Override
    @Nonnull
    public ItemStack onInsert(ServerPlayerEntity player, ItemStack stack) {
        if (!this.network.getSecurityManager().hasPermission(Permission.INSERT, (PlayerEntity)player)) {
            return stack;
        }
        this.network.getItemStorageTracker().changed((PlayerEntity)player, stack.func_77946_l());
        ItemStack remainder = this.network.insertItem(stack, stack.func_190916_E(), Action.PERFORM);
        this.network.getNetworkItemManager().drainEnergy((PlayerEntity)player, RS.SERVER_CONFIG.getWirelessGrid().getInsertUsage());
        return remainder;
    }

    @Override
    public void onInsertHeldItem(ServerPlayerEntity player, boolean single) {
        if (player.field_71071_by.func_70445_o().func_190926_b() || !this.network.getSecurityManager().hasPermission(Permission.INSERT, (PlayerEntity)player)) {
            return;
        }
        ItemStack stack = player.field_71071_by.func_70445_o();
        int size = single ? 1 : stack.func_190916_E();
        this.network.getItemStorageTracker().changed((PlayerEntity)player, stack.func_77946_l());
        if (single) {
            if (this.network.insertItem(stack, size, Action.SIMULATE).func_190926_b()) {
                this.network.insertItem(stack, size, Action.PERFORM);
                stack.func_190918_g(size);
            }
        } else {
            player.field_71071_by.func_70437_b(this.network.insertItem(stack, size, Action.PERFORM));
        }
        player.func_71113_k();
        this.network.getNetworkItemManager().drainEnergy((PlayerEntity)player, RS.SERVER_CONFIG.getWirelessGrid().getInsertUsage());
    }

    @Override
    public void onCraftingPreviewRequested(ServerPlayerEntity player, UUID id, int quantity, boolean noPreview) {
        if (!this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (PlayerEntity)player)) {
            return;
        }
        ItemStack stack = this.network.getItemStorageCache().getCraftablesList().get(id);
        if (stack != null) {
            Thread calculationThread = new Thread(() -> {
                ICraftingTask task = this.network.getCraftingManager().create(stack, quantity);
                if (task == null) {
                    return;
                }
                ICraftingTaskError error = task.calculate();
                ResourceLocation factoryId = task.getPattern().getCraftingTaskFactoryId();
                if (error != null) {
                    RS.NETWORK_HANDLER.sendTo(player, new GridCraftingPreviewResponseMessage(factoryId, Collections.singletonList(new ErrorCraftingPreviewElement(error.getType(), error.getRecursedPattern() == null ? ItemStack.field_190927_a : error.getRecursedPattern().getStack())), id, quantity, false));
                } else if (noPreview && !task.hasMissing()) {
                    this.network.getCraftingManager().start(task);
                    RS.NETWORK_HANDLER.sendTo(player, new GridCraftingStartResponseMessage());
                } else {
                    RS.NETWORK_HANDLER.sendTo(player, new GridCraftingPreviewResponseMessage(factoryId, task.getPreviewStacks(), id, quantity, false));
                }
            }, "RS crafting preview calculation");
            calculationThread.start();
        }
    }

    @Override
    public void onCraftingRequested(ServerPlayerEntity player, UUID id, int quantity) {
        if (quantity <= 0 || !this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (PlayerEntity)player)) {
            return;
        }
        ItemStack stack = this.network.getItemStorageCache().getCraftablesList().get(id);
        if (stack != null) {
            ICraftingTask task = this.network.getCraftingManager().create(stack, quantity);
            if (task == null) {
                return;
            }
            ICraftingTaskError error = task.calculate();
            if (error == null && !task.hasMissing()) {
                this.network.getCraftingManager().start(task);
            }
        }
    }

    @Override
    public void onCraftingCancelRequested(ServerPlayerEntity player, @Nullable UUID id) {
        if (!this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (PlayerEntity)player)) {
            return;
        }
        this.network.getCraftingManager().cancel(id);
        this.network.getNetworkItemManager().drainEnergy((PlayerEntity)player, id == null ? RS.SERVER_CONFIG.getWirelessCraftingMonitor().getCancelAllUsage() : RS.SERVER_CONFIG.getWirelessCraftingMonitor().getCancelUsage());
    }
}

