/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.INetworkManager;
import com.refinedmods.refinedstorage.api.network.NetworkType;
import com.refinedmods.refinedstorage.apiimpl.network.Network;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkManager
extends WorldSavedData
implements INetworkManager {
    public static final String NAME = "refinedstorage_networks";
    private static final String NBT_NETWORKS = "Networks";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_DATA = "Data";
    private static final String NBT_POS = "Pos";
    private final World world;
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ConcurrentHashMap<BlockPos, INetwork> networks = new ConcurrentHashMap();

    public NetworkManager(String name, World world) {
        super(name);
        this.world = world;
    }

    public void func_76184_a(CompoundNBT tag) {
        if (tag.func_74764_b(NBT_NETWORKS)) {
            ListNBT networksTag = tag.func_150295_c(NBT_NETWORKS, 10);
            this.networks.clear();
            for (int i = 0; i < networksTag.size(); ++i) {
                CompoundNBT networkTag = networksTag.func_150305_b(i);
                CompoundNBT data = networkTag.func_74775_l(NBT_DATA);
                BlockPos pos = BlockPos.func_218283_e((long)networkTag.func_74763_f(NBT_POS));
                int type = networkTag.func_74762_e(NBT_TYPE);
                INetwork network = new Network(this.world, pos, NetworkType.values()[type]);
                try {
                    network = network.readFromNbt(data);
                }
                catch (Throwable t) {
                    this.logger.error("Error while reading network", t);
                }
                this.networks.put(pos, network);
            }
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT tag) {
        ListNBT list = new ListNBT();
        for (INetwork network : this.all()) {
            try {
                CompoundNBT networkTag = new CompoundNBT();
                networkTag.func_74772_a(NBT_POS, network.getPosition().func_218275_a());
                networkTag.func_218657_a(NBT_DATA, (INBT)network.writeToNbt(new CompoundNBT()));
                networkTag.func_74768_a(NBT_TYPE, network.getType().ordinal());
                list.add((Object)networkTag);
            }
            catch (Throwable t) {
                this.logger.error("Error while saving network", t);
            }
        }
        tag.func_218657_a(NBT_NETWORKS, (INBT)list);
        return tag;
    }

    @Override
    @Nullable
    public INetwork getNetwork(BlockPos pos) {
        return this.networks.get(pos);
    }

    @Override
    public void removeNetwork(BlockPos pos) {
        if (pos == null) {
            throw new IllegalArgumentException("Position cannot be null");
        }
        this.networks.remove(pos);
    }

    @Override
    public void setNetwork(BlockPos pos, INetwork network) {
        if (pos == null) {
            throw new IllegalArgumentException("Position cannot be null");
        }
        if (network == null) {
            throw new IllegalArgumentException("Network cannot be null");
        }
        this.networks.put(pos, network);
    }

    @Override
    public Collection<INetwork> all() {
        return this.networks.values();
    }

    @Override
    public void markForSaving() {
        this.func_76185_a();
    }
}

