/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting;

import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternChain;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternChainList;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.CraftingPatternChain;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CraftingPatternChainList
implements ICraftingPatternChainList {
    private final Map<Key, CraftingPatternChain> map = new HashMap<Key, CraftingPatternChain>();

    public CraftingPatternChainList(Collection<ICraftingPattern> patterns) {
        for (ICraftingPattern pattern : patterns) {
            Key key = new Key(pattern);
            CraftingPatternChain chain = this.map.get(key);
            if (chain == null) {
                chain = new CraftingPatternChain();
                this.map.put(key, chain);
            }
            chain.addPattern(pattern);
        }
    }

    @Override
    public ICraftingPatternChain getChain(ICraftingPattern pattern) {
        ICraftingPatternChain chain = this.map.get(new Key(pattern));
        if (chain == null) {
            throw new IllegalStateException("Pattern was not found in pattern chain");
        }
        return chain;
    }

    private static class Key {
        private final ICraftingPattern pattern;

        public Key(ICraftingPattern pattern) {
            this.pattern = pattern;
        }

        public boolean equals(Object other) {
            return other instanceof Key && this.pattern.canBeInChainWith(((Key)other).pattern);
        }

        public int hashCode() {
            return this.pattern.getChainHashCode();
        }
    }
}

