/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.mysticaladaptations.item.extractor;

import com.focamacho.mysticaladaptations.item.extractor.SeedExtractorItem;
import com.focamacho.mysticaladaptations.item.extractor.SeedExtractorRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SeedExtractorRecipeHandler {
    public static List<SeedExtractorRecipe> allRecipes = new ArrayList<SeedExtractorRecipe>();

    public static void initRecipes() {
        allRecipes.clear();
    }

    public static Item getSeedFromBlock(SeedExtractorItem extractor, Item blockItem, Block block) {
        for (SeedExtractorRecipe recipe : allRecipes) {
            for (ResourceLocation tag : recipe.getTagList()) {
                if (blockItem.getTags().contains(tag)) {
                    return extractor.getTier() >= recipe.getTier() ? recipe.getSeed() : null;
                }
                if (!block.getTags().contains(tag)) continue;
                return extractor.getTier() >= recipe.getTier() ? recipe.getSeed() : null;
            }
            for (Block blockR : recipe.getBlockList()) {
                if (!blockR.equals(block)) continue;
                return extractor.getTier() >= recipe.getTier() ? recipe.getSeed() : null;
            }
        }
        return null;
    }

    @SubscribeEvent
    public void onLivingDropsEvent(LivingDropsEvent event) {
        Item seed;
        PlayerEntity player;
        if (event.getSource().func_76346_g() instanceof PlayerEntity && (player = (PlayerEntity)event.getSource().func_76346_g()).func_184614_ca().func_77973_b() instanceof SeedExtractorItem && (seed = SeedExtractorRecipeHandler.getItemFromEntity(ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)event.getEntity().func_200600_R()), (SeedExtractorItem)player.func_184614_ca().func_77973_b())) != null) {
            Entity entity = event.getEntity();
            event.getDrops().add(new ItemEntity(entity.field_70170_p, (double)entity.field_70118_ct, (double)entity.field_70117_cu, (double)entity.field_70116_cv, new ItemStack((IItemProvider)seed)));
        }
    }

    public static Item getItemFromEntity(ResourceLocation entity, SeedExtractorItem extractor) {
        for (SeedExtractorRecipe recipe : allRecipes) {
            for (ResourceLocation entityName : recipe.getEntityList()) {
                if (!entityName.equals((Object)entity)) continue;
                return extractor.getTier() >= recipe.getTier() ? recipe.getSeed() : null;
            }
        }
        return null;
    }
}

