/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.mysticaladaptations.item.extractor;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class SeedExtractorRecipe {
    private List<Block> blockList;
    private List<ResourceLocation> tagList;
    private List<ResourceLocation> entityList;
    private Item seed;
    private Integer tier;

    public SeedExtractorRecipe(List<String> config, Item seed, int tier) {
        this.blockList = SeedExtractorRecipe.getBlocksFromConfig(config);
        this.tagList = SeedExtractorRecipe.getTagsFromConfig(config);
        this.entityList = SeedExtractorRecipe.getEntitiesFromConfig(config);
        this.seed = seed;
        this.tier = tier;
    }

    private static List<Block> getBlocksFromConfig(List<String> config) {
        ArrayList<Block> allBlocks = new ArrayList<Block>();
        for (String block : config) {
            String[] split;
            if (block.startsWith("tag:") || block.startsWith("entity") || (split = block.split(":")).length != 2 || ForgeRegistries.BLOCKS.getValue(new ResourceLocation(split[0], split[1])) == null) continue;
            allBlocks.add(((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(split[0], split[1]))).getBlock());
        }
        return allBlocks;
    }

    private static List<ResourceLocation> getTagsFromConfig(List<String> config) {
        ArrayList<ResourceLocation> allTags = new ArrayList<ResourceLocation>();
        for (String tag : config) {
            if (!tag.startsWith("tag:")) continue;
            String[] split = tag.split(":");
            allTags.add(new ResourceLocation(split[1], split[2]));
        }
        return allTags;
    }

    private static List<ResourceLocation> getEntitiesFromConfig(List<String> config) {
        ArrayList<ResourceLocation> allEntities = new ArrayList<ResourceLocation>();
        for (String entity : config) {
            if (!entity.startsWith("entity")) continue;
            String[] split = entity.split(":");
            for (EntityType entityType : ForgeRegistries.ENTITIES.getValues()) {
                if (!entityType.getRegistryName().equals((Object)new ResourceLocation(split[1], split[2]))) continue;
                allEntities.add(entityType.getRegistryName());
            }
        }
        return allEntities;
    }

    public List<Block> getBlockList() {
        return this.blockList;
    }

    public List<ResourceLocation> getTagList() {
        return this.tagList;
    }

    public List<ResourceLocation> getEntityList() {
        return this.entityList;
    }

    public Item getSeed() {
        return this.seed;
    }

    public Integer getTier() {
        return this.tier;
    }
}

