/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.utils;

import fr.raksrinana.fallingtree.config.Config;
import fr.raksrinana.fallingtree.config.ToolConfiguration;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class FallingTreeUtils {
    public static Set<Item> getAsItems(Collection<? extends String> names) {
        return names.stream().map(FallingTreeUtils::getItem).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Nullable
    public static Item getItem(String name) {
        try {
            return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Set<Block> getAsBlocks(Collection<? extends String> names) {
        return names.stream().map(FallingTreeUtils::getBlock).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Nullable
    public static Block getBlock(String name) {
        try {
            return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(name));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isTreeBlock(@Nonnull Block block) {
        boolean isWhitelistedBlock;
        boolean bl = isWhitelistedBlock = block.func_203417_a(BlockTags.field_200031_h) || Config.COMMON.getTreesConfiguration().getWhitelistedLogs().stream().anyMatch(log -> log.equals(block));
        if (isWhitelistedBlock) {
            boolean isBlacklistedBlock = Config.COMMON.getTreesConfiguration().getBlacklistedLogs().stream().anyMatch(log -> log.equals(block));
            return !isBlacklistedBlock;
        }
        return false;
    }

    public static boolean isLeafBlock(@Nonnull Block block) {
        boolean isWhitelistedBlock;
        boolean bl = isWhitelistedBlock = block.func_203417_a(BlockTags.field_206952_E) || Config.COMMON.getTreesConfiguration().getWhitelistedLeaves().stream().anyMatch(leaf -> leaf.equals(block));
        if (isWhitelistedBlock) {
            boolean isBlacklistedBlock = Config.COMMON.getTreesConfiguration().getBlacklistedLeaves().stream().anyMatch(leaf -> leaf.equals(block));
            return !isBlacklistedBlock;
        }
        return false;
    }

    public static boolean canPlayerBreakTree(@Nonnull PlayerEntity player) {
        boolean isWhitelistedTool;
        ToolConfiguration toolConfiguration = Config.COMMON.getToolsConfiguration();
        Item heldItem = player.func_184586_b(Hand.MAIN_HAND).func_77973_b();
        boolean bl = isWhitelistedTool = toolConfiguration.isIgnoreTools() || heldItem instanceof AxeItem || toolConfiguration.getWhitelisted().stream().anyMatch(tool -> tool.equals(heldItem));
        if (isWhitelistedTool) {
            boolean isBlacklistedTool = toolConfiguration.getBlacklisted().stream().anyMatch(tool -> tool.equals(heldItem));
            return !isBlacklistedTool;
        }
        return false;
    }
}

