/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.tree;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class Tree {
    private final World world;
    private final Set<BlockPos> logs;
    private final BlockPos hitPos;

    public Tree(@Nonnull World world, @Nonnull BlockPos blockPos) {
        this.world = world;
        this.hitPos = blockPos;
        this.logs = new LinkedHashSet<BlockPos>();
    }

    public void addLog(@Nullable BlockPos blockPos) {
        if (Objects.nonNull(blockPos)) {
            this.logs.add(blockPos);
        }
    }

    public int getLogCount() {
        return this.logs.size();
    }

    public Optional<BlockPos> getTopMostFurthestLog() {
        return this.getTopMostLog().flatMap(topMost -> this.logs.stream().filter(log -> Objects.equals(log.func_177956_o(), topMost.func_177956_o())).max(Comparator.comparingInt(this::getDistanceFromHit)));
    }

    public Optional<BlockPos> getTopMostLog() {
        return this.logs.stream().max(Comparator.comparingInt(Vec3i::func_177956_o));
    }

    public int getDistanceFromHit(BlockPos pos) {
        return Math.abs(this.hitPos.func_177958_n() - pos.func_177958_n()) + Math.abs(this.hitPos.func_177956_o() - pos.func_177956_o()) + Math.abs(this.hitPos.func_177952_p() - pos.func_177952_p());
    }

    @Nonnull
    public BlockPos getHitPos() {
        return this.hitPos;
    }

    @Nonnull
    public World getWorld() {
        return this.world;
    }

    @Nonnull
    public Collection<BlockPos> getLogs() {
        return this.logs;
    }
}

