/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree;

import fr.raksrinana.fallingtree.config.BreakMode;
import fr.raksrinana.fallingtree.config.Config;
import fr.raksrinana.fallingtree.tree.Tree;
import fr.raksrinana.fallingtree.tree.TreeHandler;
import fr.raksrinana.fallingtree.utils.CachedSpeed;
import fr.raksrinana.fallingtree.utils.FallingTreeUtils;
import fr.raksrinana.fallingtree.utils.LeafBreakingSchedule;
import io.netty.util.internal.ConcurrentSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="falling_tree", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ForgeEventSubscriber {
    private static final Set<LeafBreakingSchedule> scheduledLeavesBreaking = new ConcurrentSet();
    private static final Map<UUID, CachedSpeed> speedCache = new HashMap<UUID, CachedSpeed>();

    @SubscribeEvent
    public static void onBreakSpeed(@Nonnull PlayerEvent.BreakSpeed event) {
        CachedSpeed cachedSpeed;
        if (!event.isCanceled() && Config.COMMON.getTreesConfiguration().getBreakMode() == BreakMode.INSTANTANEOUS && ForgeEventSubscriber.isPlayerInRightState(event.getPlayer()) && Objects.nonNull(cachedSpeed = speedCache.compute(event.getPlayer().func_110124_au(), (pos, speed) -> {
            if (Objects.isNull(speed) || !speed.isValid(event.getPos())) {
                speed = ForgeEventSubscriber.getSpeed(event);
            }
            return speed;
        }))) {
            event.setNewSpeed(cachedSpeed.getSpeed());
        }
    }

    private static CachedSpeed getSpeed(PlayerEvent.BreakSpeed event) {
        double speedMultiplicand = Config.COMMON.getToolsConfiguration().getSpeedMultiplicand();
        return speedMultiplicand <= 0.0 ? null : (CachedSpeed)TreeHandler.getTree(event.getEntity().func_130014_f_(), event.getPos()).map(tree -> new CachedSpeed(event.getPos(), event.getOriginalSpeed() / ((float)speedMultiplicand * (float)tree.getLogCount()))).orElse(null);
    }

    @SubscribeEvent
    public static void onBlockBreakEvent(@Nonnull BlockEvent.BreakEvent event) {
        if (!event.isCanceled() && !event.getWorld().func_201670_d() && ForgeEventSubscriber.isPlayerInRightState(event.getPlayer()) && event.getWorld() instanceof World) {
            TreeHandler.getTree((World)event.getWorld(), event.getPos()).ifPresent(tree -> {
                BreakMode breakMode = Config.COMMON.getTreesConfiguration().getBreakMode();
                if (breakMode == BreakMode.INSTANTANEOUS) {
                    ForgeEventSubscriber.breakInstant(event, tree);
                } else if (breakMode == BreakMode.SHIFT_DOWN) {
                    ForgeEventSubscriber.breakShiftDown(event, tree);
                }
            });
        }
    }

    private static void breakInstant(BlockEvent.BreakEvent event, Tree tree) {
        if (Config.COMMON.getTreesConfiguration().getMaxSize() >= tree.getLogCount()) {
            if (!TreeHandler.destroyInstant(tree, event.getPlayer(), event.getPlayer().func_184586_b(Hand.MAIN_HAND))) {
                event.setCanceled(true);
            }
        } else {
            event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("chat.falling_tree.tree_too_big", new Object[]{tree.getLogCount(), Config.COMMON.getTreesConfiguration().getMaxSize()}));
        }
    }

    private static void breakShiftDown(BlockEvent.BreakEvent event, Tree tree) {
        TreeHandler.destroyShift(tree, event.getPlayer(), event.getPlayer().func_184586_b(Hand.MAIN_HAND));
        event.setCanceled(true);
    }

    private static boolean isPlayerInRightState(PlayerEntity player) {
        if (player.field_71075_bZ.field_75098_d && !Config.COMMON.isBreakInCreative()) {
            return false;
        }
        if (Config.COMMON.isReverseSneaking() != player.func_225608_bj_()) {
            return false;
        }
        return FallingTreeUtils.canPlayerBreakTree(player);
    }

    @SubscribeEvent
    public static void onNeighborNotifyEvent(BlockEvent.NeighborNotifyEvent event) {
        if (Config.COMMON.getTreesConfiguration().isLeavesBreaking() && !event.getWorld().func_201670_d() && event.getWorld() instanceof ServerWorld) {
            BlockPos eventPos;
            ServerWorld world = (ServerWorld)event.getWorld();
            BlockState eventState = event.getState();
            Block eventBlock = eventState.func_177230_c();
            if (eventBlock.isAir(eventState, (IBlockReader)world, eventPos = event.getPos())) {
                for (Direction facing : event.getNotifiedSides()) {
                    BlockState neighborState;
                    BlockPos neighborPos = eventPos.func_177972_a(facing);
                    if (!world.isAreaLoaded(neighborPos, 1) || !FallingTreeUtils.isLeafBlock((neighborState = event.getWorld().func_180495_p(neighborPos)).func_177230_c())) continue;
                    scheduledLeavesBreaking.add(new LeafBreakingSchedule(world, neighborPos, 4));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END) {
            Iterator<LeafBreakingSchedule> leavesBreak = scheduledLeavesBreaking.iterator();
            while (leavesBreak.hasNext()) {
                LeafBreakingSchedule leafBreakingSchedule = leavesBreak.next();
                ServerWorld world = leafBreakingSchedule.getWorld();
                if (leafBreakingSchedule.getRemainingTicks() <= 0) {
                    if (world.isAreaLoaded(leafBreakingSchedule.getBlockPos(), 1)) {
                        BlockState state = world.func_180495_p(leafBreakingSchedule.getBlockPos());
                        state.func_227033_a_(world, leafBreakingSchedule.getBlockPos(), world.func_201674_k());
                        if (state.func_204519_t()) {
                            state.func_227034_b_(world, leafBreakingSchedule.getBlockPos(), world.func_201674_k());
                        }
                    }
                    leavesBreak.remove();
                    continue;
                }
                leafBreakingSchedule.tick();
            }
        }
    }
}

