/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.google.common.collect.ImmutableMap;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.moddiscovery.CoreModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileParser;
import net.minecraftforge.fml.loading.moddiscovery.Scanner;
import net.minecraftforge.fml.loading.progress.StartupMessageManager;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.IModLanguageProvider;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import net.minecraftforge.forgespi.locating.ModFileFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModFile
implements IModFile {
    private static final Manifest DEFAULTMANIFEST;
    private static final Logger LOGGER;
    private final String jarVersion;
    private final ModFileFactory.ModFileInfoParser parser;
    private Map<String, Object> fileProperties;
    private IModLanguageProvider loader;
    private Throwable scanError;
    private final Path filePath;
    private final IModFile.Type modFileType;
    private final Manifest manifest;
    private final IModLocator locator;
    private IModFileInfo modFileInfo;
    private ModFileScanData fileModFileScanData;
    private CompletableFuture<ModFileScanData> futureScanResult;
    private List<CoreModFile> coreMods;
    private Path accessTransformer;
    public static final Attributes.Name TYPE;

    public ModFile(Path file, IModLocator locator, ModFileFactory.ModFileInfoParser parser) {
        this.locator = locator;
        this.filePath = file;
        this.parser = parser;
        this.manifest = locator.findManifest(file).orElse(DEFAULTMANIFEST);
        if (this.manifest != DEFAULTMANIFEST) {
            LOGGER.debug(LogMarkers.SCAN, "Mod file {} has a manifest", (Object)file);
        } else {
            LOGGER.debug(LogMarkers.SCAN, "Mod file {} is missing a manifest", (Object)file);
        }
        Optional<String> value = Optional.ofNullable(this.manifest.getMainAttributes().getValue(TYPE));
        this.modFileType = IModFile.Type.valueOf((String)value.orElse("MOD"));
        this.jarVersion = Optional.ofNullable(this.manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION)).orElse("NONE");
    }

    public Supplier<Map<String, Object>> getSubstitutionMap() {
        return () -> ImmutableMap.builder().put((Object)"jarVersion", (Object)this.jarVersion).putAll(this.fileProperties).build();
    }

    public IModFile.Type getType() {
        return this.modFileType;
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public List<IModInfo> getModInfos() {
        return this.modFileInfo.getMods();
    }

    public Optional<Path> getAccessTransformer() {
        return Optional.ofNullable(Files.exists(this.accessTransformer, new LinkOption[0]) ? this.accessTransformer : null);
    }

    public boolean identifyMods() {
        this.modFileInfo = ModFileParser.readModList(this, this.parser);
        if (this.modFileInfo == null) {
            return false;
        }
        LOGGER.debug(LogMarkers.LOADING, "Loading mod file {} with language {}", (Object)this.getFilePath(), (Object)this.modFileInfo.getModLoader());
        this.coreMods = ModFileParser.getCoreMods(this);
        this.coreMods.forEach(mi -> LOGGER.debug(LogMarkers.LOADING, "Found coremod {}", (Object)mi.getPath()));
        this.accessTransformer = this.locator.findPath((IModFile)this, new String[]{"META-INF", "accesstransformer.cfg"});
        return true;
    }

    public List<CoreModFile> getCoreMods() {
        return this.coreMods;
    }

    public ModFileScanData compileContent() {
        return new Scanner(this).scan();
    }

    public void scanFile(Consumer<Path> pathConsumer) {
        this.locator.scanFile((IModFile)this, pathConsumer);
    }

    public void setFutureScanResult(CompletableFuture<ModFileScanData> future) {
        this.futureScanResult = future;
    }

    public ModFileScanData getScanResult() {
        if (this.futureScanResult != null) {
            try {
                this.futureScanResult.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        if (this.scanError != null) {
            throw new RuntimeException(this.scanError);
        }
        return this.fileModFileScanData;
    }

    public void setScanResult(ModFileScanData modFileScanData, Throwable throwable) {
        this.futureScanResult = null;
        this.fileModFileScanData = modFileScanData;
        if (throwable != null) {
            this.scanError = throwable;
        }
        StartupMessageManager.modLoaderConsumer().ifPresent(c -> c.accept("Completed deep scan of " + this.getFileName()));
    }

    public void setFileProperties(Map<String, Object> fileProperties) {
        this.fileProperties = fileProperties;
    }

    public IModLanguageProvider getLoader() {
        return this.loader;
    }

    public Path findResource(String className) {
        return this.locator.findPath((IModFile)this, new String[]{className});
    }

    public void identifyLanguage() {
        this.loader = FMLLoader.getLanguageLoadingProvider().findLanguage(this, this.modFileInfo.getModLoader(), this.modFileInfo.getModLoaderVersion());
    }

    public String toString() {
        return "Mod File: " + Objects.toString(this.filePath);
    }

    public String getFileName() {
        return this.getFilePath().getFileName().toString();
    }

    public IModLocator getLocator() {
        return this.locator;
    }

    public IModFileInfo getModFileInfo() {
        return this.modFileInfo;
    }

    public static ModFileFactory buildFactory() {
        return ModFile::new;
    }

    public static ModFile newFMLInstance(Path path, IModLocator locator) {
        return (ModFile)ModFileFactory.FACTORY.build(path, locator, ModFileParser::modsTomlParser);
    }

    static {
        LOGGER = LogManager.getLogger();
        DEFAULTMANIFEST = new Manifest();
        DEFAULTMANIFEST.getMainAttributes().putValue("FMLModType", "MOD");
        TYPE = new Attributes.Name("FMLModType");
    }
}

