/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.blur;

import com.tterrag.blur.BlurConfig;
import com.tterrag.blur.util.ShaderResourcePack;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.resources.ClientResourcePackInfo;
import net.minecraft.client.shader.Shader;
import net.minecraft.client.shader.ShaderDefault;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.PackCompatibility;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;

@Mod(value="blur")
public class Blur {
    public static final String MODID = "blur";
    public static final String MOD_NAME = "Blur";
    public static final String VERSION = "@VERSION@";
    public static Blur instance;
    private Field _listShaders;
    private long start;
    @Nonnull
    private ShaderResourcePack dummyPack = new ShaderResourcePack();
    private float prevProgress = -1.0f;

    public Blur() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
            MinecraftForge.EVENT_BUS.register((Object)this);
            ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, BlurConfig.clientSpec);
            ResourcePackList rps = (ResourcePackList)ObfuscationReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String)"field_110448_aq");
            rps.func_198982_a(new IPackFinder(){

                public <T extends ResourcePackInfo> void func_195730_a(Map<String, T> nameToPackMap, ResourcePackInfo.IFactory<T> packInfoFactory) {
                    NativeImage img = null;
                    try {
                        img = NativeImage.func_195713_a((InputStream)Blur.this.dummyPack.func_195763_b("pack.png"));
                    }
                    catch (IOException e) {
                        LogManager.getLogger().error("Could not load blur's pack.png", (Throwable)e);
                    }
                    ClientResourcePackInfo var3 = new ClientResourcePackInfo(Blur.MODID, true, () -> Blur.this.dummyPack, (ITextComponent)new StringTextComponent(Blur.this.dummyPack.func_195762_a()), (ITextComponent)new StringTextComponent("Default shaders for Blur"), PackCompatibility.COMPATIBLE, ResourcePackInfo.Priority.BOTTOM, true, img);
                    if (var3 != null) {
                        nameToPackMap.put(Blur.MODID, var3);
                    }
                }
            });
        });
        instance = this;
    }

    @SubscribeEvent
    public void preInit(FMLClientSetupEvent event) {
        ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)this.dummyPack);
    }

    @SubscribeEvent
    public void onGuiChange(GuiOpenEvent event) throws SecurityException {
        if (this._listShaders == null) {
            this._listShaders = ObfuscationReflectionHelper.findField(ShaderGroup.class, (String)"field_148031_d");
        }
        if (Minecraft.func_71410_x().field_71441_e != null) {
            boolean excluded;
            GameRenderer er = Minecraft.func_71410_x().field_71460_t;
            boolean bl = excluded = event.getGui() == null || ((List)BlurConfig.CLIENT.guiExclusions.get()).contains(event.getGui().getClass().getName());
            if (er.func_147706_e() == null && !excluded) {
                er.func_175069_a(new ResourceLocation("shaders/post/fade_in_blur.json"));
                this.updateUniform("Radius", ((Integer)BlurConfig.CLIENT.radius.get()).intValue());
                this.start = System.currentTimeMillis();
            } else if (er.func_147706_e() != null && excluded) {
                er.func_181022_b();
            }
        }
    }

    private float getProgress() {
        return Math.min((float)(System.currentTimeMillis() - this.start) / (float)((Integer)BlurConfig.CLIENT.fadeTime.get()).intValue(), 1.0f);
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        float progress;
        if (event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71462_r != null && Minecraft.func_71410_x().field_71460_t.func_147706_e() != null && (progress = this.getProgress()) != this.prevProgress) {
            this.prevProgress = progress;
            this.updateUniform("Progress", progress);
        }
    }

    public void updateUniform(String name, float value) {
        if (this._listShaders == null) {
            return;
        }
        ShaderGroup sg = Minecraft.func_71410_x().field_71460_t.func_147706_e();
        try {
            List shaders = (List)this._listShaders.get(sg);
            for (Shader s : shaders) {
                ShaderDefault su = s.func_217624_b().func_216538_b(name);
                if (su == null) continue;
                su.func_148090_a(value);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getBackgroundColor(boolean second) {
        int color = second ? BlurConfig.colorFirst : BlurConfig.colorSecond;
        int a = color >>> 24;
        int r = color >> 16 & 0xFF;
        int b = color >> 8 & 0xFF;
        int g = color & 0xFF;
        float prog = instance.getProgress();
        a = (int)((float)a * prog);
        r = (int)((float)r * prog);
        g = (int)((float)g * prog);
        b = (int)((float)b * prog);
        return a << 24 | r << 16 | b << 8 | g;
    }
}

