/*
 * Decompiled with CFR 0.152.
 */
package net.nerds.fishtraps.blocks.BaseTrap;

import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.nerds.fishtraps.blocks.BaseTrap.BaseFishTrapBlock;
import net.nerds.fishtraps.items.FishBait;
import net.nerds.fishtraps.util.FishTrapInventory;
import net.nerds.fishtraps.util.FishTrapsConfig;

public abstract class BaseFishTrapTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private FishTrapInventory inventory = new FishTrapInventory(this);
    private LazyOptional inventoryHolder = LazyOptional.of(() -> this.inventory.getItemHandler());
    private long tickCounter = 0L;
    private long tickCheck;
    private int luckOfTheSeaLevel;
    private int lureLevel;
    private boolean shouldPenalize;
    private int penaltyMultiplier;
    private int penaltyTickCheck;
    private boolean showFishBait = false;

    public BaseFishTrapTileEntity(TileEntityType tileEntityType, long delay, int lure, int luck) {
        super(tileEntityType);
        this.luckOfTheSeaLevel = luck;
        this.lureLevel = lure;
        this.shouldPenalize = (Boolean)FishTrapsConfig.FISH_TRAPS_CONFIG.shouldTrapHavePenalty.get();
        this.penaltyMultiplier = (Integer)FishTrapsConfig.FISH_TRAPS_CONFIG.trapPenaltyMultiplier.get();
        this.penaltyTickCheck = (int)delay * this.penaltyMultiplier;
        this.tickCheck = delay;
    }

    public void func_73660_a() {
        if (this.tickCounter >= this.getValidationNumber()) {
            this.tickCounter = 0L;
            this.validateWaterAndFish();
        } else {
            ++this.tickCounter;
        }
    }

    private long getValidationNumber() {
        boolean bl = this.showFishBait = ((ItemStack)this.inventory.getInventory().get(0)).func_190916_E() > 0;
        if (!this.showFishBait && this.shouldPenalize) {
            return this.penaltyTickCheck;
        }
        return this.tickCheck;
    }

    private void validateWaterAndFish() {
        if (!this.field_145850_b.field_72995_K) {
            boolean isSurroundedByWater = true;
            Iterable waterCheckInterator = BlockPos.func_218278_a((BlockPos)new BlockPos(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 1), (BlockPos)new BlockPos(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 1));
            for (BlockPos blockPos : waterCheckInterator) {
                Block block = this.field_145850_b.func_180495_p(blockPos).func_177230_c();
                if (this.field_145850_b.func_175625_s(this.field_174879_c) == null || block == Blocks.field_150355_j || block instanceof BaseFishTrapBlock) continue;
                isSurroundedByWater = false;
                break;
            }
            if (isSurroundedByWater) {
                this.fish();
            }
        }
    }

    private void fish() {
        ItemStack itemStack = new ItemStack((IItemProvider)Items.field_151112_aM);
        itemStack.func_77966_a(Enchantments.field_151369_A, this.lureLevel);
        itemStack.func_77966_a(Enchantments.field_151370_z, this.luckOfTheSeaLevel);
        LootContext.Builder lootContextBuilder = new LootContext.Builder((ServerWorld)this.field_145850_b).func_216015_a(LootParameters.field_216286_f, (Object)new BlockPos((Vec3i)this.field_174879_c)).func_216015_a(LootParameters.field_216289_i, (Object)itemStack).func_216023_a(this.field_145850_b.field_73012_v).func_186469_a((float)this.lureLevel);
        LootTable lootTable = Objects.requireNonNull(this.field_145850_b.func_73046_m()).func_200249_aQ().func_186521_a(LootTables.field_186387_al);
        List list = lootTable.func_216113_a(lootContextBuilder.func_216022_a(LootParameterSets.field_216262_c));
        this.inventory.getItemHandler().addListToInventory(list);
        ItemStack fishBait = this.inventory.func_70301_a(0);
        if (fishBait.func_77973_b() instanceof FishBait && fishBait.func_96631_a(1, this.field_145850_b.field_73012_v, null)) {
            this.inventory.func_70299_a(0, ItemStack.field_190927_a);
            this.func_70296_d();
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.inventory.getInventory());
        return compound;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.inventory.setInventory((NonNullList<ItemStack>)NonNullList.func_191197_a((int)this.getInventory().func_70302_i_(), (Object)ItemStack.field_190927_a));
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.inventory.getInventory());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (side == Direction.DOWN || side == Direction.UP) {
            return cap.orEmpty(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.inventoryHolder);
        }
        return LazyOptional.empty();
    }

    public FishTrapInventory getInventory() {
        return this.inventory;
    }
}

