/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.obfuscate.client;

import com.mrcrayfish.obfuscate.Obfuscate;
import com.mrcrayfish.obfuscate.client.model.CustomBipedModel;
import com.mrcrayfish.obfuscate.client.model.CustomPlayerModel;
import com.mrcrayfish.obfuscate.client.util.PlayerModelUtil;
import com.mrcrayfish.obfuscate.common.data.SyncedPlayerData;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ClientHandler {
    private static ClientHandler instance;

    public static ClientHandler instance() {
        if (instance == null) {
            instance = new ClientHandler();
        }
        return instance;
    }

    private ClientHandler() {
    }

    public void setup() {
        Obfuscate.LOGGER.info("Starting to patch player models...");
        PlayerModelUtil.modifyPlayerModel((renderer, layers, slim) -> {
            CustomPlayerModel model = new CustomPlayerModel(0.0f, slim);
            layers.removeIf(layer -> layer instanceof BipedArmorLayer);
            layers.add(new BipedArmorLayer((IEntityRenderer)renderer, new CustomBipedModel(model, 0.5f), new CustomBipedModel(model, 1.0f)));
            ObfuscationReflectionHelper.setPrivateValue(LivingRenderer.class, (Object)renderer, (Object)((Object)model), (String)"field_77045_g");
            Obfuscate.LOGGER.info("Patched " + (slim ? "slim" : "default") + " model successfully");
        });
    }

    public void updatePlayerData(int entityId, List<SyncedPlayerData.DataEntry<?>> entries) {
        Entity entity;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && (entity = world.func_73045_a(entityId)) instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            entries.forEach(entry -> SyncedPlayerData.instance().updateClientEntry(player, entry));
        }
    }
}

