/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.Da_Technomancer.essentials.tileentities.AbstractShifterTileEntity;
import com.Da_Technomancer.essentials.tileentities.AbstractSplitterTE;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="essentials")
public class BasicItemSplitterTileEntity
extends AbstractSplitterTE {
    @ObjectHolder(value="basic_item_splitter")
    private static TileEntityType<BasicItemSplitterTileEntity> TYPE = null;
    public static final int[] MODES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
    private ItemStack[] inventory = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a};
    private LazyOptional<IItemHandler> primaryOpt = LazyOptional.of(() -> new OutItemHandler(1));
    private LazyOptional<IItemHandler> secondaryOpt = LazyOptional.of(() -> new OutItemHandler(0));
    private LazyOptional<IItemHandler> inOpt = LazyOptional.of(() -> new InHandler());
    private int transfered = 0;

    public BasicItemSplitterTileEntity(TileEntityType<? extends AbstractSplitterTE> type) {
        super(type);
    }

    public BasicItemSplitterTileEntity() {
        this(TYPE);
    }

    @Override
    protected int[] getModes() {
        return MODES;
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.primaryOpt.invalidate();
        this.secondaryOpt.invalidate();
        this.inOpt.invalidate();
        this.primaryOpt = LazyOptional.of(() -> new OutItemHandler(1));
        this.secondaryOpt = LazyOptional.of(() -> new OutItemHandler(0));
        this.inOpt = LazyOptional.of(() -> new InHandler());
    }

    public void func_73660_a() {
        if (this.endPos[0] == null || this.endPos[1] == null) {
            this.refreshCache();
        }
        Direction dir = this.getFacing();
        for (int i = 0; i < 2; ++i) {
            this.inventory[i] = AbstractShifterTileEntity.ejectItem(this.field_145850_b, this.endPos[i], i == 0 ? dir : dir.func_176734_d(), this.inventory[i]);
        }
        this.func_70296_d();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.primaryOpt.invalidate();
        this.secondaryOpt.invalidate();
        this.inOpt.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            Direction dir = this.getFacing();
            return side == dir ? this.primaryOpt : (side == dir.func_176734_d() ? this.secondaryOpt : this.inOpt);
        }
        return super.getCapability(cap, side);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("type", (byte)1);
        nbt.func_74768_a("mode", this.mode);
        nbt.func_74768_a("transfered", this.transfered);
        for (int i = 0; i < 2; ++i) {
            if (this.inventory[i].func_190926_b()) continue;
            CompoundNBT inner = new CompoundNBT();
            this.inventory[i].func_77955_b(inner);
            nbt.func_218657_a("inv_" + i, (INBT)inner);
        }
        return nbt;
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.mode = nbt.func_74771_c("type") == 1 ? nbt.func_74762_e("mode") : 3 + 3 * nbt.func_74762_e("mode");
        this.transfered = nbt.func_74762_e("transfered");
        for (int i = 0; i < 2; ++i) {
            this.inventory[i] = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("inv_" + i));
        }
    }

    @Override
    public int getBase() {
        return 12;
    }

    protected class OutItemHandler
    implements IItemHandler {
        private final int index;

        private OutItemHandler(int index) {
            this.index = index;
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return slot != 0 ? ItemStack.field_190927_a : BasicItemSplitterTileEntity.this.inventory[this.index];
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot != 0) {
                return ItemStack.field_190927_a;
            }
            int moved = Math.min(amount, BasicItemSplitterTileEntity.this.inventory[this.index].func_190916_E());
            if (simulate) {
                return new ItemStack((IItemProvider)BasicItemSplitterTileEntity.this.inventory[this.index].func_77973_b(), moved, BasicItemSplitterTileEntity.this.inventory[this.index].func_77978_p());
            }
            BasicItemSplitterTileEntity.this.func_70296_d();
            return BasicItemSplitterTileEntity.this.inventory[this.index].func_77979_a(moved);
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return false;
        }
    }

    private class InHandler
    implements IItemHandler {
        private InHandler() {
        }

        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            int accepted;
            if (stack.func_190926_b() || slot != 0) {
                return stack;
            }
            if (!BasicItemSplitterTileEntity.this.inventory[0].func_190926_b() && !BlockUtil.sameItem(stack, BasicItemSplitterTileEntity.this.inventory[0]) || !BasicItemSplitterTileEntity.this.inventory[1].func_190926_b() && !BlockUtil.sameItem(stack, BasicItemSplitterTileEntity.this.inventory[1])) {
                return stack;
            }
            int numerator = BasicItemSplitterTileEntity.this.getActualMode();
            int denominator = BasicItemSplitterTileEntity.this.getBase();
            if (numerator == 0) {
                accepted = stack.func_77976_d() - BasicItemSplitterTileEntity.this.inventory[1].func_190916_E();
            } else if (numerator == denominator) {
                accepted = stack.func_77976_d() - BasicItemSplitterTileEntity.this.inventory[0].func_190916_E();
            } else {
                accepted = denominator * (stack.func_77976_d() - BasicItemSplitterTileEntity.this.inventory[0].func_190916_E()) / numerator;
                accepted = Math.min(accepted, denominator * (stack.func_77976_d() - BasicItemSplitterTileEntity.this.inventory[1].func_190916_E()) / (denominator - numerator));
            }
            accepted = Math.max(0, Math.min(stack.func_190916_E(), accepted));
            int goDown = numerator * (accepted / denominator);
            int remainder = accepted % denominator;
            if (BasicItemSplitterTileEntity.this.transfered < numerator) {
                goDown += Math.min(numerator - BasicItemSplitterTileEntity.this.transfered + Math.min((remainder + BasicItemSplitterTileEntity.this.transfered) % denominator, numerator), remainder);
            }
            int goUp = accepted - goDown;
            if (!simulate && accepted != 0) {
                if (BasicItemSplitterTileEntity.this.inventory[0].func_190926_b()) {
                    ((BasicItemSplitterTileEntity)BasicItemSplitterTileEntity.this).inventory[0] = stack.func_77946_l();
                    BasicItemSplitterTileEntity.this.inventory[0].func_190920_e(goDown);
                } else {
                    BasicItemSplitterTileEntity.this.inventory[0].func_190917_f(goDown);
                }
                if (BasicItemSplitterTileEntity.this.inventory[1].func_190926_b()) {
                    ((BasicItemSplitterTileEntity)BasicItemSplitterTileEntity.this).inventory[1] = stack.func_77946_l();
                    BasicItemSplitterTileEntity.this.inventory[1].func_190920_e(goUp);
                } else {
                    BasicItemSplitterTileEntity.this.inventory[1].func_190917_f(goUp);
                }
                BasicItemSplitterTileEntity.this.transfered += accepted;
                BasicItemSplitterTileEntity.this.transfered %= denominator;
            }
            if (accepted > 0) {
                ItemStack out = stack.func_77946_l();
                out.func_190918_g(accepted);
                return out;
            }
            return stack;
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot == 0;
        }
    }
}

