/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.packets;

import com.Da_Technomancer.essentials.Essentials;
import com.Da_Technomancer.essentials.packets.Packet;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketManager {
    private static final HashMap<Class<?>, BiConsumer<Object, PacketBuffer>> writeMap = new HashMap();
    private static final HashMap<Class<?>, Function<PacketBuffer, Object>> readMap = new HashMap();

    public static <T extends Packet> void encode(T packet, PacketBuffer buf) {
        Field[] toEncode;
        for (Field f : toEncode = packet.getFields()) {
            BiConsumer<Object, PacketBuffer> writer = writeMap.get(f.getType());
            if (writer == null) {
                Essentials.logger.error("Failed to get writer for packet class. Report to mod author: " + f.getType().toString());
                continue;
            }
            try {
                writer.accept(f.get(packet), buf);
            }
            catch (ClassCastException | IllegalAccessException e) {
                Essentials.logger.error("Failed to encode packet class. Report to mod author: " + f.getType().toString(), (Throwable)e);
            }
        }
    }

    public static <T extends Packet> T decode(PacketBuffer buf, Class<T> clazz) {
        Field[] toDecode;
        Packet packet;
        try {
            packet = (Packet)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Essentials.logger.error("Unable to instantiate packet. Report to mod author: " + clazz.toString(), (Throwable)e);
            return null;
        }
        for (Field f : toDecode = packet.getFields()) {
            Function<PacketBuffer, Object> reader = readMap.get(f.getType());
            if (reader == null) {
                Essentials.logger.error("Failed to get reader for packet class. Report to mod author: " + f.getType().toString());
                continue;
            }
            try {
                f.set(packet, reader.apply(buf));
            }
            catch (ClassCastException | IllegalAccessException e) {
                Essentials.logger.error("Failed to decode packet class. Report to mod author: " + f.getType().toString(), (Throwable)e);
            }
        }
        return (T)packet;
    }

    public static <T extends Packet> void activate(T packet, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context cont = context.get();
        packet.consume(cont);
        cont.setPacketHandled(true);
    }

    private static String readString(PacketBuffer buf) {
        return buf.func_150789_c(Short.MAX_VALUE);
    }

    static {
        writeMap.put(Boolean.TYPE, (val, buf) -> buf.writeBoolean(((Boolean)val).booleanValue()));
        writeMap.put(Boolean.class, (val, buf) -> buf.writeBoolean(((Boolean)val).booleanValue()));
        writeMap.put(Byte.TYPE, (val, buf) -> buf.writeByte((int)((Byte)val).byteValue()));
        writeMap.put(Byte.class, (val, buf) -> buf.writeByte((int)((Byte)val).byteValue()));
        writeMap.put(Integer.TYPE, (val, buf) -> buf.writeInt(((Integer)val).intValue()));
        writeMap.put(Integer.class, (val, buf) -> buf.writeInt(((Integer)val).intValue()));
        writeMap.put(Long.TYPE, (val, buf) -> buf.writeLong(((Long)val).longValue()));
        writeMap.put(Long.class, (val, buf) -> buf.writeLong(((Long)val).longValue()));
        writeMap.put(Float.TYPE, (val, buf) -> buf.writeFloat(((Float)val).floatValue()));
        writeMap.put(Float.class, (val, buf) -> buf.writeFloat(((Float)val).floatValue()));
        writeMap.put(Double.TYPE, (val, buf) -> buf.writeDouble(((Double)val).doubleValue()));
        writeMap.put(Double.class, (val, buf) -> buf.writeDouble(((Double)val).doubleValue()));
        writeMap.put(BlockPos.class, (val, buf) -> buf.func_179255_a((BlockPos)val));
        writeMap.put(CompoundNBT.class, (val, buf) -> buf.func_150786_a((CompoundNBT)val));
        writeMap.put(byte[].class, (val, buf) -> buf.func_179250_a((byte[])val));
        writeMap.put(String.class, (val, buf) -> buf.func_180714_a((String)val));
        readMap.put(Boolean.TYPE, PacketBuffer::readBoolean);
        readMap.put(Boolean.class, PacketBuffer::readBoolean);
        readMap.put(Byte.TYPE, PacketBuffer::readByte);
        readMap.put(Byte.class, PacketBuffer::readByte);
        readMap.put(Integer.TYPE, PacketBuffer::readInt);
        readMap.put(Integer.class, PacketBuffer::readInt);
        readMap.put(Long.TYPE, PacketBuffer::readLong);
        readMap.put(Long.class, PacketBuffer::readLong);
        readMap.put(Float.TYPE, PacketBuffer::readFloat);
        readMap.put(Float.class, PacketBuffer::readFloat);
        readMap.put(Double.TYPE, PacketBuffer::readDouble);
        readMap.put(Double.class, PacketBuffer::readDouble);
        readMap.put(BlockPos.class, PacketBuffer::func_179259_c);
        readMap.put(CompoundNBT.class, PacketBuffer::func_150793_b);
        readMap.put(byte[].class, PacketBuffer::func_179251_a);
        readMap.put(String.class, PacketManager::readString);
    }
}

