/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.gui;

import com.Da_Technomancer.essentials.blocks.redstone.AbstractTile;
import com.Da_Technomancer.essentials.gui.container.CircuitWrenchContainer;
import com.Da_Technomancer.essentials.items.CircuitWrench;
import com.Da_Technomancer.essentials.packets.ConfigureWrenchOnServer;
import com.Da_Technomancer.essentials.packets.EssentialsPackets;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class CircuitWrenchScreen
extends ContainerScreen<CircuitWrenchContainer> {
    private static final ResourceLocation SEARCH_BAR_TEXTURE = new ResourceLocation("essentials", "textures/gui/search_bar.png");
    private static final ResourceLocation ROW_TEXTURE = new ResourceLocation("essentials", "textures/gui/row.png");
    private static final ResourceLocation MISSING_TEXTURE = new ResourceLocation("essentials", "textures/gui/circuit/missing.png");
    private static final int ROWS = 8;
    private static final int COLUMNS = 8;
    private TextFieldWidget searchBar;
    private final ArrayList<Integer> options = new ArrayList();
    private static final Style style = new Style().func_150238_a(TextFormatting.DARK_RED);

    public CircuitWrenchScreen(CircuitWrenchContainer cont, PlayerInventory playerInventory, ITextComponent text) {
        super((Container)cont, playerInventory, text);
        this.field_147000_g = 162;
        this.field_146999_f = 144;
        for (int i = 0; i < CircuitWrench.MODES.size(); ++i) {
            this.options.add(i);
        }
    }

    protected void init() {
        super.init();
        this.searchBar = new TextFieldWidget(this.font, (this.width - this.field_146999_f) / 2 + 4, (this.height - this.field_147000_g) / 2 + 8, 140, 18, I18n.func_135052_a((String)"container.search_bar", (Object[])new Object[0]));
        this.searchBar.func_146205_d(false);
        this.searchBar.changeFocus(true);
        this.searchBar.func_146193_g(-1);
        this.searchBar.func_146204_h(-1);
        this.searchBar.func_146185_a(false);
        this.searchBar.func_146203_f(20);
        this.searchBar.func_212954_a(this::filterChanged);
        this.children.add(this.searchBar);
        this.func_212928_a((IGuiEventListener)this.searchBar);
    }

    public void resize(Minecraft p_resize_1_, int p_resize_2_, int p_resize_3_) {
        String s = this.searchBar.func_146179_b();
        this.init(p_resize_1_, p_resize_2_, p_resize_3_);
        this.searchBar.func_146180_a(s);
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            this.minecraft.field_71439_g.func_71053_j();
        }
        return this.searchBar.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) || this.searchBar.func_212955_f() || super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    private int getSelectedMode(float xPos, float yPos) {
        int xInd = (int)((xPos -= (float)((this.width - this.field_146999_f) / 2)) / 18.0f);
        int yInd = (int)((yPos -= (float)((this.height - this.field_147000_g) / 2 + 18)) / 18.0f);
        int index = xInd + yInd * 8;
        if (xInd < 0 || yInd < 0 || xInd >= 8 || yInd >= 8 || index >= this.options.size() || index < 0) {
            return -1;
        }
        return this.options.get(index);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        int index = this.getSelectedMode(mouseX, mouseY);
        if (index >= 0) {
            ArrayList<TranslationTextComponent> tt = new ArrayList<TranslationTextComponent>();
            tt.add(new TranslationTextComponent(CircuitWrench.MODES.get(index).func_149739_a(), new Object[0]));
            AbstractTile block = CircuitWrench.MODES.get(index);
            block.func_190948_a(ItemStack.field_190927_a, null, tt, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
            this.renderTooltip(tt.stream().map(ITextComponent::func_150254_d).collect(Collectors.toList()), mouseX, mouseY);
        }
        RenderSystem.disableLighting();
        RenderSystem.disableBlend();
        this.searchBar.render(mouseX, mouseY, partialTicks);
    }

    private void filterChanged(String newFilter) {
        this.options.clear();
        for (int i = 0; i < CircuitWrench.MODES.size(); ++i) {
            AbstractTile tile = CircuitWrench.MODES.get(i);
            String name = I18n.func_135052_a((String)tile.func_149739_a(), (Object[])new Object[0]).toLowerCase();
            if (!name.contains(newFilter.toLowerCase().trim())) continue;
            this.options.add(i);
        }
    }

    public boolean mouseClicked(double xPos, double yPos, int button) {
        if (button != 0) {
            return super.mouseClicked(xPos, yPos, button);
        }
        int index = this.getSelectedMode((int)xPos, (int)yPos);
        if (index < 0) {
            return super.mouseClicked(xPos, yPos, button);
        }
        EssentialsPackets.channel.sendToServer((Object)new ConfigureWrenchOnServer(index));
        this.minecraft.field_71439_g.func_71053_j();
        this.field_213127_e.field_70458_d.func_145747_a(new TranslationTextComponent("tt.essentials.circuit_wrench_setting", new Object[0]).func_150255_a(style).func_150257_a((ITextComponent)new TranslationTextComponent(CircuitWrench.MODES.get(index).func_149739_a(), new Object[0])));
        return true;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.minecraft.func_110434_K().func_110577_a(SEARCH_BAR_TEXTURE);
        CircuitWrenchScreen.blit((int)((this.width - this.field_146999_f) / 2), (int)((this.height - this.field_147000_g) / 2), (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)18, (int)this.field_146999_f, (int)18);
        this.minecraft.func_110434_K().func_110577_a(ROW_TEXTURE);
        for (int i = 1; i <= 8; ++i) {
            CircuitWrenchScreen.blit((int)((this.width - this.field_146999_f) / 2), (int)((this.height - this.field_147000_g) / 2 + i * 18), (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)18, (int)this.field_146999_f, (int)18);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        for (int i = 0; i < this.options.size(); ++i) {
            Integer ind = this.options.get(i);
            ResourceLocation sprite = CircuitWrench.ICONS.get(ind);
            if (sprite == null) {
                sprite = MISSING_TEXTURE;
            }
            this.minecraft.func_110434_K().func_110577_a(sprite);
            CircuitWrenchScreen.blit((int)(i % 8 * 18 + 1), (int)(i / 8 * 18 + 19), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
    }
}

