/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks;

import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.redstone.IReadable;
import com.Da_Technomancer.essentials.tileentities.SlottedChestTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class SlottedChest
extends ContainerBlock
implements IReadable {
    protected SlottedChest() {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a));
        String name = "slotted_chest";
        this.setRegistryName(name);
        ESBlocks.toRegister.add((Block)this);
        ESBlocks.blockAddQue(this);
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new SlottedChestTileEntity();
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof SlottedChestTileEntity) {
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((SlottedChestTileEntity)te).iInv);
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        TileEntity te;
        if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) instanceof SlottedChestTileEntity) {
            ItemStack[] filter = ((SlottedChestTileEntity)te).lockedInv;
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)((SlottedChestTileEntity)te), buf -> {
                for (ItemStack lock : filter) {
                    buf.func_150788_a(lock);
                }
            });
        }
        return ActionResultType.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.essentials.slotted_chest.desc", new Object[0]));
        tooltip.add(new TranslationTextComponent("tt.essentials.slotted_chest.quip", new Object[0]).func_150255_a(ESConfig.TT_QUIP));
    }

    public boolean func_149740_M(BlockState p_149740_1_) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof SlottedChestTileEntity) {
            float val = ((SlottedChestTileEntity)te).calcComparator() * 15.0f;
            val = MathHelper.func_76141_d((float)(val * 14.0f)) + (val > 0.0f ? 1 : 0);
            return (int)val;
        }
        return 0;
    }

    @Override
    public float read(World world, BlockPos pos, BlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof SlottedChestTileEntity) {
            return ((SlottedChestTileEntity)te).calcComparator() * 15.0f;
        }
        return 0.0f;
    }
}

