/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class ESConfig {
    public static final Style TT_QUIP = new Style().func_150238_a(TextFormatting.AQUA).func_150217_b(Boolean.valueOf(true));
    public static ForgeConfigSpec.BooleanValue addWrench;
    public static ForgeConfigSpec.IntValue brazierRange;
    public static ForgeConfigSpec.IntValue itemChuteRange;
    public static ForgeConfigSpec.DoubleValue fertileSoilRate;
    public static ForgeConfigSpec.IntValue maxRedstoneRange;
    public static ForgeConfigSpec.EnumValue<NumberTypes> numberDisplay;
    public static ForgeConfigSpec.IntValue wirelessRange;
    private static ForgeConfigSpec clientSpec;
    private static ForgeConfigSpec serverSpec;
    private static final Tag<Item> WRENCH;
    private static final NumberFormat scientific;
    private static final NumberFormat engineering;

    protected static void init() {
        ForgeConfigSpec.Builder clientBuilder = new ForgeConfigSpec.Builder();
        addWrench = clientBuilder.worldRestart().comment("Should the Wrench show up in the creative menu?").define("creative_wrench", true);
        numberDisplay = clientBuilder.comment(new String[]{"How should very large and small numbers be displayed?", "Options are: NORMAL, SCIENTIFIC, ENGINEERING, and HEX"}).defineEnum("num_display", (Enum)NumberTypes.SCIENTIFIC);
        clientSpec = clientBuilder.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, clientSpec);
        ForgeConfigSpec.Builder serverBuilder = new ForgeConfigSpec.Builder();
        brazierRange = serverBuilder.comment(new String[]{"Range of the Brazier anti-witch effect", "Set to 0 to disable"}).defineInRange("brazier_range", 64, 0, 512);
        itemChuteRange = serverBuilder.comment("Maximum Transport Chutes in a line").defineInRange("chute_limit", 16, 0, 128);
        fertileSoilRate = serverBuilder.comment(new String[]{"Percent of normal speed Fertile Soil should work at", "Set to 0 to disable"}).defineInRange("fertile_rate", 100.0, 0.0, 100.0);
        maxRedstoneRange = serverBuilder.comment("Range of signals through Circuit Wire").defineInRange("redstone_range", 16, 1, 128);
        wirelessRange = serverBuilder.comment("Range of signals through Redstone Receivers/Transmitters").defineInRange("wireless_range", 32, 0, 128);
        serverSpec = serverBuilder.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, serverSpec);
    }

    protected static void load() {
        CommentedFileConfig clientConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)FMLPaths.CONFIGDIR.get().resolve("essentials-client.toml")).sync().autosave().writingMode(WritingMode.REPLACE).build();
        clientConfig.load();
        clientSpec.setConfig((CommentedConfig)clientConfig);
        CommentedFileConfig serverConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)FMLPaths.CONFIGDIR.get().resolve("essentials-server.toml")).sync().autosave().writingMode(WritingMode.REPLACE).build();
        serverConfig.load();
        serverSpec.setConfig((CommentedConfig)serverConfig);
    }

    public static boolean isWrench(ItemStack stack) {
        return WRENCH.func_199685_a_((Object)stack.func_77973_b()) || stack.getToolTypes().contains(ToolType.get((String)"wrench"));
    }

    public static String formatFloat(float value, @Nullable NumberTypes format) {
        if (format == null) {
            format = (NumberTypes)((Object)numberDisplay.get());
        }
        switch (format) {
            case SCIENTIFIC: {
                float absValue = Math.abs(value);
                if (absValue == 0.0f) {
                    return "0";
                }
                if (absValue < 1000.0f && absValue >= 5.0E-4f) {
                    return ESConfig.trimTrail((float)Math.round(value * 1000.0f) / 1000.0f);
                }
                return scientific.format(value);
            }
            case ENGINEERING: {
                float absoValue = Math.abs(value);
                if (absoValue == 0.0f) {
                    return "0";
                }
                if (absoValue < 1000.0f && absoValue >= 5.0E-4f) {
                    return ESConfig.trimTrail((float)Math.round(value * 1000.0f) / 1000.0f);
                }
                return engineering.format(value);
            }
            case HEX: {
                return Float.toHexString(value);
            }
        }
        return Float.toString(value);
    }

    private static String trimTrail(float valFloat) {
        String val = Float.toString(valFloat);
        while (val.contains(".") && (val.endsWith("0") || val.endsWith("."))) {
            val = val.substring(0, val.length() - 2);
        }
        return val;
    }

    static {
        WRENCH = new ItemTags.Wrapper(new ResourceLocation("forge", "wrench"));
        scientific = new DecimalFormat("0.###E0");
        engineering = new DecimalFormat("##0.###E0");
    }

    public static enum NumberTypes {
        NORMAL,
        SCIENTIFIC,
        ENGINEERING,
        HEX;

    }
}

