/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.soundfilters.handlers;

import com.tmtravlr.soundfilters.SoundFiltersConfig;
import com.tmtravlr.soundfilters.handlers.FilterHandler;
import com.tmtravlr.soundfilters.utils.ComparablePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.TreeSet;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ReverbHandler {
    private static final List<Material> HIGH_REVERB_MATERIALS = Arrays.asList(Material.field_151576_e, Material.field_151592_s, Material.field_151588_w, Material.field_151598_x, Material.field_151573_f);
    private static final List<Material> LOW_REVERB_MATERIALS = Arrays.asList(Material.field_151593_r, Material.field_151580_n, Material.field_151569_G, Material.field_151568_F, Material.field_151577_b, Material.field_151585_k, Material.field_151582_l, Material.field_151572_C, Material.field_215713_z, Material.field_215712_y, Material.field_151584_j, Material.field_151570_A, Material.field_203243_f, Material.field_204868_h, Material.field_151589_v, Material.field_151583_m, Material.field_151597_y, Material.field_151596_z);
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static int profileTickCount = 0;
    private static float prevDecayFactor = 0.0f;
    private static float prevRoomFactor = 0.0f;
    private static float prevSkyFactor = 0.0f;

    public static void initializeReverb() {
        FilterHandler.initializeReverbFilter();
    }

    public static void stopReverb() {
        ReverbHandler.initializeReverb();
    }

    public static void updateReverb() {
        if (ReverbHandler.MC.field_71441_e != null && ReverbHandler.MC.field_71439_g != null && ((Boolean)Optional.ofNullable(SoundFiltersConfig.REVERB_ENABLED.get()).orElse(true)).booleanValue() && ++profileTickCount >= 13) {
            profileTickCount = 0;
            Random rand = new Random();
            int maxBlocks = (Integer)Optional.ofNullable(SoundFiltersConfig.REVERB_MAX_BLOCKS.get()).orElse(1024);
            float baseReverb = 0.0f;
            Double customDimensionReverb = SoundFiltersConfig.getCustomDimensionReverb(ReverbHandler.MC.field_71441_e.field_73011_w.func_186058_p().getRegistryName());
            if (customDimensionReverb != null) {
                baseReverb = customDimensionReverb.floatValue();
            }
            TreeSet<ComparablePosition> visited = new TreeSet<ComparablePosition>();
            ArrayList<CachedBlockInfo> blocksFound = new ArrayList<CachedBlockInfo>();
            LinkedList<ComparablePosition> toVisit = new LinkedList<ComparablePosition>();
            toVisit.add(new ComparablePosition(MathHelper.func_76128_c((double)ReverbHandler.MC.field_71439_g.func_213303_ch().func_82615_a()), MathHelper.func_76128_c((double)(ReverbHandler.MC.field_71439_g.func_213303_ch().func_82617_b() + (double)ReverbHandler.MC.field_71439_g.func_70047_e())), MathHelper.func_76128_c((double)ReverbHandler.MC.field_71439_g.func_213303_ch().func_82616_c())));
            for (int i = 0; i < maxBlocks && !toVisit.isEmpty(); ++i) {
                ComparablePosition current = (ComparablePosition)toVisit.remove(rand.nextInt(toVisit.size()));
                visited.add(current);
                ReverbHandler.findBlock(visited, toVisit, blocksFound, new ComparablePosition(current.x(), current.y(), current.z() + 1));
                ReverbHandler.findBlock(visited, toVisit, blocksFound, new ComparablePosition(current.x(), current.y(), current.z() - 1));
                ReverbHandler.findBlock(visited, toVisit, blocksFound, new ComparablePosition(current.x(), current.y() + 1, current.z()));
                ReverbHandler.findBlock(visited, toVisit, blocksFound, new ComparablePosition(current.x(), current.y() - 1, current.z()));
                ReverbHandler.findBlock(visited, toVisit, blocksFound, new ComparablePosition(current.x() + 1, current.y(), current.z()));
                ReverbHandler.findBlock(visited, toVisit, blocksFound, new ComparablePosition(current.x() - 1, current.y(), current.z()));
            }
            int roomSize = visited.size();
            double highReverb = 0.0;
            double midReverb = 0.0;
            double lowReverb = 0.0;
            for (CachedBlockInfo worldState : blocksFound) {
                Double customReverb = SoundFiltersConfig.getCustomBlockReverb((World)ReverbHandler.MC.field_71441_e, worldState);
                if (customReverb != null) {
                    lowReverb += customReverb >= 1.0 || customReverb < 0.0 ? 0.0 : 1.0 - customReverb;
                    midReverb += customReverb >= 2.0 || customReverb <= 0.0 ? 0.0 : 1.0 - Math.abs(customReverb - 1.0);
                    highReverb += customReverb <= 1.0 ? 0.0 : (customReverb > 2.0 ? 1.0 : customReverb - 1.0);
                    continue;
                }
                BlockState state = worldState.func_177509_a();
                if (!HIGH_REVERB_MATERIALS.contains(state.func_185904_a())) {
                    if (!LOW_REVERB_MATERIALS.contains(state.func_185904_a())) {
                        midReverb += 1.0;
                        continue;
                    }
                    lowReverb += 1.0;
                    continue;
                }
                highReverb += 1.0;
            }
            float skyFactor = 0.0f;
            if (((Boolean)Optional.ofNullable(SoundFiltersConfig.REVERB_SKY_CHECKS.get()).orElse(true)).booleanValue() && roomSize == maxBlocks) {
                int z;
                int y;
                int x = MathHelper.func_76128_c((double)ReverbHandler.MC.field_71439_g.func_213303_ch().func_82615_a());
                if (ReverbHandler.onlySkyAboveBlock((World)ReverbHandler.MC.field_71441_e, x, y = MathHelper.func_76128_c((double)(ReverbHandler.MC.field_71439_g.func_213303_ch().func_82617_b() + (double)ReverbHandler.MC.field_71439_g.func_70047_e())), z = MathHelper.func_76128_c((double)ReverbHandler.MC.field_71439_g.func_213303_ch().func_82616_c()))) {
                    skyFactor += 1.0f;
                }
                if (ReverbHandler.onlySkyAboveBlock((World)ReverbHandler.MC.field_71441_e, x + rand.nextInt(5) + 5, y, z)) {
                    skyFactor += 1.0f;
                }
                if (ReverbHandler.onlySkyAboveBlock((World)ReverbHandler.MC.field_71441_e, x - rand.nextInt(5) - 5, y, z)) {
                    skyFactor += 1.0f;
                }
                if (ReverbHandler.onlySkyAboveBlock((World)ReverbHandler.MC.field_71441_e, x, y, z + rand.nextInt(5) + 5)) {
                    skyFactor += 1.0f;
                }
                if (ReverbHandler.onlySkyAboveBlock((World)ReverbHandler.MC.field_71441_e, x, y, z - rand.nextInt(5) - 5)) {
                    skyFactor += 1.0f;
                }
                if (ReverbHandler.onlySkyAboveBlock((World)ReverbHandler.MC.field_71441_e, x + rand.nextInt(5) + 5, y, z + rand.nextInt(5) + 5)) {
                    skyFactor += 1.0f;
                }
                if (ReverbHandler.onlySkyAboveBlock((World)ReverbHandler.MC.field_71441_e, x - rand.nextInt(5) - 5, y, z + rand.nextInt(5) + 5)) {
                    skyFactor += 1.0f;
                }
                if (ReverbHandler.onlySkyAboveBlock((World)ReverbHandler.MC.field_71441_e, x + rand.nextInt(5) + 5, y, z - rand.nextInt(5) - 5)) {
                    skyFactor += 1.0f;
                }
                if (ReverbHandler.onlySkyAboveBlock((World)ReverbHandler.MC.field_71441_e, x - rand.nextInt(5) - 5, y, z - rand.nextInt(5) - 5)) {
                    skyFactor += 1.0f;
                }
                if (ReverbHandler.onlySkyAboveBlock((World)ReverbHandler.MC.field_71441_e, x + rand.nextInt(5) + 5, y + 5, z)) {
                    skyFactor += 1.0f;
                }
                if (ReverbHandler.onlySkyAboveBlock((World)ReverbHandler.MC.field_71441_e, x - rand.nextInt(5) - 5, y + 5, z)) {
                    skyFactor += 1.0f;
                }
                if (ReverbHandler.onlySkyAboveBlock((World)ReverbHandler.MC.field_71441_e, x, y + 5, z + rand.nextInt(5) + 5)) {
                    skyFactor += 1.0f;
                }
                if (ReverbHandler.onlySkyAboveBlock((World)ReverbHandler.MC.field_71441_e, x, y + 5, z - rand.nextInt(5) - 5)) {
                    skyFactor += 1.0f;
                }
                if (ReverbHandler.onlySkyAboveBlock((World)ReverbHandler.MC.field_71441_e, x + rand.nextInt(5) + 5, y + 5, z + rand.nextInt(5) + 5)) {
                    skyFactor += 1.0f;
                }
                if (ReverbHandler.onlySkyAboveBlock((World)ReverbHandler.MC.field_71441_e, x - rand.nextInt(5) - 5, y + 5, z + rand.nextInt(5) + 5)) {
                    skyFactor += 1.0f;
                }
                if (ReverbHandler.onlySkyAboveBlock((World)ReverbHandler.MC.field_71441_e, x + rand.nextInt(5) + 5, y + 5, z - rand.nextInt(5) - 5)) {
                    skyFactor += 1.0f;
                }
                if (ReverbHandler.onlySkyAboveBlock((World)ReverbHandler.MC.field_71441_e, x - rand.nextInt(5) - 5, y + 5, z - rand.nextInt(5) - 5)) {
                    skyFactor += 1.0f;
                }
            }
            skyFactor = 1.0f - Math.min(skyFactor, 12.0f) / 12.0f;
            skyFactor *= skyFactor;
            float decayFactor = baseReverb;
            float roomFactor = (float)roomSize / (float)maxBlocks;
            if (highReverb + midReverb + lowReverb > 0.0) {
                decayFactor += (float)(highReverb - lowReverb) / (float)(highReverb + midReverb + lowReverb);
            }
            if (decayFactor < 0.0f) {
                decayFactor = 0.0f;
            }
            if (decayFactor > 1.0f) {
                decayFactor = 1.0f;
            }
            decayFactor = (decayFactor + prevDecayFactor) / 2.0f;
            roomFactor = (roomFactor + prevRoomFactor) / 2.0f;
            skyFactor = (skyFactor + prevSkyFactor) / 2.0f;
            prevDecayFactor = decayFactor;
            prevRoomFactor = roomFactor;
            prevSkyFactor = skyFactor;
            FilterHandler.updateReverbFilter(decayFactor, roomFactor, skyFactor);
        }
    }

    private static boolean onlySkyAboveBlock(World world, int x, int y, int z) {
        for (int i = y; i < 256; ++i) {
            BlockState state = world.func_180495_p(new BlockPos(x, i, z));
            if (!state.func_185904_a().func_76230_c()) continue;
            return false;
        }
        return true;
    }

    private static void findBlock(TreeSet<ComparablePosition> visited, LinkedList<ComparablePosition> toVisit, ArrayList<CachedBlockInfo> blocksFound, ComparablePosition pos) {
        CachedBlockInfo worldState = new CachedBlockInfo((IWorldReader)ReverbHandler.MC.field_71441_e, new BlockPos(pos.x(), pos.y(), pos.z()), true);
        Material material = worldState.func_177509_a().func_185904_a();
        if (!material.func_76230_c()) {
            if (!visited.contains(pos) && !toVisit.contains(pos)) {
                toVisit.add(pos);
            }
            if (material != Material.field_151579_a && material != Material.field_151586_h) {
                blocksFound.add(worldState);
            }
        } else {
            blocksFound.add(worldState);
        }
    }
}

