/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.soundfilters.handlers;

import com.tmtravlr.soundfilters.SoundEventHandler;
import com.tmtravlr.soundfilters.SoundFiltersConfig;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListMap;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class OcclusionHandler {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static final ConcurrentSkipListMap<ISound, Double> SOURCE_OCCLUSION_MAP = new ConcurrentSkipListMap((first, second) -> {
        if (first == second) {
            return 0;
        }
        if (second == null) {
            return 1;
        }
        if (first == null) {
            return -1;
        }
        return first.hashCode() - second.hashCode();
    });

    public static void addOcclusionToMap(ISound sound) {
        if (((Boolean)SoundFiltersConfig.OCCLUSION_ENABLED.get()).booleanValue()) {
            double amount = 0.0;
            if (OcclusionHandler.MC.field_71441_e != null && OcclusionHandler.MC.field_71439_g != null) {
                amount = OcclusionHandler.getOccludedPercent((World)OcclusionHandler.MC.field_71441_e, sound, (Entity)OcclusionHandler.MC.field_71439_g);
            }
            SOURCE_OCCLUSION_MAP.put(sound, amount);
        }
    }

    public static double getOcclusion(ISound sound) {
        return Optional.ofNullable(SOURCE_OCCLUSION_MAP.get(sound)).orElse(0.0);
    }

    public static void updateOcclusion() {
        if (((Boolean)SoundFiltersConfig.OCCLUSION_ENABLED.get()).booleanValue()) {
            SOURCE_OCCLUSION_MAP.entrySet().removeIf(entry -> !SoundEventHandler.playingSoundsChannel.containsKey(entry.getKey()));
            for (Map.Entry<ISound, Double> sourceEntry : SOURCE_OCCLUSION_MAP.entrySet()) {
                ISound sound = sourceEntry.getKey();
                Double amount = sourceEntry.getValue();
                if (sound == null || amount == null) continue;
                if (OcclusionHandler.MC.field_71441_e != null && OcclusionHandler.MC.field_71439_g != null) {
                    SOURCE_OCCLUSION_MAP.put(sound, (amount * 3.0 + OcclusionHandler.getOccludedPercent((World)OcclusionHandler.MC.field_71441_e, sound, (Entity)OcclusionHandler.MC.field_71439_g)) / 4.0);
                    continue;
                }
                SOURCE_OCCLUSION_MAP.put(sound, 0.0);
            }
        }
    }

    private static double getOccludedPercent(World world, ISound sound, Entity player) {
        return OcclusionHandler.getBaseOccludedPercent(world, new Vec3d((double)sound.func_147649_g(), (double)sound.func_147654_h(), (double)sound.func_147651_i()), OcclusionHandler.MC.field_71439_g.func_213303_ch().func_72441_c(0.0, (double)player.func_70047_e(), 0.0));
    }

    private static double getBaseOccludedPercent(World world, Vec3d sound, Vec3d listener) {
        double occludedPercent = 0.0;
        sound = sound.func_72441_c(0.01, 0.01, 0.01);
        if (!(Double.isNaN(sound.field_72450_a) || Double.isNaN(sound.field_72448_b) || Double.isNaN(sound.field_72449_c))) {
            if (!(Double.isNaN(listener.field_72450_a) || Double.isNaN(listener.field_72448_b) || Double.isNaN(listener.field_72449_c))) {
                BlockPos listenerPos = new BlockPos(listener);
                BlockPos soundPos = new BlockPos(sound);
                int i = 0;
                while (i++ < 200) {
                    double newOcclusion;
                    BlockRayTraceResult rayTrace;
                    Vec3d prevSound = sound;
                    BlockPos prevSoundPos = soundPos;
                    if (Double.isNaN(sound.field_72450_a) || Double.isNaN(sound.field_72448_b) || Double.isNaN(sound.field_72449_c)) {
                        return occludedPercent;
                    }
                    if (soundPos.equals((Object)listenerPos)) {
                        return occludedPercent;
                    }
                    boolean shouldChangeX = listenerPos.func_177958_n() != soundPos.func_177958_n();
                    boolean shouldChangeY = listenerPos.func_177956_o() != soundPos.func_177956_o();
                    boolean shouldChangeZ = listenerPos.func_177952_p() != soundPos.func_177952_p();
                    int nextX = soundPos.func_177958_n() + (listenerPos.func_177958_n() > soundPos.func_177958_n() ? 1 : 0);
                    int nextY = soundPos.func_177956_o() + (listenerPos.func_177956_o() > soundPos.func_177956_o() ? 1 : 0);
                    int nextZ = soundPos.func_177952_p() + (listenerPos.func_177952_p() > soundPos.func_177952_p() ? 1 : 0);
                    double xDifference = listener.field_72450_a - sound.field_72450_a;
                    double yDifference = listener.field_72448_b - sound.field_72448_b;
                    double zDifference = listener.field_72449_c - sound.field_72449_c;
                    double xPercentChange = shouldChangeX ? ((double)nextX - sound.field_72450_a) / xDifference : Double.POSITIVE_INFINITY;
                    double yPercentChange = shouldChangeY ? ((double)nextY - sound.field_72448_b) / yDifference : Double.POSITIVE_INFINITY;
                    double zPercentChange = shouldChangeZ ? ((double)nextZ - sound.field_72449_c) / zDifference : Double.POSITIVE_INFINITY;
                    BlockPos soundPosOffset = null;
                    if (xPercentChange < yPercentChange && xPercentChange < zPercentChange) {
                        sound = new Vec3d((double)nextX, sound.field_72448_b + yDifference * xPercentChange, sound.field_72449_c + zDifference * xPercentChange);
                        if (listenerPos.func_177958_n() < soundPos.func_177958_n()) {
                            soundPosOffset = new BlockPos(-1, 0, 0);
                        }
                    } else if (yPercentChange < zPercentChange) {
                        sound = new Vec3d(sound.field_72450_a + xDifference * yPercentChange, (double)nextY, sound.field_72449_c + zDifference * yPercentChange);
                        if (listenerPos.func_177956_o() < soundPos.func_177956_o()) {
                            soundPosOffset = new BlockPos(0, -1, 0);
                        }
                    } else {
                        sound = new Vec3d(sound.field_72450_a + xDifference * zPercentChange, sound.field_72448_b + yDifference * zPercentChange, (double)nextZ);
                        if (listenerPos.func_177952_p() < soundPos.func_177952_p()) {
                            soundPosOffset = new BlockPos(0, 0, -1);
                        }
                    }
                    soundPos = new BlockPos(sound);
                    if (soundPosOffset != null) {
                        soundPos = soundPos.func_177971_a((Vec3i)soundPosOffset);
                    }
                    if (i <= 1) continue;
                    CachedBlockInfo worldState = new CachedBlockInfo((IWorldReader)world, prevSoundPos, true);
                    BlockState state = worldState.func_177509_a();
                    Material material = state.func_185904_a();
                    VoxelShape collisionShape = state.func_196952_d((IBlockReader)world, prevSoundPos);
                    if (state.isAir((IBlockReader)world, prevSoundPos) || state.func_196954_c((IBlockReader)world, prevSoundPos).func_197766_b() || collisionShape == VoxelShapes.func_197880_a() || (rayTrace = collisionShape.func_212433_a(prevSound, listener, prevSoundPos)) == null) continue;
                    double occlusionMultiplier = (Double)SoundFiltersConfig.OCCLUSION_MULTIPLIER.get();
                    double occlusionMax = (Double)SoundFiltersConfig.OCCLUSION_MAX.get();
                    Double customOcclusion = null;
                    if (rayTrace.func_216346_c() == RayTraceResult.Type.BLOCK) {
                        customOcclusion = SoundFiltersConfig.getCustomBlockOcclusion((World)OcclusionHandler.MC.field_71441_e, new CachedBlockInfo((IWorldReader)world, rayTrace.func_216350_a(), false));
                    }
                    if (customOcclusion != null) {
                        newOcclusion = customOcclusion * occlusionMultiplier;
                    } else {
                        double d = newOcclusion = material.func_76218_k() ? occlusionMultiplier : occlusionMultiplier / 2.0;
                    }
                    if (!((occludedPercent += (newOcclusion *= sound.func_72438_d(prevSound))) > occlusionMax)) continue;
                    return occlusionMax;
                }
                return occludedPercent;
            }
            return occludedPercent;
        }
        return occludedPercent;
    }
}

