/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.swampexpansion.core.other;

import com.farcr.swampexpansion.common.entity.SlabfishEntity;
import com.farcr.swampexpansion.common.entity.SlabfishOverlay;
import com.farcr.swampexpansion.common.entity.SlabfishType;
import com.farcr.swampexpansion.core.registry.SwampExEntities;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraft.world.storage.loot.TableLootEntry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="swampexpansion")
public class SwampExEvents {
    private static final Set<ResourceLocation> RICE_SHIPWRECK_LOOT_INJECTIONS = Sets.newHashSet((Object[])new ResourceLocation[]{LootTables.field_204772_t});
    protected static final Map<Block, BlockState> HOE_LOOKUP = Maps.newHashMap((Map)ImmutableMap.of((Object)Blocks.field_196658_i, (Object)Blocks.field_150458_ak.func_176223_P(), (Object)Blocks.field_185774_da, (Object)Blocks.field_150458_ak.func_176223_P(), (Object)Blocks.field_150346_d, (Object)Blocks.field_150458_ak.func_176223_P(), (Object)Blocks.field_196660_k, (Object)Blocks.field_150346_d.func_176223_P()));

    @SubscribeEvent
    public static void onInjectLoot(LootTableLoadEvent event) {
        if (RICE_SHIPWRECK_LOOT_INJECTIONS.contains(event.getName())) {
            LootPool pool = LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("swampexpansion", "injections/rice_shipwreck")).func_216086_a(1).func_216085_b(0)).name("rice_shipwreck").func_216044_b();
            event.getTable().addPool(pool);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onThrowableImpact(ProjectileImpactEvent.Throwable event) {
        ThrowableEntity projectileEntity = event.getThrowable();
        if (projectileEntity instanceof PotionEntity) {
            AxisAlignedBB axisalignedbb;
            List slabs;
            PotionEntity potionEntity = (PotionEntity)projectileEntity;
            ItemStack itemstack = potionEntity.func_184543_l();
            Potion potion = PotionUtils.func_185191_c((ItemStack)itemstack);
            List list = PotionUtils.func_185189_a((ItemStack)itemstack);
            if (potion == Potions.field_185230_b && list.isEmpty() && (slabs = potionEntity.field_70170_p.func_217357_a(SlabfishEntity.class, axisalignedbb = potionEntity.func_174813_aQ().func_72314_b(2.0, 1.0, 2.0))) != null && slabs.size() > 0) {
                for (SlabfishEntity slabfish : slabs) {
                    slabfish.setSlabfishOverlay(SlabfishOverlay.NONE);
                }
            }
        }
        if (projectileEntity instanceof ProjectileItemEntity) {
            EntityRayTraceResult entity;
            ProjectileItemEntity snowball = (ProjectileItemEntity)projectileEntity;
            if (event.getRayTraceResult().func_216346_c() == RayTraceResult.Type.ENTITY && (entity = (EntityRayTraceResult)event.getRayTraceResult()).func_216348_a() instanceof SlabfishEntity) {
                SlabfishEntity slabfish = (SlabfishEntity)entity.func_216348_a();
                if (snowball.func_184543_l().func_77973_b() == Items.field_151126_ay) {
                    slabfish.setSlabfishOverlay(SlabfishOverlay.SNOWY);
                }
                if (snowball.func_184543_l().func_77973_b() == Items.field_151110_aK) {
                    slabfish.setSlabfishOverlay(SlabfishOverlay.EGG);
                }
            }
        }
    }

    @SubscribeEvent
    public static void underwaterHoe(UseHoeEvent event) {
        BlockState blockstate;
        ItemStack hoe = event.getContext().func_195996_i();
        World world = event.getContext().func_195991_k();
        BlockPos blockpos = event.getContext().func_195995_a();
        if (event.getContext().func_196000_l() != Direction.DOWN && (blockstate = HOE_LOOKUP.get(world.func_180495_p(blockpos).func_177230_c())) != null) {
            PlayerEntity playerentity = event.getPlayer();
            world.func_184133_a(playerentity, blockpos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            playerentity.func_184609_a(event.getContext().func_221531_n());
            if (!world.field_72995_K) {
                world.func_180501_a(blockpos, blockstate, 11);
                if (playerentity != null) {
                    hoe.func_222118_a(1, (LivingEntity)playerentity, anim -> anim.func_213334_d(event.getContext().func_221531_n()));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onInteractWithEntity(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getItemStack();
        Entity target = event.getTarget();
        if (target instanceof SlabfishEntity && stack.func_77973_b() == Items.field_151057_cb) {
            SlabfishEntity slabby = (SlabfishEntity)event.getTarget();
            if (stack.func_82837_s()) {
                if (slabby.func_145818_k_() && slabby.func_200201_e() != stack.func_200301_q()) {
                    slabby.playTransformSound();
                } else if (!slabby.func_145818_k_()) {
                    slabby.playTransformSound();
                }
            }
        }
    }

    @SubscribeEvent
    public static void SlabfishDeath(LivingDeathEvent event) {
        SlabfishEntity entity;
        if (event.getEntity() instanceof SlabfishEntity && (entity = (SlabfishEntity)event.getEntity()).func_130014_f_().func_201675_m().func_186058_p() == DimensionType.field_223228_b_ && !entity.func_130014_f_().field_72995_K && entity.getSlabfishType() != SlabfishType.GHOST) {
            SlabfishEntity ghost = (SlabfishEntity)((EntityType)SwampExEntities.SLABFISH.get()).func_200721_a(entity.field_70170_p);
            ghost.func_195064_c(new EffectInstance(Effects.field_188424_y, 140, 0, false, false));
            ghost.func_195064_c(new EffectInstance(Effects.field_76426_n, 140, 0, false, false));
            entity.func_130014_f_().func_184133_a(null, entity.func_180425_c(), SoundEvents.field_190021_aL, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            ghost.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
            ghost.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
            ghost.func_94061_f(entity.func_175446_cd());
            ghost.func_70873_a(entity.func_70874_b());
            if (entity.func_145818_k_()) {
                ghost.func_200203_b(entity.func_200201_e());
                ghost.func_174805_g(entity.func_174833_aM());
            }
            ghost.setSlabfishType(SlabfishType.GHOST);
            ghost.func_223308_g(0);
            entity.func_130014_f_().func_217376_c((Entity)ghost);
        }
    }
}

