/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.swampexpansion.common.world.biome;

import com.farcr.swampexpansion.common.world.gen.treedecorator.HangingWillowLeavesTreeDecorator;
import com.farcr.swampexpansion.core.registry.SwampExBlocks;
import com.farcr.swampexpansion.core.registry.SwampExFeatures;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.DoublePlantBlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.SeaGrassConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraft.world.gen.feature.TwoFeatureChoiceConfig;
import net.minecraft.world.gen.foliageplacer.BlobFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.HeightWithChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.treedecorator.LeaveVineTreeDecorator;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.ModList;

public class SwampExBiomeFeatures {
    public static final BlockClusterFeatureConfig CORNFLOWER_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_222387_by.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    public static final BlockClusterFeatureConfig DUCKWEED_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)SwampExBlocks.DUCKWEED.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(1024).func_227322_d_();
    public static final BlockClusterFeatureConfig GIANT_TALL_GRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)SwampExBlocks.GIANT_TALL_GRASS.get()).func_176223_P()), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(256).func_227317_b_().func_227322_d_();
    public static final TreeFeatureConfig WILLOW_TREE_CONFIG = new TreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)SwampExBlocks.WILLOW_LOG.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((Block)SwampExBlocks.WILLOW_LEAVES.get()).func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(3, 0)).func_225569_d_(5).func_227354_b_(3).func_227360_i_(3).func_227362_k_(1).func_227353_a_((List)ImmutableList.of((Object)new LeaveVineTreeDecorator(), (Object)((Object)new HangingWillowLeavesTreeDecorator()))).setSapling((IPlantable)SwampExBlocks.WILLOW_SAPLING.get()).func_225568_b_();

    public static void addMushrooms(Biome biome) {
        if (!ModList.get().isLoaded("enhanced_mushrooms")) {
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202293_am.func_225566_b_((IFeatureConfig)new TwoFeatureChoiceConfig(Feature.field_202318_R.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226767_ab_), Feature.field_202319_S.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226768_ac_))).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
        }
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226722_J_).func_227228_a_(Placement.field_215033_s.func_227446_a_((IPlacementConfig)new HeightWithChanceConfig(1, 0.25f))));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226721_I_).func_227228_a_(Placement.field_215034_t.func_227446_a_((IPlacementConfig)new HeightWithChanceConfig(1, 0.125f))));
    }

    public static void addMarshMushrooms(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202319_S.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226768_ac_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.32f, 1))));
    }

    public static void addMarshVegetation(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)Feature.field_202339_q.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226815_j_).func_227227_a_(0.33333334f)), Feature.field_202301_A.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226739_a_))).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.25f, 1))));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226830_y_).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)CORNFLOWER_CONFIG).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226826_u_).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226720_H_).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226722_J_).func_227228_a_(Placement.field_215033_s.func_227446_a_((IPlacementConfig)new HeightWithChanceConfig(8, 0.25f))));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226721_I_).func_227228_a_(Placement.field_215034_t.func_227446_a_((IPlacementConfig)new HeightWithChanceConfig(8, 0.125f))));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226727_O_).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(130))));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_203234_at.func_225566_b_((IFeatureConfig)new SeaGrassConfig(128, 0.6)).func_227228_a_(Placement.field_215036_v.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
    }

    public static void addGiantTallGrass(Biome biome, int chance) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)GIANT_TALL_GRASS_CONFIG).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(chance))));
    }

    public static void addMarshPools(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202295_ao.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226736_X_).func_227228_a_(Placement.field_215029_o.func_227446_a_((IPlacementConfig)new CountRangeConfig(150, 8, 8, 800))));
        biome.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, Feature.field_202289_ai.func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(Blocks.field_150355_j.func_176223_P())).func_227228_a_(Placement.field_215006_E.func_227446_a_((IPlacementConfig)new ChanceConfig(48))));
    }

    public static void addCattails(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, SwampExFeatures.CATTAILS.func_225566_b_((IFeatureConfig)new NoFeatureConfig()).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(12))));
    }

    public static void addDenseCattails(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, SwampExFeatures.DENSE_CATTAILS.func_225566_b_((IFeatureConfig)new NoFeatureConfig()).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(8))));
    }

    public static void addRice(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, SwampExFeatures.RICE.func_225566_b_((IFeatureConfig)new NoFeatureConfig()).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
    }

    public static void addDuckweed(Biome biome, float chance) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DUCKWEED_CONFIG).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, chance, 1))));
    }

    public static void addWillowTrees(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, SwampExFeatures.WILLOW_TREE.func_225566_b_((IFeatureConfig)WILLOW_TREE_CONFIG).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(3, 0.1f, 1))));
    }

    public static void addSwampOaks(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)Feature.field_202339_q.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226815_j_).func_227227_a_(0.33333334f)), Feature.field_202301_A.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226739_a_))).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.05f, 1))));
    }

    public static void overrideFeatures(Biome biome) {
        for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
            List list = biome.func_203607_a(stage);
            for (int j = 0; j < list.size(); ++j) {
                TreeFeatureConfig tree;
                ConfiguredFeature configuredFeature = (ConfiguredFeature)list.get(j);
                if (!(configuredFeature.field_222738_b instanceof DecoratedFeatureConfig)) continue;
                DecoratedFeatureConfig decorated = (DecoratedFeatureConfig)configuredFeature.field_222738_b;
                if (!(decorated.field_214689_a.field_222738_b instanceof TreeFeatureConfig) || (tree = (TreeFeatureConfig)decorated.field_214689_a.field_222738_b) != DefaultBiomeFeatures.field_226814_i_) continue;
                biome.func_203607_a(stage).remove(configuredFeature);
            }
        }
    }
}

