/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.swampexpansion.common.item;

import com.farcr.swampexpansion.common.entity.SlabfishEntity;
import com.farcr.swampexpansion.common.entity.SlabfishType;
import com.teamabnormals.abnormals_core.core.utils.ItemStackUtils;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SlabfishBucketItem
extends BucketItem {
    private final Supplier<EntityType<? extends SlabfishEntity>> entityType;

    public SlabfishBucketItem(Supplier<EntityType<? extends SlabfishEntity>> entityType, Supplier<? extends Fluid> supplier, Item.Properties builder) {
        super(supplier, builder);
        this.entityType = entityType;
        this.func_185043_a(new ResourceLocation("variant"), (stack, world, entity) -> {
            CompoundNBT compoundnbt = stack.func_77978_p();
            if (compoundnbt != null && compoundnbt.func_150297_b("SlabfishType", 3)) {
                return compoundnbt.func_74762_e("SlabfishType");
            }
            return 0.0f;
        });
    }

    public void func_203792_a(World worldIn, ItemStack p_203792_2_, BlockPos pos) {
        if (!worldIn.field_72995_K) {
            this.placeEntity(worldIn, p_203792_2_, pos);
        }
    }

    protected void func_203791_b(@Nullable PlayerEntity player, IWorld worldIn, BlockPos pos) {
        worldIn.func_184133_a(player, pos, SoundEvents.field_203819_X, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    private void placeEntity(World worldIn, ItemStack stack, BlockPos pos) {
        Entity entity = this.entityType.get().func_220331_a(worldIn, stack, (PlayerEntity)null, pos, SpawnReason.BUCKET, true, false);
        if (entity != null) {
            ((SlabfishEntity)entity).setFromBucket(true);
        }
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            int targetIndex = ItemStackUtils.findIndexOfItem((Item)Items.field_204272_aO, items);
            if (targetIndex != -1) {
                items.add(targetIndex + 1, (Object)new ItemStack((IItemProvider)this));
            } else {
                super.func_150895_a(group, items);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null) {
            TextFormatting[] atextformatting;
            int i;
            if (compoundnbt.func_150297_b("SlabfishType", 3)) {
                i = compoundnbt.func_74762_e("SlabfishType");
                TextFormatting[] btextformatting = new TextFormatting[]{TextFormatting.ITALIC, SlabfishType.byId((int)i).getRarity().color};
                tooltip.add(new TranslationTextComponent(SlabfishType.byId(i).getTranslationKey(), new Object[0]).func_211709_a(btextformatting));
            }
            if (compoundnbt.func_74764_b("Age") && compoundnbt.func_74762_e("Age") < 0) {
                TextFormatting[] atextformatting2 = new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GRAY};
                tooltip.add(new TranslationTextComponent("entity.swampexpansion.slabfish.baby", new Object[0]).func_211709_a(atextformatting2));
            }
            if (compoundnbt.func_74764_b("HasBackpack") && compoundnbt.func_74767_n("HasBackpack") && compoundnbt.func_150297_b("BackpackColor", 99)) {
                i = compoundnbt.func_74762_e("BackpackColor");
                atextformatting = new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GRAY};
                tooltip.add(new TranslationTextComponent("entity.swampexpansion.slabfish." + DyeColor.func_196056_a((int)i).func_176762_d() + "_backpack", new Object[0]).func_211709_a(atextformatting));
            }
            if (compoundnbt.func_74764_b("HasSweater") && compoundnbt.func_74767_n("HasSweater") && compoundnbt.func_150297_b("SweaterColor", 99)) {
                i = compoundnbt.func_74762_e("SweaterColor");
                atextformatting = new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GRAY};
                tooltip.add(new TranslationTextComponent("entity.swampexpansion.slabfish." + DyeColor.func_196056_a((int)i).func_176762_d() + "_sweater", new Object[0]).func_211709_a(atextformatting));
            }
        }
    }
}

