/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.lightoverlay.forge;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import me.shedaniel.lightoverlay.forge.LightOverlayCloth;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.network.play.server.SMultiBlockChangePacket;
import net.minecraft.network.play.server.SUpdateLightPacket;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.lighting.IWorldLightListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.lwjgl.opengl.GL11;

public class LightOverlayClient {
    static final DecimalFormat FORMAT = new DecimalFormat("#.#");
    private static final String KEYBIND_CATEGORY = "key.lightoverlay.category";
    private static final ResourceLocation ENABLE_OVERLAY_KEYBIND = new ResourceLocation("lightoverlay", "enable_overlay");
    static int reach = 12;
    static int crossLevel = 7;
    static int secondaryLevel = -1;
    static int lowerCrossLevel = -1;
    static int higherCrossLevel = -1;
    static boolean caching = false;
    static boolean showNumber = false;
    static boolean smoothLines = true;
    static boolean underwater = false;
    static float lineWidth = 1.0f;
    static int yellowColor = 0xFFFF00;
    static int redColor = 0xFF0000;
    static int secondaryColor = 255;
    static File configFile = new File(new File(Minecraft.func_71410_x().field_71412_D, "config"), "lightoverlay.properties");
    private static final KeyBinding ENABLE_OVERLAY;
    private static boolean enabled;
    private static EntityType<Entity> testingEntityType;
    private static int threadNumber;
    private static final ExecutorService EXECUTOR;
    private static final List<ChunkPos> POS;
    private static final Map<ChunkPos, Long2ReferenceMap<Object>> CHUNK_MAP;
    private static long ticks;

    public static void register() {
        LightOverlayClient.loadConfig(configFile);
        testingEntityType = EntityType.Builder.func_220319_a((EntityClassification)EntityClassification.MONSTER).func_220321_a(0.0f, 0.0f).func_200706_c().func_206830_a(null);
        MinecraftForge.EVENT_BUS.register(LightOverlayClient.class);
        try {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> LightOverlayCloth::register);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static CrossType getCrossType(BlockPos pos, BlockPos down, IBlockReader reader, IWorldLightListener block, IWorldLightListener sky, ISelectionContext selectionContext) {
        BlockState blockBelowState = reader.func_180495_p(down);
        BlockState blockUpperState = reader.func_180495_p(pos);
        VoxelShape upperCollisionShape = blockUpperState.func_215685_b(reader, pos, selectionContext);
        if (!underwater && !blockUpperState.func_204520_s().func_206888_e()) {
            return CrossType.NONE;
        }
        if (Block.func_208061_a((VoxelShape)upperCollisionShape, (Direction)Direction.UP)) {
            return CrossType.NONE;
        }
        if (blockUpperState.func_185897_m()) {
            return CrossType.NONE;
        }
        if (upperCollisionShape.func_197758_c(Direction.Axis.Y) > 0.0) {
            return CrossType.NONE;
        }
        if (blockUpperState.func_177230_c().func_203417_a(BlockTags.field_203437_y)) {
            return CrossType.NONE;
        }
        if (!blockBelowState.func_215688_a(reader, down, testingEntityType)) {
            return CrossType.NONE;
        }
        int blockLightLevel = block.func_215611_b(pos);
        int skyLightLevel = sky.func_215611_b(pos);
        if (blockLightLevel > higherCrossLevel) {
            return CrossType.NONE;
        }
        if (skyLightLevel > higherCrossLevel) {
            return CrossType.YELLOW;
        }
        return lowerCrossLevel >= 0 && blockLightLevel > lowerCrossLevel ? CrossType.SECONDARY : CrossType.RED;
    }

    public static int getCrossLevel(BlockPos pos, BlockPos down, IBlockReader reader, IWorldLightListener light, ISelectionContext context) {
        BlockState blockBelowState = reader.func_180495_p(down);
        BlockState blockUpperState = reader.func_180495_p(pos);
        VoxelShape collisionShape = blockBelowState.func_215685_b(reader, down, context);
        VoxelShape upperCollisionShape = blockUpperState.func_215685_b(reader, pos, context);
        if (!underwater && !blockUpperState.func_204520_s().func_206888_e()) {
            return -1;
        }
        if (!blockBelowState.func_204520_s().func_206888_e()) {
            return -1;
        }
        if (blockBelowState.isAir(reader, down)) {
            return -1;
        }
        if (Block.func_208061_a((VoxelShape)upperCollisionShape, (Direction)Direction.DOWN)) {
            return -1;
        }
        return light.func_215611_b(pos);
    }

    public static void renderCross(ActiveRenderInfo info, World world, BlockPos pos, int color, ISelectionContext context) {
        double d0 = info.func_216785_c().field_72450_a;
        double d1 = info.func_216785_c().field_72448_b - 0.005;
        VoxelShape upperOutlineShape = world.func_180495_p(pos).func_215700_a((IBlockReader)world, pos, context);
        if (!upperOutlineShape.func_197766_b()) {
            d1 -= upperOutlineShape.func_197758_c(Direction.Axis.Y);
        }
        double d2 = info.func_216785_c().field_72449_c;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        RenderSystem.color4f((float)((float)red / 255.0f), (float)((float)green / 255.0f), (float)((float)blue / 255.0f), (float)1.0f);
        GL11.glVertex3d((double)((double)x + 0.01 - d0), (double)((double)y - d1), (double)((double)z + 0.01 - d2));
        GL11.glVertex3d((double)((double)x - 0.01 + 1.0 - d0), (double)((double)y - d1), (double)((double)z - 0.01 + 1.0 - d2));
        GL11.glVertex3d((double)((double)x - 0.01 + 1.0 - d0), (double)((double)y - d1), (double)((double)z + 0.01 - d2));
        GL11.glVertex3d((double)((double)x + 0.01 - d0), (double)((double)y - d1), (double)((double)z - 0.01 + 1.0 - d2));
    }

    public static void renderLevel(Minecraft minecraft, ActiveRenderInfo info, World world, BlockPos pos, BlockPos down, int level, ISelectionContext context) {
        String string_1 = String.valueOf(level);
        FontRenderer fontRenderer = minecraft.field_71466_p;
        double double_4 = info.func_216785_c().field_72450_a;
        double double_5 = info.func_216785_c().field_72448_b;
        VoxelShape upperOutlineShape = world.func_180495_p(down).func_215700_a((IBlockReader)world, down, context);
        if (!upperOutlineShape.func_197766_b()) {
            double_5 += 1.0 - upperOutlineShape.func_197758_c(Direction.Axis.Y);
        }
        double double_6 = info.func_216785_c().field_72449_c;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)((float)((double)((float)pos.func_177958_n() + 0.5f) - double_4)), (float)((float)((double)pos.func_177956_o() - double_5) + 0.005f), (float)((float)((double)((float)pos.func_177952_p() + 0.5f) - double_6)));
        RenderSystem.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
        float size = 0.07f;
        RenderSystem.scalef((float)(-size), (float)(-size), (float)size);
        float float_3 = (float)(-fontRenderer.func_78256_a(string_1)) / 2.0f + 0.4f;
        RenderSystem.enableAlphaTest();
        IRenderTypeBuffer.Impl vertexConsumerProvider$Immediate_1 = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        fontRenderer.func_228079_a_(string_1, float_3, -3.5f, level > higherCrossLevel ? -16505852 : (lowerCrossLevel >= 0 && level > lowerCrossLevel ? -16750849 : -9236207), false, TransformationMatrix.func_227983_a_().func_227988_c_(), (IRenderTypeBuffer)vertexConsumerProvider$Immediate_1, false, 0, 0xF000F0);
        vertexConsumerProvider$Immediate_1.func_228461_a_();
        RenderSystem.popMatrix();
    }

    @SubscribeEvent(receiveCanceled=true)
    public static void handleInput(InputEvent.KeyInputEvent event) {
        if (ENABLE_OVERLAY.func_151468_f()) {
            enabled = !enabled;
        }
    }

    public static void queueChunkAndNear(ChunkPos pos) {
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                LightOverlayClient.queueChunk(new ChunkPos(pos.field_77276_a + xOffset, pos.field_77275_b + zOffset));
            }
        }
    }

    public static void queueChunk(ChunkPos pos) {
        if (caching && !POS.contains(pos)) {
            POS.add(0, pos);
        }
    }

    public static int getChunkRange() {
        return Math.max(MathHelper.func_76123_f((float)((float)reach / 16.0f)), 1);
    }

    @SubscribeEvent
    public static void tick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            try {
                Minecraft minecraft = Minecraft.func_71410_x();
                ++ticks;
                if (minecraft.field_71439_g == null || !enabled) {
                    POS.clear();
                    CHUNK_MAP.clear();
                } else if (!caching) {
                    POS.clear();
                    CHUNK_MAP.clear();
                    ClientPlayerEntity player = minecraft.field_71439_g;
                    ClientWorld world = minecraft.field_71441_e;
                    BlockPos playerPos = player.func_180425_c();
                    ISelectionContext entityContext = ISelectionContext.func_216374_a((Entity)player);
                    IWorldLightListener block = world.func_225524_e_().func_215569_a(LightType.BLOCK);
                    IWorldLightListener sky = showNumber ? null : world.func_225524_e_().func_215569_a(LightType.SKY);
                    BlockPos.Mutable downPos = new BlockPos.Mutable();
                    Iterable iterate = BlockPos.func_191531_b((int)(playerPos.func_177958_n() - reach), (int)(playerPos.func_177956_o() - reach), (int)(playerPos.func_177952_p() - reach), (int)(playerPos.func_177958_n() + reach), (int)(playerPos.func_177956_o() + reach), (int)(playerPos.func_177952_p() + reach));
                    Long2ReferenceOpenHashMap map = new Long2ReferenceOpenHashMap();
                    CHUNK_MAP.put(new ChunkPos(0, 0), (Long2ReferenceMap<Object>)map);
                    for (BlockPos blockPos : iterate) {
                        CrossType type;
                        downPos.func_181079_c(blockPos.func_177958_n(), blockPos.func_177956_o() - 1, blockPos.func_177952_p());
                        if (showNumber) {
                            int level = LightOverlayClient.getCrossLevel(blockPos, (BlockPos)downPos, (IBlockReader)world, block, entityContext);
                            if (level < 0) continue;
                            map.put(blockPos.func_218275_a(), (Object)level);
                            continue;
                        }
                        Biome biome = world.func_225523_d_().func_226836_a_(blockPos);
                        if (!(biome.func_76741_f() > 0.0f) || biome.func_76747_a(EntityClassification.MONSTER).isEmpty() || (type = LightOverlayClient.getCrossType(blockPos, (BlockPos)downPos, (IBlockReader)world, block, sky, entityContext)) == CrossType.NONE) continue;
                        map.put(blockPos.func_218275_a(), (Object)type);
                    }
                } else {
                    ClientPlayerEntity player = minecraft.field_71439_g;
                    ClientWorld world = minecraft.field_71441_e;
                    ISelectionContext selectionContext = ISelectionContext.func_216374_a((Entity)player);
                    Vec3d[] playerPos = new Vec3d[]{null};
                    int playerPosX = (int)player.func_226277_ct_() >> 4;
                    int playerPosZ = (int)player.func_226281_cx_() >> 4;
                    if (ticks % 20L == 0L) {
                        for (int chunkX = playerPosX - LightOverlayClient.getChunkRange(); chunkX <= playerPosX + LightOverlayClient.getChunkRange(); ++chunkX) {
                            for (int chunkZ = playerPosZ - LightOverlayClient.getChunkRange(); chunkZ <= playerPosZ + LightOverlayClient.getChunkRange(); ++chunkZ) {
                                ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
                                if (CHUNK_MAP.containsKey(chunkPos)) continue;
                                LightOverlayClient.queueChunk(chunkPos);
                            }
                        }
                    }
                    POS.removeIf(pos -> MathHelper.func_76130_a((int)(pos.field_77276_a - playerPosX)) > LightOverlayClient.getChunkRange() || MathHelper.func_76130_a((int)(pos.field_77275_b - playerPosZ)) > LightOverlayClient.getChunkRange());
                    for (int k = 0; k < 2; ++k) {
                        if (POS.isEmpty()) continue;
                        if (playerPos[0] == null) {
                            playerPos[0] = player.func_213303_ch();
                        }
                        ChunkPos pos2 = POS.stream().min(Comparator.comparingDouble(value -> {
                            int i = Math.abs(value.field_77276_a - playerPosX);
                            int j = Math.abs(value.field_77275_b - playerPosZ);
                            return i * i + j * j;
                        })).get();
                        POS.remove(pos2);
                        EXECUTOR.submit(() -> {
                            try {
                                LightOverlayClient.calculateChunk(world.func_72863_F().func_212849_a_(pos.field_77276_a, pos.field_77275_b, ChunkStatus.field_222617_m, false), (World)world, pos2, selectionContext);
                            }
                            catch (Throwable throwable) {
                                LogManager.getLogger().throwing(throwable);
                            }
                        });
                    }
                    if (ticks % 50L == 0L) {
                        CHUNK_MAP.entrySet().removeIf(pos -> MathHelper.func_76130_a((int)(((ChunkPos)pos.getKey()).field_77276_a - playerPosX)) > LightOverlayClient.getChunkRange() * 2 || MathHelper.func_76130_a((int)(((ChunkPos)pos.getKey()).field_77275_b - playerPosZ)) > LightOverlayClient.getChunkRange() * 2);
                    }
                }
            }
            catch (Exception e) {
                LogManager.getLogger().throwing((Throwable)e);
            }
        }
    }

    private static void calculateChunk(Chunk chunk, World world, ChunkPos chunkPos, ISelectionContext selectionContext) {
        if (chunk != null) {
            Long2ReferenceOpenHashMap map = new Long2ReferenceOpenHashMap();
            IWorldLightListener block = chunk.func_217307_e().func_215569_a(LightType.BLOCK);
            IWorldLightListener sky = showNumber ? null : chunk.func_217307_e().func_215569_a(LightType.SKY);
            for (BlockPos pos : BlockPos.func_191531_b((int)chunkPos.func_180334_c(), (int)0, (int)chunkPos.func_180333_d(), (int)chunkPos.func_180332_e(), (int)256, (int)chunkPos.func_180330_f())) {
                CrossType type;
                BlockPos down = pos.func_177977_b();
                if (showNumber) {
                    int level = LightOverlayClient.getCrossLevel(pos, down, (IBlockReader)chunk, block, selectionContext);
                    if (level < 0) continue;
                    map.put(pos.func_218275_a(), (Object)level);
                    continue;
                }
                Biome biome = world.func_225523_d_().func_226836_a_(pos);
                if (!(biome.func_76741_f() > 0.0f) || biome.func_76747_a(EntityClassification.MONSTER).isEmpty() || (type = LightOverlayClient.getCrossType(pos, down, (IBlockReader)chunk, block, sky, selectionContext)) == CrossType.NONE) continue;
                map.put(pos.func_218275_a(), (Object)type);
            }
            CHUNK_MAP.put(chunkPos, (Long2ReferenceMap<Object>)map);
        } else {
            CHUNK_MAP.remove(chunkPos);
        }
    }

    public static void renderWorldLast() {
        if (enabled) {
            RenderSystem.pushMatrix();
            Minecraft client = Minecraft.func_71410_x();
            ClientPlayerEntity playerEntity = client.field_71439_g;
            int playerPosX = (int)playerEntity.func_226277_ct_() >> 4;
            int playerPosZ = (int)playerEntity.func_226281_cx_() >> 4;
            ISelectionContext selectionContext = ISelectionContext.func_216374_a((Entity)playerEntity);
            ClientWorld world = client.field_71441_e;
            BlockPos playerPos = playerEntity.func_180425_c();
            ActiveRenderInfo info = client.field_71460_t.func_215316_n();
            if (showNumber) {
                RenderSystem.enableTexture();
                RenderSystem.depthMask((boolean)true);
                BlockPos.Mutable mutable = new BlockPos.Mutable();
                for (Map.Entry<ChunkPos, Long2ReferenceMap<Object>> entry : CHUNK_MAP.entrySet()) {
                    if (caching && (MathHelper.func_76130_a((int)(entry.getKey().field_77276_a - playerPosX)) > LightOverlayClient.getChunkRange() || MathHelper.func_76130_a((int)(entry.getKey().field_77275_b - playerPosZ)) > LightOverlayClient.getChunkRange())) continue;
                    for (Long2ReferenceMap.Entry objectEntry : entry.getValue().long2ReferenceEntrySet()) {
                        if (!(objectEntry.getValue() instanceof Integer)) continue;
                        mutable.func_181079_c(BlockPos.func_218290_b((long)objectEntry.getLongKey()), BlockPos.func_218274_c((long)objectEntry.getLongKey()), BlockPos.func_218282_d((long)objectEntry.getLongKey()));
                        if (!mutable.func_218141_a((Vec3i)playerPos, (double)reach)) continue;
                        BlockPos down = mutable.func_177977_b();
                        LightOverlayClient.renderLevel(client, info, (World)world, (BlockPos)mutable, down, (Integer)objectEntry.getValue(), selectionContext);
                    }
                }
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.enableDepthTest();
            } else {
                RenderSystem.enableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                if (smoothLines) {
                    GL11.glEnable((int)2848);
                }
                GL11.glLineWidth((float)lineWidth);
                GL11.glBegin((int)1);
                BlockPos.Mutable mutable = new BlockPos.Mutable();
                for (Map.Entry<ChunkPos, Long2ReferenceMap<Object>> entry : CHUNK_MAP.entrySet()) {
                    if (caching && (MathHelper.func_76130_a((int)(entry.getKey().field_77276_a - playerPosX)) > LightOverlayClient.getChunkRange() || MathHelper.func_76130_a((int)(entry.getKey().field_77275_b - playerPosZ)) > LightOverlayClient.getChunkRange())) continue;
                    for (Long2ReferenceMap.Entry objectEntry : entry.getValue().long2ReferenceEntrySet()) {
                        if (!(objectEntry.getValue() instanceof CrossType)) continue;
                        mutable.func_181079_c(BlockPos.func_218290_b((long)objectEntry.getLongKey()), BlockPos.func_218274_c((long)objectEntry.getLongKey()), BlockPos.func_218282_d((long)objectEntry.getLongKey()));
                        if (!mutable.func_218141_a((Vec3i)playerPos, (double)reach)) continue;
                        BlockPos down = mutable.func_177977_b();
                        int color = objectEntry.getValue() == CrossType.RED ? redColor : (objectEntry.getValue() == CrossType.YELLOW ? yellowColor : secondaryColor);
                        LightOverlayClient.renderCross(info, (World)world, (BlockPos)mutable, color, selectionContext);
                    }
                }
                GL11.glEnd();
                RenderSystem.disableBlend();
                RenderSystem.enableTexture();
                if (smoothLines) {
                    GL11.glDisable((int)2848);
                }
            }
            RenderSystem.popMatrix();
        }
    }

    private static KeyBinding registerKeybind(ResourceLocation resourceLocation, InputMappings.Type type, int keyCode, String category) {
        KeyBinding keyBinding = new KeyBinding("key." + resourceLocation.func_110624_b() + "." + resourceLocation.func_110623_a(), (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, type, keyCode, category);
        ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
        return keyBinding;
    }

    static void loadConfig(File file) {
        try {
            redColor = 0xFF0000;
            yellowColor = 0xFFFF00;
            secondaryColor = 255;
            if (!file.exists() || !file.canRead()) {
                LightOverlayClient.saveConfig(file);
            }
            FileInputStream fis = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fis);
            fis.close();
            reach = Integer.parseInt((String)properties.computeIfAbsent("reach", (Function<? super Object, ?>)((Function<Object, Object>)a -> "12")));
            crossLevel = Integer.parseInt((String)properties.computeIfAbsent("crossLevel", (Function<? super Object, ?>)((Function<Object, Object>)a -> "7")));
            secondaryLevel = Integer.parseInt((String)properties.computeIfAbsent("secondaryLevel", (Function<? super Object, ?>)((Function<Object, Object>)a -> "-1")));
            caching = ((String)properties.computeIfAbsent("caching", (Function<? super Object, ?>)((Function<Object, Object>)a -> "false"))).equalsIgnoreCase("true");
            showNumber = ((String)properties.computeIfAbsent("showNumber", (Function<? super Object, ?>)((Function<Object, Object>)a -> "false"))).equalsIgnoreCase("true");
            smoothLines = ((String)properties.computeIfAbsent("smoothLines", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true"))).equalsIgnoreCase("true");
            underwater = ((String)properties.computeIfAbsent("underwater", (Function<? super Object, ?>)((Function<Object, Object>)a -> "false"))).equalsIgnoreCase("true");
            lineWidth = Float.parseFloat((String)properties.computeIfAbsent("lineWidth", (Function<? super Object, ?>)((Function<Object, Object>)a -> "1")));
            int r = Integer.parseInt((String)properties.computeIfAbsent("yellowColorRed", (Function<? super Object, ?>)((Function<Object, Object>)a -> "255")));
            int g = Integer.parseInt((String)properties.computeIfAbsent("yellowColorGreen", (Function<? super Object, ?>)((Function<Object, Object>)a -> "255")));
            int b = Integer.parseInt((String)properties.computeIfAbsent("yellowColorBlue", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            yellowColor = (r << 16) + (g << 8) + b;
            r = Integer.parseInt((String)properties.computeIfAbsent("redColorRed", (Function<? super Object, ?>)((Function<Object, Object>)a -> "255")));
            g = Integer.parseInt((String)properties.computeIfAbsent("redColorGreen", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            b = Integer.parseInt((String)properties.computeIfAbsent("redColorBlue", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            redColor = (r << 16) + (g << 8) + b;
            r = Integer.parseInt((String)properties.computeIfAbsent("secondaryColorRed", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            g = Integer.parseInt((String)properties.computeIfAbsent("secondaryColorGreen", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            b = Integer.parseInt((String)properties.computeIfAbsent("secondaryColorBlue", (Function<? super Object, ?>)((Function<Object, Object>)a -> "255")));
            secondaryColor = (r << 16) + (g << 8) + b;
            LightOverlayClient.saveConfig(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            reach = 12;
            crossLevel = 7;
            secondaryLevel = -1;
            lineWidth = 1.0f;
            redColor = 0xFF0000;
            yellowColor = 0xFFFF00;
            secondaryColor = 255;
            caching = false;
            showNumber = false;
            smoothLines = true;
            underwater = false;
            try {
                LightOverlayClient.saveConfig(file);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (secondaryLevel >= crossLevel) {
            System.err.println("[Light Overlay] Secondary Level is higher than Cross Level");
        }
        lowerCrossLevel = Math.min(crossLevel, secondaryLevel);
        higherCrossLevel = Math.max(crossLevel, secondaryLevel);
        CHUNK_MAP.clear();
        POS.clear();
    }

    static void saveConfig(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file, false);
        fos.write("# Light Overlay Config".getBytes());
        fos.write("\n".getBytes());
        fos.write(("reach=" + reach).getBytes());
        fos.write("\n".getBytes());
        fos.write(("crossLevel=" + crossLevel).getBytes());
        fos.write("\n".getBytes());
        fos.write(("secondaryLevel=" + secondaryLevel).getBytes());
        fos.write("\n".getBytes());
        fos.write(("caching=" + caching).getBytes());
        fos.write("\n".getBytes());
        fos.write(("showNumber=" + showNumber).getBytes());
        fos.write("\n".getBytes());
        fos.write(("smoothLines=" + smoothLines).getBytes());
        fos.write("\n".getBytes());
        fos.write(("underwater=" + underwater).getBytes());
        fos.write("\n".getBytes());
        fos.write(("lineWidth=" + FORMAT.format(lineWidth)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("yellowColorRed=" + (yellowColor >> 16 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("yellowColorGreen=" + (yellowColor >> 8 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("yellowColorBlue=" + (yellowColor & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("redColorRed=" + (redColor >> 16 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("redColorGreen=" + (redColor >> 8 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("redColorBlue=" + (redColor & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("secondaryColorRed=" + (secondaryColor >> 16 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("secondaryColorGreen=" + (secondaryColor >> 8 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("secondaryColorBlue=" + (secondaryColor & 0xFF)).getBytes());
        fos.close();
    }

    public static void processPacket(IPacket<?> packet) {
        if (packet instanceof SChangeBlockPacket) {
            LightOverlayClient.queueChunkAndNear(new ChunkPos(((SChangeBlockPacket)packet).func_179827_b()));
        } else if (packet instanceof SChunkDataPacket) {
            LightOverlayClient.queueChunkAndNear(new ChunkPos(((SChunkDataPacket)packet).func_149273_e(), ((SChunkDataPacket)packet).func_149271_f()));
        } else if (packet instanceof SMultiBlockChangePacket) {
            ChunkPos chunkPos = (ChunkPos)ObfuscationReflectionHelper.getPrivateValue(SMultiBlockChangePacket.class, (Object)((SMultiBlockChangePacket)packet), (String)"field_148925_b");
            LightOverlayClient.queueChunkAndNear(new ChunkPos(chunkPos.field_77276_a, chunkPos.field_77275_b));
        } else if (packet instanceof SUpdateLightPacket) {
            LightOverlayClient.queueChunkAndNear(new ChunkPos(((SUpdateLightPacket)packet).func_218716_b(), ((SUpdateLightPacket)packet).func_218714_c()));
        }
    }

    static {
        enabled = false;
        threadNumber = 0;
        EXECUTOR = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), r -> {
            Thread thread = new Thread(r, "light-overlay-" + threadNumber++);
            thread.setDaemon(true);
            return thread;
        });
        POS = Lists.newCopyOnWriteArrayList();
        CHUNK_MAP = Maps.newConcurrentMap();
        ticks = 0L;
        ENABLE_OVERLAY = LightOverlayClient.registerKeybind(ENABLE_OVERLAY_KEYBIND, InputMappings.Type.KEYSYM, 296, KEYBIND_CATEGORY);
    }

    private static enum CrossType {
        YELLOW,
        RED,
        SECONDARY,
        NONE;

    }
}

