/*
 * Decompiled with CFR 0.152.
 */
package shadows.menu.buttons;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import shadows.menu.ExtendedMenuScreen;
import shadows.menu.buttons.ActionInstance;
import shadows.menu.buttons.AnchorPoint;
import shadows.menu.buttons.ButtonAction;

public class JsonButton
extends Button {
    protected ResourceLocation texture = WIDGETS_LOCATION;
    protected int u;
    protected int v;
    protected int hoverU;
    protected int hoverV;
    protected int texWidth;
    protected int texHeight;
    protected final int xOff;
    protected final int yOff;
    protected boolean usesWidgets = false;
    protected final String langKey;
    protected final int fontColor;
    protected final int hoverFontColor;
    protected AnchorPoint anchor = AnchorPoint.DEFAULT;
    protected int textXOff;
    protected int textYOff;
    protected boolean dropShadow;

    public JsonButton(int xPos, int yPos, int width, int height, int fontColor, int hoverFontColor, String langKey, ActionInstance handler) {
        super(xPos, yPos, width, height, langKey, (Button.IPressable)handler);
        handler.setSource(this);
        this.xOff = xPos;
        this.yOff = yPos;
        this.langKey = langKey;
        this.fontColor = fontColor;
        this.hoverFontColor = hoverFontColor;
    }

    public JsonButton texture(ResourceLocation texture, int u, int v, int hoverU, int hoverV, int texWidth, int texHeight) {
        this.texture = texture;
        this.u = u;
        this.v = v;
        this.hoverU = hoverU;
        this.hoverV = hoverV;
        this.texHeight = texHeight;
        this.texWidth = texWidth;
        return this;
    }

    public JsonButton anchor(AnchorPoint anchor) {
        this.anchor = anchor;
        return this;
    }

    public JsonButton usesWidgets(boolean widgets) {
        this.usesWidgets = widgets;
        return this;
    }

    public JsonButton textOffsets(int x, int y) {
        this.textXOff = x;
        this.textYOff = y;
        return this;
    }

    public JsonButton setup(ExtendedMenuScreen screen) {
        this.x = this.xOff + this.anchor.getX(screen);
        this.y = this.yOff + this.anchor.getY(screen);
        this.setMessage(I18n.func_135052_a((String)this.langKey, (Object[])new Object[0]));
        return this;
    }

    public JsonButton dropShadow(boolean dropShadow) {
        this.dropShadow = dropShadow;
        return this;
    }

    public void renderButton(int mouseX, int mouseY, float partial) {
        if (this.visible) {
            if (this.usesWidgets) {
                this.renderWidgetButton(mouseX, mouseY, partial);
            } else {
                this.renderImageButton(mouseX, mouseY, partial);
            }
        }
    }

    public static void drawCenteredStringNoShadow(FontRenderer font, String string, int x, int y, int color) {
        font.func_211126_b(string, (float)(x - font.func_78256_a(string) / 2), (float)y, color);
    }

    public void drawCenteredString(FontRenderer font, String string, int x, int y, int color) {
        if (this.dropShadow) {
            super.drawCenteredString(font, string, x, y, color);
        } else {
            JsonButton.drawCenteredStringNoShadow(font, string, x, y, color);
        }
    }

    private void renderWidgetButton(int mouseX, int mouseY, float partial) {
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fontrenderer = minecraft.field_71466_p;
        minecraft.func_110434_K().func_110577_a(this.texture);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        int i = this.getYImage(this.isHovered());
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.blit(this.x, this.y, 0, 46 + i * 20, this.width / 2, this.height);
        this.blit(this.x + this.width / 2, this.y, 200 - this.width / 2, 46 + i * 20, this.width / 2, this.height);
        this.renderBg(minecraft, mouseX, mouseY);
        int j = this.getFGColor();
        this.drawCenteredString(fontrenderer, this.getMessage(), this.x + this.width / 2 + this.textXOff, this.y + this.height / 2 + this.textYOff, j | MathHelper.func_76123_f((float)(this.alpha * 255.0f)) << 24);
    }

    private void renderImageButton(int mouseX, int mouseY, float partial) {
        Minecraft mc = Minecraft.func_71410_x();
        this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
        mc.func_110434_K().func_110577_a(this.texture);
        RenderSystem.disableDepthTest();
        int x = this.u;
        int y = this.v;
        if (this.isHovered()) {
            x = this.hoverU;
            y = this.hoverV;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        JsonButton.blit((int)this.x, (int)this.y, (float)x, (float)y, (int)this.width, (int)this.height, (int)this.texWidth, (int)this.texHeight);
        RenderSystem.enableDepthTest();
        int color = this.getFGColor();
        String buttonText = this.getMessage();
        int strWidth = mc.field_71466_p.func_78256_a(buttonText);
        int ellipsisWidth = mc.field_71466_p.func_78256_a("...");
        if (strWidth > this.width - 6 && strWidth > ellipsisWidth) {
            buttonText = mc.field_71466_p.func_78269_a(buttonText, this.width - 6 - ellipsisWidth).trim() + "...";
        }
        this.drawCenteredString(mc.field_71466_p, buttonText, this.x + this.width / 2 + this.textXOff, this.y + this.height / 2 + this.textYOff, color);
    }

    public int getFGColor() {
        return !this.isHovered ? this.fontColor : this.hoverFontColor;
    }

    public static JsonButton deserialize(JsonObject obj) {
        JsonElement x = obj.get("x");
        JsonElement y = obj.get("y");
        JsonElement width = obj.get("width");
        JsonElement height = obj.get("height");
        JsonElement tex = obj.get("texture");
        JsonElement u = obj.get("u");
        JsonElement v = obj.get("v");
        JsonElement hoverU = obj.get("hoverU");
        JsonElement hoverV = obj.get("hoverV");
        JsonElement texWidth = obj.get("texWidth");
        JsonElement texHeight = obj.get("texHeight");
        JsonElement widgets = obj.get("widgets");
        JsonElement langKey = obj.get("langKey");
        JsonElement action = obj.get("action");
        JsonElement fontColor = obj.get("fontColor");
        JsonElement hoverFontColor = obj.get("hoverFontColor");
        JsonElement anchor = obj.get("anchor");
        JsonElement textX = obj.get("textXOffset");
        JsonElement textY = obj.get("textYOffset");
        JsonElement dropShadow = obj.get("dropShadow");
        JsonElement active = obj.get("active");
        ResourceLocation _tex = tex == null ? WIDGETS_LOCATION : new ResourceLocation(tex.getAsString());
        int _u = JsonButton.get(u, 0);
        int _v = JsonButton.get(v, 0);
        int _hoverU = JsonButton.get(hoverU, 0);
        int _hoverV = JsonButton.get(hoverV, 0);
        int _x = JsonButton.get(x, 0);
        int _y = JsonButton.get(y, 0);
        int _width = JsonButton.get(width, 0);
        int _height = JsonButton.get(height, 0);
        int _texWidth = JsonButton.get(texWidth, 256);
        int _texHeight = JsonButton.get(texHeight, 256);
        boolean _widgets = widgets == null ? _tex.toString().contains("widgets") : widgets.getAsBoolean();
        int _fontColor = JsonButton.get(fontColor, 0xFFFFFF);
        int _hoverFontColor = JsonButton.get(hoverFontColor, 0xFFFFFF);
        String display = langKey == null ? "" : I18n.func_135052_a((String)langKey.getAsString(), (Object[])new Object[0]);
        ButtonAction act = ButtonAction.valueOf(action.getAsString().toUpperCase(Locale.ROOT));
        AnchorPoint _anchor = anchor == null ? AnchorPoint.DEFAULT : AnchorPoint.valueOf(anchor.getAsString());
        Object data = act.readData(obj);
        int _textX = JsonButton.get(textX, 0);
        int _textY = JsonButton.get(textY, -4);
        boolean _dropShadow = dropShadow == null ? true : dropShadow.getAsBoolean();
        JsonButton button = new JsonButton(_x, _y, _width, _height, _fontColor, _hoverFontColor, display, new ActionInstance(act, data)).texture(_tex, _u, _v, _hoverU, _hoverV, _texWidth, _texHeight).usesWidgets(_widgets).anchor(_anchor).textOffsets(_textX, _textY).dropShadow(_dropShadow);
        button.active = active == null ? true : active.getAsBoolean();
        return button;
    }

    private static int get(JsonElement e, int def) {
        return e == null ? def : e.getAsInt();
    }
}

