/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.capabilities;

import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.items.IItemHandler;

public class DrawerItemHandler
implements IItemHandler {
    @CapabilityInject(value=IItemRepository.class)
    public static Capability<IItemRepository> ITEM_REPOSITORY_CAPABILITY = null;
    private IDrawerGroup group;

    public DrawerItemHandler(IDrawerGroup group) {
        this.group = group;
    }

    public int getSlots() {
        if (!this.group.isGroupValid()) {
            return 0;
        }
        return this.group.getDrawerCount() + 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        IDrawer drawer;
        if (!this.group.isGroupValid()) {
            return ItemStack.field_190927_a;
        }
        if (this.slotIsVirtual(slot)) {
            return ItemStack.field_190927_a;
        }
        int[] order = this.group.getAccessibleDrawerSlots();
        if (!(drawer = this.group.getDrawer(slot = --slot >= 0 && slot < order.length ? order[slot] : -1)).isEnabled() || drawer.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = drawer.getStoredItemPrototype().func_77946_l();
        stack.func_190920_e(drawer.getStoredItemCount());
        return stack;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        IDrawer prevDrawer;
        IDrawer drawer;
        int prevSlot;
        if (!this.group.isGroupValid()) {
            return stack;
        }
        if (this.slotIsVirtual(slot)) {
            return this.insertItemFullScan(stack, simulate);
        }
        int[] order = this.group.getAccessibleDrawerSlots();
        int orderedSlot = --slot >= 0 && slot < order.length ? order[slot] : -1;
        int n = prevSlot = slot >= 1 && slot < order.length ? order[slot - 1] : -1;
        if (orderedSlot > 0 && (drawer = this.group.getDrawer(orderedSlot)).isEnabled() && drawer.isEmpty() && (!(prevDrawer = this.group.getDrawer(prevSlot)).isEnabled() || !prevDrawer.isEmpty())) {
            return this.insertItemFullScan(stack, simulate);
        }
        return this.insertItemInternal(orderedSlot, stack, simulate);
    }

    @Nonnull
    private ItemStack insertItemFullScan(@Nonnull ItemStack stack, boolean simulate) {
        IItemRepository itemRepo = (IItemRepository)this.group.getCapability(ITEM_REPOSITORY_CAPABILITY, null).orElse(null);
        if (itemRepo != null) {
            return itemRepo.insertItem(stack, simulate);
        }
        for (int i = 0; i < this.group.getDrawerCount() && !(stack = this.insertItemInternal(i, stack, simulate)).func_190926_b(); ++i) {
        }
        return stack;
    }

    @Nonnull
    private ItemStack insertItemInternal(int slot, @Nonnull ItemStack stack, boolean simulate) {
        int remainder;
        IDrawer drawer = this.group.getDrawer(slot);
        if (!drawer.canItemBeStored(stack)) {
            return stack;
        }
        if (drawer.isEmpty() && !simulate) {
            drawer = drawer.setStoredItem(stack);
        }
        boolean empty = drawer.isEmpty();
        int n = simulate ? Math.max(stack.func_190916_E() - (empty ? drawer.getAcceptingMaxCapacity(stack) : drawer.getAcceptingRemainingCapacity()), 0) : (remainder = drawer.adjustStoredItemCount(stack.func_190916_E()));
        if (remainder == stack.func_190916_E()) {
            return stack;
        }
        if (remainder == 0) {
            return ItemStack.field_190927_a;
        }
        return this.stackResult(stack, remainder);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        IDrawer drawer;
        if (!this.group.isGroupValid()) {
            return ItemStack.field_190927_a;
        }
        if (this.slotIsVirtual(slot)) {
            return ItemStack.field_190927_a;
        }
        int[] order = this.group.getAccessibleDrawerSlots();
        if (!(drawer = this.group.getDrawer(slot = --slot >= 0 && slot < order.length ? order[slot] : -1)).isEnabled() || drawer.isEmpty() || drawer.getStoredItemCount() == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack prototype = drawer.getStoredItemPrototype();
        int remaining = simulate ? Math.max(amount - drawer.getStoredItemCount(), 0) : drawer.adjustStoredItemCount(-amount);
        return this.stackResult(prototype, amount - remaining);
    }

    public int getSlotLimit(int slot) {
        if (!this.group.isGroupValid()) {
            return 0;
        }
        if (this.slotIsVirtual(slot)) {
            return Integer.MAX_VALUE;
        }
        IDrawer drawer = this.group.getDrawer(slot);
        if (!drawer.isEnabled()) {
            return 0;
        }
        if (drawer.isEmpty()) {
            return drawer.getMaxCapacity(ItemStack.field_190927_a);
        }
        return drawer.getMaxCapacity();
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    private boolean slotIsVirtual(int slot) {
        return slot == 0;
    }

    private ItemStack stackResult(@Nonnull ItemStack stack, int amount) {
        ItemStack result = stack.func_77946_l();
        result.func_190920_e(amount);
        return result;
    }
}

