/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.renderers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class SupporterFancyHandler {
    public static final Map<String, FancyInfo> FANCY_INFOS = new HashMap<String, FancyInfo>();

    public SupporterFancyHandler() {
        new FetchThread();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        PlayerEntity player = event.player;
        if (!player.field_70170_p.field_72995_K) {
            return;
        }
        if (player.func_82150_aj() || !player.func_175148_a(PlayerModelPart.CAPE)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (player == mc.field_71439_g && mc.field_71474_y.field_74320_O == 0) {
            return;
        }
        FancyInfo info = FANCY_INFOS.get(player.func_146103_bH().getName());
        if (info == null) {
            return;
        }
        Random rand = player.field_70170_p.field_73012_v;
        if (rand.nextFloat() >= 0.75f) {
            int color;
            if (info.tier == 1) {
                BlockPos pos = player.func_180425_c();
                color = BiomeColors.func_228361_b_((ILightReader)player.field_70170_p, (BlockPos)pos);
            } else {
                color = info.color;
            }
            NaturesAuraAPI.instance().spawnMagicParticle(player.func_226277_ct_() + rand.nextGaussian() * (double)0.15f, player.func_226278_cu_() + (double)(rand.nextFloat() * 1.8f), player.func_226281_cx_() + rand.nextGaussian() * (double)0.15f, rand.nextGaussian() * (double)0.01f, rand.nextFloat() * 0.01f, rand.nextGaussian() * (double)0.01f, color, rand.nextFloat() + 1.0f, rand.nextInt(50) + 50, 0.0f, false, true);
        }
    }

    private static class FetchThread
    extends Thread {
        public FetchThread() {
            this.setName("naturesaura_support_fetcher");
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            try {
                URL url = new URL("https://raw.githubusercontent.com/Ellpeck/NaturesAura/master/supporters.json");
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(url.openStream()));
                JsonParser parser = new JsonParser();
                JsonObject main = parser.parse(reader).getAsJsonObject();
                for (Map.Entry entry : main.entrySet()) {
                    JsonObject object = ((JsonElement)entry.getValue()).getAsJsonObject();
                    int tier = object.get("tier").getAsInt();
                    int color = object.has("color") ? Integer.parseInt(object.get("color").getAsString(), 16) : 0;
                    FANCY_INFOS.put((String)entry.getKey(), new FancyInfo(tier, color));
                }
                reader.close();
            }
            catch (Exception e) {
                NaturesAura.LOGGER.warn("Fetching supporter information failed", (Throwable)e);
            }
        }
    }

    public static class FancyInfo {
        public final int tier;
        public final int color;

        public FancyInfo(int tier, int color) {
            this.tier = tier;
            this.color = color;
        }
    }
}

