/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items.tools;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.data.ItemModelGenerator;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.reg.ICustomItemModel;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.ModRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.HoeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemHoe
extends HoeItem
implements IModItem,
ICustomItemModel {
    private final String baseName;

    public ItemHoe(String baseName, IItemTier material, float speed) {
        super(material, speed, new Item.Properties().func_200916_a(NaturesAura.CREATIVE_TAB));
        this.baseName = baseName;
        ModRegistry.add(this);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (this == ModItems.INFUSED_IRON_HOE) {
            World world = context.func_195991_k();
            ActionResultType result = super.func_195939_a(context);
            if (!world.field_72995_K && result == ActionResultType.SUCCESS) {
                ItemStack seed = ItemStack.field_190927_a;
                Random random = world.func_201674_k();
                BlockPos pos = context.func_195995_a();
                if (random.nextInt(5) == 0) {
                    seed = new ItemStack((IItemProvider)Items.field_151014_N);
                } else if (random.nextInt(10) == 0) {
                    int rand = random.nextInt(3);
                    if (rand == 0) {
                        seed = new ItemStack((IItemProvider)Items.field_151081_bc);
                    } else if (rand == 1) {
                        seed = new ItemStack((IItemProvider)Items.field_151080_bb);
                    } else if (rand == 2) {
                        seed = new ItemStack((IItemProvider)Items.field_185163_cU);
                    }
                }
                if (!seed.func_190926_b()) {
                    ItemEntity item = new ItemEntity(world, (double)((float)pos.func_177958_n() + random.nextFloat()), (double)((float)pos.func_177956_o() + 1.0f), (double)((float)pos.func_177952_p() + random.nextFloat()), seed);
                    world.func_217376_c((Entity)item);
                }
            }
            return result;
        }
        if (this == ModItems.SKY_HOE) {
            boolean success = false;
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos offset = context.func_195995_a().func_177982_a(x, 0, z);
                    BlockRayTraceResult newResult = new BlockRayTraceResult(context.func_221532_j(), context.func_196000_l(), offset, context.func_221533_k());
                    ItemUseContext newContext = new ItemUseContext(context.func_195999_j(), context.func_221531_n(), newResult);
                    success |= super.func_195939_a(newContext) == ActionResultType.SUCCESS;
                }
            }
            return success ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        return super.func_195939_a(context);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        if (stack.func_77973_b() == ModItems.SKY_HOE) {
            if (!(player.field_70170_p.func_180495_p(pos).func_177230_c() instanceof BushBlock)) {
                return false;
            }
            if (!player.field_70170_p.field_72995_K) {
                int range = 3;
                for (int x = -range; x <= range; ++x) {
                    for (int y = -range; y <= range; ++y) {
                        for (int z = -range; z <= range; ++z) {
                            BlockPos offset;
                            BlockState otherState;
                            if (x == 0 && y == 0 && z == 0 || !((otherState = player.field_70170_p.func_180495_p(offset = pos.func_177982_a(x, y, z))).func_177230_c() instanceof BushBlock)) continue;
                            player.field_70170_p.func_175655_b(offset, true);
                        }
                    }
                }
            }
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return Helper.makeRechargeProvider(stack, true);
    }

    @Override
    public void generateCustomItemModel(ItemModelGenerator generator) {
        ((ItemModelBuilder)generator.withExistingParent(this.getBaseName(), "item/handheld")).texture("layer0", "item/" + this.getBaseName());
    }
}

