/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat.jei;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.ellpeck.naturesaura.compat.jei.JEINaturesAuraPlugin;
import de.ellpeck.naturesaura.recipes.AnimalSpawnerRecipe;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AnimalSpawnerCategory
implements IRecipeCategory<AnimalSpawnerRecipe> {
    private final IDrawable background;
    private final Map<EntityType, Entity> entityCache = new HashMap<EntityType, Entity>();

    public AnimalSpawnerCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(new ResourceLocation("naturesaura", "textures/gui/jei/animal_spawner.png"), 0, 0, 72, 86);
    }

    private static void renderEntity(int x, int y, float scale, float yaw, float pitch, LivingEntity entity) {
        float f = (float)Math.atan(yaw / 40.0f);
        float f1 = (float)Math.atan(pitch / 40.0f);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixstack.func_227862_a_(scale, scale, scale);
        Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        Quaternion quaternion1 = Vector3f.field_229179_b_.func_229187_a_(f1 * 20.0f);
        quaternion.func_195890_a(quaternion1);
        matrixstack.func_227863_a_(quaternion);
        float f2 = entity.field_70761_aq;
        float f3 = entity.field_70177_z;
        float f4 = entity.field_70125_A;
        float f5 = entity.field_70758_at;
        float f6 = entity.field_70759_as;
        entity.field_70761_aq = 180.0f + f * 20.0f;
        entity.field_70177_z = 180.0f + f * 40.0f;
        entity.field_70125_A = -f1 * 20.0f;
        entity.field_70759_as = entity.field_70177_z;
        entity.field_70758_at = entity.field_70177_z;
        EntityRendererManager entityrenderermanager = Minecraft.func_71410_x().func_175598_ae();
        quaternion1.func_195892_e();
        entityrenderermanager.func_229089_a_(quaternion1);
        entityrenderermanager.func_178633_a(false);
        IRenderTypeBuffer.Impl buff = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        entityrenderermanager.func_229084_a_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixstack, (IRenderTypeBuffer)buff, 0xF000F0);
        buff.func_228461_a_();
        entityrenderermanager.func_178633_a(true);
        entity.field_70761_aq = f2;
        entity.field_70177_z = f3;
        entity.field_70125_A = f4;
        entity.field_70758_at = f5;
        entity.field_70759_as = f6;
        RenderSystem.popMatrix();
    }

    public ResourceLocation getUid() {
        return JEINaturesAuraPlugin.SPAWNER;
    }

    public Class<? extends AnimalSpawnerRecipe> getRecipeClass() {
        return AnimalSpawnerRecipe.class;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)("container." + JEINaturesAuraPlugin.SPAWNER + ".name"), (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setIngredients(AnimalSpawnerRecipe animalSpawnerRecipe, IIngredients iIngredients) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Ingredient ing : animalSpawnerRecipe.ingredients) {
            builder.add((Object[])ing.func_193365_a());
        }
        iIngredients.setInputs(VanillaTypes.ITEM, (List)builder.build());
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)new ItemStack((IItemProvider)SpawnEggItem.func_200889_b(animalSpawnerRecipe.entity)));
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, AnimalSpawnerRecipe recipe, IIngredients iIngredients) {
        IGuiItemStackGroup group = iRecipeLayout.getItemStacks();
        for (int i = 0; i < recipe.ingredients.length; ++i) {
            group.init(i, true, i * 18, 68);
            group.set(i, Arrays.asList(recipe.ingredients[i].func_193365_a()));
        }
    }

    public void draw(AnimalSpawnerRecipe recipe, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        Entity entity = this.entityCache.get(recipe.entity);
        if (entity == null) {
            entity = recipe.makeEntity((World)minecraft.field_71441_e, BlockPos.field_177992_a);
            this.entityCache.put(recipe.entity, entity);
        }
        float size = Math.max(1.0f, Math.max(recipe.entity.func_220333_h(), recipe.entity.func_220344_i()));
        AnimalSpawnerCategory.renderEntity(35, 55, 100.0f / size * 0.4f, 40.0f, size * 0.5f, (LivingEntity)entity);
        String name = recipe.entity.func_212546_e().func_150254_d();
        minecraft.field_71466_p.func_175063_a(name, 36.0f - (float)minecraft.field_71466_p.func_78256_a(name) / 2.0f, 55.0f, 0xFFFFFF);
    }
}

