/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.blocks.multi.Multiblocks;
import de.ellpeck.naturesaura.blocks.tiles.ModTileEntities;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import de.ellpeck.naturesaura.recipes.AnimalSpawnerRecipe;
import de.ellpeck.naturesaura.recipes.ModRecipes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;

public class TileEntityAnimalSpawner
extends TileEntityImpl
implements ITickableTileEntity {
    private AnimalSpawnerRecipe currentRecipe;
    private double spawnX;
    private double spawnZ;
    private int time;
    private Entity entityClient;

    public TileEntityAnimalSpawner() {
        super(ModTileEntities.ANIMAL_SPAWNER);
    }

    public void func_73660_a() {
        block11: {
            block12: {
                block13: {
                    if (this.field_145850_b.field_72995_K) break block12;
                    if (this.field_145850_b.func_82737_E() % 10L != 0L) {
                        return;
                    }
                    if (!Multiblocks.ANIMAL_SPAWNER.isComplete(this.field_145850_b, this.field_174879_c)) {
                        if (this.currentRecipe != null) {
                            this.currentRecipe = null;
                            this.time = 0;
                            this.sendToClients();
                        }
                        return;
                    }
                    if (this.currentRecipe == null) break block13;
                    int drain = MathHelper.func_76123_f((float)((float)this.currentRecipe.aura / (float)this.currentRecipe.time * 10.0f));
                    BlockPos spot = IAuraChunk.getHighestSpot((IWorld)this.field_145850_b, this.field_174879_c, 35, this.field_174879_c);
                    IAuraChunk.getAuraChunk((IWorld)this.field_145850_b, spot).drainAura(spot, drain);
                    this.time += 10;
                    if (this.time < this.currentRecipe.time) break block11;
                    Entity entity = this.currentRecipe.makeEntity(this.field_145850_b, new BlockPos(this.spawnX, (double)(this.field_174879_c.func_177956_o() + 1), this.spawnZ));
                    this.field_145850_b.func_217376_c(entity);
                    this.currentRecipe = null;
                    this.time = 0;
                    this.sendToClients();
                    break block11;
                }
                List items = this.field_145850_b.func_217357_a(ItemEntity.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(2.0));
                for (AnimalSpawnerRecipe recipe : this.field_145850_b.func_199532_z().func_215370_b(ModRecipes.ANIMAL_SPAWNER_TYPE, null, null)) {
                    ItemStack stack;
                    ItemEntity item2;
                    if (recipe.ingredients.length != items.size()) continue;
                    ArrayList<Ingredient> required = new ArrayList<Ingredient>(Arrays.asList(recipe.ingredients));
                    Iterator iterator = items.iterator();
                    block1: while (iterator.hasNext() && (item2 = (ItemEntity)iterator.next()).func_70089_S() && !item2.func_174874_s() && !(stack = item2.func_92059_d()).func_190926_b()) {
                        for (Ingredient ingredient : required) {
                            if (!ingredient.test(stack) || Helper.getIngredientAmount(ingredient) != stack.func_190916_E()) continue;
                            required.remove(ingredient);
                            continue block1;
                        }
                    }
                    if (!required.isEmpty()) continue;
                    for (ItemEntity item2 : items) {
                        item2.func_70106_y();
                        PacketHandler.sendToAllAround((IWorld)this.field_145850_b, this.field_174879_c, 32, new PacketParticles((float)item2.func_226277_ct_(), (float)item2.func_226278_cu_(), (float)item2.func_226281_cx_(), PacketParticles.Type.ANIMAL_SPAWNER, new int[0]));
                    }
                    this.currentRecipe = recipe;
                    this.spawnX = (double)this.field_174879_c.func_177958_n() + 0.5 + (double)(this.field_145850_b.field_73012_v.nextFloat() * 4.0f) - 2.0;
                    this.spawnZ = (double)this.field_174879_c.func_177952_p() + 0.5 + (double)(this.field_145850_b.field_73012_v.nextFloat() * 4.0f) - 2.0;
                    this.sendToClients();
                    break block11;
                }
                break block11;
            }
            if (this.field_145850_b.func_82737_E() % 5L != 0L) {
                return;
            }
            if (this.currentRecipe == null) {
                this.entityClient = null;
                return;
            }
            NaturesAuraAPI.instance().spawnParticleStream((float)this.field_174879_c.func_177958_n() + (float)this.field_145850_b.field_73012_v.nextGaussian() * 5.0f, (float)(this.field_174879_c.func_177956_o() + 1) + this.field_145850_b.field_73012_v.nextFloat() * 5.0f, (float)this.field_174879_c.func_177952_p() + (float)this.field_145850_b.field_73012_v.nextGaussian() * 5.0f, (float)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat(), (float)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat(), (float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat(), this.field_145850_b.field_73012_v.nextFloat() * 0.07f + 0.07f, IAuraType.forWorld((IWorld)this.field_145850_b).getColor(), this.field_145850_b.field_73012_v.nextFloat() + 0.5f);
            if (this.entityClient == null) {
                this.entityClient = this.currentRecipe.makeEntity(this.field_145850_b, BlockPos.field_177992_a);
                this.entityClient.func_70107_b(this.spawnX, (double)(this.field_174879_c.func_177956_o() + 1), this.spawnZ);
            }
            AxisAlignedBB bounds = this.entityClient.func_174813_aQ();
            for (int i = this.field_145850_b.field_73012_v.nextInt(5) + 5; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(bounds.field_72340_a + (double)this.field_145850_b.field_73012_v.nextFloat() * (bounds.field_72336_d - bounds.field_72340_a), bounds.field_72338_b + (double)this.field_145850_b.field_73012_v.nextFloat() * (bounds.field_72337_e - bounds.field_72338_b), bounds.field_72339_c + (double)this.field_145850_b.field_73012_v.nextFloat() * (bounds.field_72334_f - bounds.field_72339_c), 0.0, 0.0, 0.0, 3135699, 2.0f, 60, 0.0f, false, true);
            }
        }
    }

    @Override
    public void writeNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type != TileEntityImpl.SaveType.BLOCK && this.currentRecipe != null) {
            compound.func_74778_a("recipe", this.currentRecipe.name.toString());
            compound.func_74780_a("spawn_x", this.spawnX);
            compound.func_74780_a("spawn_z", this.spawnZ);
            compound.func_74768_a("time", this.time);
        }
    }

    @Override
    public void readNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type != TileEntityImpl.SaveType.BLOCK) {
            if (compound.func_74764_b("recipe")) {
                if (this.func_145830_o()) {
                    ResourceLocation name = new ResourceLocation(compound.func_74779_i("recipe"));
                    this.currentRecipe = this.field_145850_b.func_199532_z().func_215367_a(name).orElse(null);
                }
                this.spawnX = compound.func_74769_h("spawn_x");
                this.spawnZ = compound.func_74769_h("spawn_z");
                this.time = compound.func_74762_e("time");
            } else {
                this.currentRecipe = null;
                this.time = 0;
            }
        }
    }
}

