/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityAnimalGenerator;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.INPC;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockAnimalGenerator
extends BlockContainerImpl
implements IVisualizable,
ICustomBlockState {
    public BlockAnimalGenerator() {
        super("animal_generator", TileEntityAnimalGenerator::new, ModBlocks.prop(Material.field_151576_e).func_200943_b(3.0f).func_200947_a(SoundType.field_185851_d));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity.field_70170_p.field_72995_K || entity.field_70170_p.func_82737_E() % 40L != 0L || !(entity instanceof AnimalEntity) || entity instanceof IMob || entity instanceof INPC) {
            return;
        }
        CompoundNBT data = entity.getPersistentData();
        int timeAlive = data.func_74762_e("naturesaura:time_alive");
        data.func_74768_a("naturesaura:time_alive", timeAlive + 40);
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity.field_70170_p.field_72995_K || !(entity instanceof AnimalEntity) || entity instanceof IMob || entity instanceof INPC) {
            return;
        }
        BlockPos pos = entity.func_180425_c();
        Helper.getTileEntitiesInArea((IWorld)entity.field_70170_p, pos, 5, tile -> {
            if (!(tile instanceof TileEntityAnimalGenerator)) {
                return false;
            }
            TileEntityAnimalGenerator gen = (TileEntityAnimalGenerator)((Object)tile);
            CompoundNBT data = entity.getPersistentData();
            data.func_74757_a("naturesaura:no_drops", true);
            if (gen.isBusy()) {
                return false;
            }
            boolean child = entity.func_70631_g_();
            float timeMod = child ? 0.5f : 1.0f;
            float amountMod = child ? 0.667f : 1.0f;
            int timeAlive = data.func_74762_e("naturesaura:time_alive");
            int time = Math.min(MathHelper.func_76141_d((float)((float)(timeAlive - 15000) / 500.0f * timeMod)), 200);
            int amount = Math.min(MathHelper.func_76141_d((float)((float)(timeAlive - 8000) / 2.0f * amountMod)), 25000);
            if (time <= 0 || amount <= 0) {
                return false;
            }
            gen.setGenerationValues(time, amount);
            BlockPos genPos = gen.func_174877_v();
            PacketHandler.sendToAllAround((IWorld)entity.field_70170_p, pos, 32, new PacketParticles((float)entity.func_226277_ct_(), (float)entity.func_226278_cu_(), (float)entity.func_226281_cx_(), PacketParticles.Type.ANIMAL_GEN_CONSUME, child ? 1 : 0, (int)(entity.func_70047_e() * 10.0f), genPos.func_177958_n(), genPos.func_177956_o(), genPos.func_177952_p()));
            return true;
        });
    }

    @SubscribeEvent
    public void onEntityDrops(LivingDropsEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity.getPersistentData().func_74767_n("naturesaura:no_drops")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityExp(LivingExperienceDropEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity.getPersistentData().func_74767_n("naturesaura:no_drops")) {
            event.setCanceled(true);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getVisualizationBounds(World world, BlockPos pos) {
        return new AxisAlignedBB(pos).func_186662_g(5.0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getVisualizationColor(World world, BlockPos pos) {
        return 1128314;
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.simpleBlock((Block)this, (ModelFile)generator.models().cubeBottomTop(this.getBaseName(), generator.modLoc("block/" + this.getBaseName()), generator.modLoc("block/" + this.getBaseName() + "_bottom"), generator.modLoc("block/" + this.getBaseName() + "_top")));
    }
}

