/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.mixin.entity;

import com.google.common.collect.ImmutableSet;
import com.performant.coremod.commands.ReportData;
import com.performant.coremod.config.ConfigurationCache;
import com.performant.coremod.entity.threading.BlockCollideAction;
import com.performant.coremod.entity.threading.BlockFallAction;
import com.performant.coremod.entity.threading.BlockWalkAction;
import com.performant.coremod.entity.threading.IEntityAction;
import com.performant.coremod.entity.threading.IThreadedMoveEntity;
import com.performant.coremod.entity.threading.MoveData;
import com.performant.coremod.entity.threading.MoveThread;
import com.performant.coremod.event.EventHandlerB;
import com.performant.coremod.world.ChunkCache;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.AxisRotation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.CubeCoordinateIterator;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventListener;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class}, priority=998)
public abstract class LivingEntityMixin
extends Entity
implements IThreadedMoveEntity {
    private int tickCounter;
    LivingEntity self;
    boolean hasMovedForCalc;
    ChunkCache chunkCache;
    private int chunkOldX;
    private int chunkOldZ;
    private int chunkCounter;
    long preTick;
    double lastTickX;
    double lastTickY;
    double lastTickZ;
    private int[][] livingUpdatePauses;
    private IEventListener[] livingUpdatelisteners;
    @Shadow
    @Final
    private static AttributeModifier SLOW_FALLING;
    @Shadow
    protected boolean field_70703_bu;
    @Shadow
    protected double field_208001_bq;
    private static final double MOTION_MULT_LENGHT = 1.0E-7;
    private Vec3d lastMovementVec;
    private Vec3d lastPosVec;
    private LinkedBlockingQueue<IEntityAction> mainThreadQue;
    boolean lastHandleWaterMovement;
    boolean isInWaterRainOrBubbleColumn;
    boolean lastIsEntityInsideOpaqueBlock;
    boolean isFlammableWithin;
    double lastX;
    double lastY;
    double lastZ;
    boolean changeDim;
    double lastVecX;
    double lastVecY;
    double lastVecZ;
    Vec3d lastVector;
    Vec3d lastHeuristicResult;
    int lastminX;
    int lastmaxX;
    int lastminY;
    int lastmaxY;
    int lastminZ;
    int lastmaxZ;
    int lastEntitySize;
    Vec3d preVec;
    List<VoxelShape> entityCollisionBoxes;
    boolean isOffsetPosInLiquidres;
    float lastSpeedFactor;
    volatile boolean lastIsOnLadder;
    boolean forgeLadderCheck;
    boolean areEyesInFluid;

    public LivingEntityMixin(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.tickCounter = this.field_70146_Z.nextInt(100);
        this.self = (LivingEntity)this;
        this.hasMovedForCalc = false;
        this.chunkCache = null;
        this.chunkOldX = 0;
        this.chunkOldZ = 0;
        this.chunkCounter = this.self.field_70170_p.field_73012_v.nextInt(1000);
        this.lastTickX = 0.0;
        this.lastTickY = 0.0;
        this.lastTickZ = 0.0;
        this.livingUpdatePauses = new int[3][5];
        this.lastMovementVec = Vec3d.field_186680_a;
        this.lastPosVec = Vec3d.field_186680_a;
        this.mainThreadQue = new LinkedBlockingQueue(20);
        this.lastHandleWaterMovement = false;
        this.isInWaterRainOrBubbleColumn = false;
        this.lastIsEntityInsideOpaqueBlock = false;
        this.isFlammableWithin = false;
        this.lastX = 0.0;
        this.lastY = 0.0;
        this.lastZ = 0.0;
        this.changeDim = false;
        this.lastVecX = 0.0;
        this.lastVecY = 0.0;
        this.lastVecZ = 0.0;
        this.lastVector = null;
        this.lastHeuristicResult = Vec3d.field_186680_a;
        this.lastminX = 0;
        this.lastmaxX = 0;
        this.lastminY = 0;
        this.lastmaxY = 0;
        this.lastminZ = 0;
        this.lastmaxZ = 0;
        this.lastEntitySize = 0;
        this.preVec = Vec3d.field_186680_a;
        this.entityCollisionBoxes = new ArrayList<VoxelShape>();
        this.isOffsetPosInLiquidres = false;
        this.lastSpeedFactor = 1.0f;
        this.lastIsOnLadder = false;
        this.forgeLadderCheck = (Boolean)ForgeConfig.SERVER.fullBoundingBoxLadders.get();
        this.areEyesInFluid = false;
    }

    @Override
    public ChunkCache getCache() {
        if (this.chunkCache == null) {
            this.chunkCounter = 0;
            this.chunkCache = new ChunkCache(this.field_70170_p, this.self.func_180425_c().func_177982_a(-64, 0, -64), this.self.func_180425_c().func_177982_a(64, 0, 64));
            this.chunkCache.setEntity(this);
        }
        return this.chunkCache;
    }

    private void recheckCache() {
        if (this.chunkCache == null || this.chunkCounter >= 5000 || this.chunkOldX != this.self.field_70176_ah || this.chunkOldZ != this.self.field_70164_aj || !this.chunkCache.isValid()) {
            this.chunkCache = new ChunkCache(this.field_70170_p, this.self.func_180425_c().func_177982_a(-64, 0, -64), this.self.func_180425_c().func_177982_a(64, 0, 64));
            this.chunkCache.setEntity(this);
            this.chunkCounter = 0;
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo callbackInfo) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70142_S = this.lastTickX;
            this.field_70137_T = this.lastTickY;
            this.field_70136_U = this.lastTickZ;
            this.lastTickX = this.func_226277_ct_();
            this.lastTickY = this.func_226278_cu_();
            this.lastTickZ = this.func_226281_cx_();
        }
        if (ConfigurationCache.generateReport) {
            this.preTick = System.nanoTime();
        }
        if (this.tickCounter++ == 100) {
            this.tickCounter = 0;
        }
        ++this.chunkCounter;
        this.recheckCache();
        this.chunkOldX = this.self.field_70176_ah;
        this.chunkOldZ = this.self.field_70164_aj;
        this.hasMovedForCalc = this.lastX != this.field_70165_t || this.lastY != this.field_70163_u || this.lastZ != this.field_70161_v;
        this.lastX = this.field_70165_t;
        this.lastY = this.field_70163_u;
        this.lastZ = this.field_70161_v;
        while (!this.mainThreadQue.isEmpty()) {
            IEntityAction next = this.mainThreadQue.poll();
            next.execute(this.self);
        }
        if (this.isAddedToWorld() && !this.field_70170_p.field_72995_K && this.field_70170_p instanceof ServerWorld) {
            this.chunkCheck(this);
        }
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    public void tickEnd(CallbackInfo callbackInfo) {
        if (ConfigurationCache.generateReport && this.preTick > 30000L) {
            this.preTick = System.nanoTime() - this.preTick;
            ReportData data = new ReportData();
            data.totalTickTime = (int)this.preTick;
            data.entity = this.self;
            ReportData.addEntityReport((Entity)this.self, data);
        }
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="net/minecraftforge/common/ForgeHooks.onLivingUpdate(Lnet/minecraft/entity/LivingEntity;)Z"))
    public boolean onLivingUpdateRedirect(LivingEntity entity) {
        LivingEvent.LivingUpdateEvent event = new LivingEvent.LivingUpdateEvent(entity);
        this.livingUpdatelisteners = event.getListenerList().getListeners(0);
        if (this.livingUpdatePauses[0].length < this.livingUpdatelisteners.length) {
            this.livingUpdatePauses = new int[3][this.livingUpdatelisteners.length];
        }
        return EventHandlerB.post((Event)event, this.livingUpdatelisteners, this.livingUpdatePauses, true, EventHandlerB.livingEventMult, 2500);
    }

    @Redirect(method={"livingTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;travel(Lnet/minecraft/util/math/Vec3d;)V"))
    public void OnTravelRequest(LivingEntity entity, Vec3d travelVec) {
        if (ConfigurationCache.multiEntities && !(this.self instanceof PlayerEntity) && this instanceof IThreadedMoveEntity && !this.field_70170_p.field_72995_K) {
            MoveThread.enqueMove(new MoveData(this, travelVec));
        } else {
            this.self.func_213352_e(travelVec);
        }
    }

    @Override
    public void callTravel(MoveData data) {
        this.self.func_213352_e(data.movePos);
    }

    @Overwrite
    public void func_213352_e(Vec3d p_213352_1_) {
        double d6;
        double d8;
        this.updateLadderState();
        if (this.func_70613_aW() || this.func_184186_bw()) {
            boolean flag;
            double d0 = 0.08;
            IAttributeInstance gravity = this.self.func_110148_a(LivingEntity.ENTITY_GRAVITY);
            boolean bl = flag = this.func_213322_ci().field_72448_b <= 0.0;
            if (flag && this.self.func_70644_a(Effects.field_204839_B)) {
                if (!gravity.func_180374_a(SLOW_FALLING)) {
                    gravity.func_111121_a(SLOW_FALLING);
                }
                this.field_70143_R = 0.0f;
            } else if (gravity.func_180374_a(SLOW_FALLING)) {
                gravity.func_111124_b(SLOW_FALLING);
            }
            d0 = gravity.func_111126_e();
            if (!this.func_70090_H() || this.self instanceof PlayerEntity && ((PlayerEntity)this.self).field_71075_bZ.field_75100_b) {
                if (!this.func_180799_ab() || this.self instanceof PlayerEntity && ((PlayerEntity)this.self).field_71075_bZ.field_75100_b) {
                    if (this.self.func_184613_cA()) {
                        double d14;
                        double d4;
                        float f4;
                        Vec3d vec3d3 = this.func_213322_ci();
                        if (vec3d3.field_72448_b > -0.5) {
                            this.field_70143_R = 1.0f;
                        }
                        Vec3d vec3d = this.func_70040_Z();
                        float f6 = this.field_70125_A * ((float)Math.PI / 180);
                        double d9 = Math.sqrt(vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c);
                        double d11 = Math.sqrt(LivingEntityMixin.func_213296_b((Vec3d)vec3d3));
                        double d12 = vec3d.func_72433_c();
                        float f3 = MathHelper.func_76134_b((float)f6);
                        f3 = (float)((double)f3 * (double)f3 * Math.min(1.0, d12 / 0.4));
                        vec3d3 = this.func_213322_ci().func_72441_c(0.0, d0 * (-1.0 + (double)f3 * 0.75), 0.0);
                        if (vec3d3.field_72448_b < 0.0 && d9 > 0.0) {
                            double d3 = vec3d3.field_72448_b * -0.1 * (double)f3;
                            vec3d3 = vec3d3.func_72441_c(vec3d.field_72450_a * d3 / d9, d3, vec3d.field_72449_c * d3 / d9);
                        }
                        if (f6 < 0.0f && d9 > 0.0) {
                            double d13 = d11 * (double)(-MathHelper.func_76126_a((float)f6)) * 0.04;
                            vec3d3 = vec3d3.func_72441_c(-vec3d.field_72450_a * d13 / d9, d13 * 3.2, -vec3d.field_72449_c * d13 / d9);
                        }
                        if (d9 > 0.0) {
                            vec3d3 = vec3d3.func_72441_c((vec3d.field_72450_a / d9 * d11 - vec3d3.field_72450_a) * 0.1, 0.0, (vec3d.field_72449_c / d9 * d11 - vec3d3.field_72449_c) * 0.1);
                        }
                        this.func_213317_d(vec3d3.func_216372_d((double)0.99f, (double)0.98f, (double)0.99f));
                        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                        if (this.field_70123_F && !this.field_70170_p.field_72995_K && (f4 = (float)((d4 = d11 - (d14 = Math.sqrt(LivingEntityMixin.func_213296_b((Vec3d)this.func_213322_ci())))) * 10.0 - 3.0)) > 0.0f) {
                            this.func_184185_a(this.func_184588_d((int)f4), 1.0f, 1.0f);
                            this.func_70097_a(DamageSource.field_188406_j, f4);
                        }
                        if (this.field_70122_E && !this.field_70170_p.field_72995_K) {
                            this.func_70052_a(7, false);
                        }
                    } else {
                        BlockPos blockpos = this.func_226270_aj_();
                        float f5 = this.getCache().func_180495_p(blockpos).getSlipperiness((IWorldReader)this.field_70170_p, blockpos, (Entity)this);
                        float f7 = this.field_70122_E ? f5 * 0.91f : 0.91f;
                        this.func_213309_a(this.func_213335_r(f5), p_213352_1_);
                        this.func_213317_d(this.func_213362_f(this.func_213322_ci()));
                        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                        Vec3d vec3d5 = this.func_213322_ci();
                        if ((this.field_70123_F || this.field_70703_bu) && this.self.func_70617_f_()) {
                            vec3d5 = new Vec3d(vec3d5.field_72450_a, 0.2, vec3d5.field_72449_c);
                        }
                        double d10 = vec3d5.field_72448_b;
                        if (this.self.func_70644_a(Effects.field_188424_y)) {
                            d10 += (0.05 * (double)(this.self.func_70660_b(Effects.field_188424_y).func_76458_c() + 1) - vec3d5.field_72448_b) * 0.2;
                            this.field_70143_R = 0.0f;
                        } else if (this.field_70170_p.field_72995_K && !this.field_70170_p.func_175667_e(blockpos)) {
                            d10 = this.func_226278_cu_() > 0.0 ? -0.1 : 0.0;
                        } else if (!this.func_189652_ae()) {
                            d10 -= d0;
                        }
                        this.func_213293_j(vec3d5.field_72450_a * (double)f7, d10 * (double)0.98f, vec3d5.field_72449_c * (double)f7);
                    }
                } else {
                    double d7 = this.func_226278_cu_();
                    this.func_213309_a(0.02f, p_213352_1_);
                    this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                    this.func_213317_d(this.func_213322_ci().func_186678_a(0.5));
                    if (!this.func_189652_ae()) {
                        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -d0 / 4.0, 0.0));
                    }
                    Vec3d vec3d4 = this.func_213322_ci();
                    if (this.field_70123_F && this.func_70038_c(vec3d4.field_72450_a, vec3d4.field_72448_b + (double)0.6f - this.func_226278_cu_() + d7, vec3d4.field_72449_c)) {
                        this.func_213293_j(vec3d4.field_72450_a, 0.3f, vec3d4.field_72449_c);
                    }
                }
            } else {
                double d1 = this.func_226278_cu_();
                float f = this.func_70051_ag() ? 0.9f : this.func_189749_co();
                float f1 = 0.02f;
                float f2 = EnchantmentHelper.func_185294_d((LivingEntity)this.self);
                if (f2 > 3.0f) {
                    f2 = 3.0f;
                }
                if (!this.field_70122_E) {
                    f2 *= 0.5f;
                }
                if (f2 > 0.0f) {
                    f += (0.54600006f - f) * f2 / 3.0f;
                    f1 += (this.self.func_70689_ay() - f1) * f2 / 3.0f;
                }
                if (this.self.func_70644_a(Effects.field_206827_D)) {
                    f = 0.96f;
                }
                this.func_213309_a(f1 *= (float)this.self.func_110148_a(LivingEntity.SWIM_SPEED).func_111126_e(), p_213352_1_);
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                Vec3d vec3d1 = this.func_213322_ci();
                if (this.field_70123_F && this.self.func_70617_f_()) {
                    vec3d1 = new Vec3d(vec3d1.field_72450_a, 0.2, vec3d1.field_72449_c);
                }
                this.func_213317_d(vec3d1.func_216372_d((double)f, (double)0.8f, (double)f));
                if (!this.func_189652_ae() && !this.func_70051_ag()) {
                    Vec3d vec3d2 = this.func_213322_ci();
                    double d2 = flag && Math.abs(vec3d2.field_72448_b - 0.005) >= 0.003 && Math.abs(vec3d2.field_72448_b - d0 / 16.0) < 0.003 ? -0.003 : vec3d2.field_72448_b - d0 / 16.0;
                    this.func_213293_j(vec3d2.field_72450_a, d2, vec3d2.field_72449_c);
                }
                Vec3d vec3d6 = this.func_213322_ci();
                if (this.field_70123_F && this.func_70038_c(vec3d6.field_72450_a, vec3d6.field_72448_b + (double)0.6f - this.func_226278_cu_() + d1, vec3d6.field_72449_c)) {
                    this.func_213293_j(vec3d6.field_72450_a, 0.3f, vec3d6.field_72449_c);
                }
            }
        }
        this.self.field_184618_aE = this.self.field_70721_aZ;
        double d5 = this.func_226277_ct_() - this.field_70169_q;
        float f8 = MathHelper.func_76133_a((double)(d5 * d5 + (d8 = this instanceof IFlyingAnimal ? this.func_226278_cu_() - this.field_70167_r : 0.0) * d8 + (d6 = this.func_226281_cx_() - this.field_70166_s) * d6)) * 4.0f;
        if (f8 > 1.0f) {
            f8 = 1.0f;
        }
        this.self.field_70721_aZ += (f8 - this.self.field_70721_aZ) * 0.4f;
        this.self.field_184619_aG += this.self.field_70721_aZ;
    }

    @Shadow
    protected abstract SoundEvent func_184588_d(int var1);

    @Shadow
    protected abstract float func_189749_co();

    @Shadow
    public abstract boolean func_70613_aW();

    @Shadow
    abstract Vec3d func_213362_f(Vec3d var1);

    @Shadow
    abstract float func_213335_r(float var1);

    @Shadow
    public abstract boolean func_226296_dJ_();

    public synchronized void func_213317_d(Vec3d motionIn) {
        super.func_213317_d(motionIn);
    }

    public void func_213315_a(MoverType typeIn, Vec3d pos) {
        Vec3d vec3d;
        if (this.field_70145_X) {
            this.func_174826_a(this.func_174813_aQ().func_191194_a(pos));
            this.func_174829_m();
            return;
        }
        if (typeIn == MoverType.PISTON && (pos = this.func_213308_a(pos)).equals((Object)Vec3d.field_186680_a)) {
            return;
        }
        if (this.field_213328_B.func_189985_c() > 1.0E-7) {
            pos = pos.func_216369_h(this.field_213328_B);
            this.field_213328_B = Vec3d.field_186680_a;
            this.func_213317_d(Vec3d.field_186680_a);
        }
        if ((vec3d = this.getAllowedMovement(pos = this.func_225514_a_(pos, typeIn))).func_189985_c() > 1.0E-7) {
            this.func_174826_a(this.func_174813_aQ().func_191194_a(vec3d));
            this.func_174829_m();
        }
        this.field_70123_F = !MathHelper.func_219806_b((double)pos.field_72450_a, (double)vec3d.field_72450_a) || !MathHelper.func_219806_b((double)pos.field_72449_c, (double)vec3d.field_72449_c);
        this.field_70124_G = pos.field_72448_b != vec3d.field_72448_b;
        this.field_70122_E = this.field_70124_G && pos.field_72448_b < 0.0;
        this.field_70132_H = this.field_70123_F || this.field_70124_G;
        this.updateFallState(vec3d, pos);
        Vec3d vec3d1 = this.func_213322_ci();
        if (pos.field_72450_a != vec3d.field_72450_a) {
            this.func_213293_j(0.0, vec3d1.field_72448_b, vec3d1.field_72449_c);
        }
        if (pos.field_72449_c != vec3d.field_72449_c) {
            this.func_213293_j(vec3d1.field_72450_a, vec3d1.field_72448_b, 0.0);
        }
        this.checkFireArea();
        this.checkBlockCollisions();
        this.func_213317_d(this.func_213322_ci().func_216372_d((double)this.func_225515_ai_(), 1.0, (double)this.func_225515_ai_()));
    }

    public void func_226288_n_(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        if (this.isAddedToWorld() && !this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.getCache().func_212866_a_((int)Math.floor(this.field_70165_t) >> 4, (int)Math.floor(this.field_70161_v) >> 4);
        }
    }

    @Override
    public void callupdateFallState(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        this.func_184231_a(y, onGroundIn, state, pos);
    }

    private void updateFallState(Vec3d movementVec, Vec3d pos) {
        if (!this.hasMovedForCalc && this.tickCounter % 20 != 0 && this.field_70122_E && pos.equals((Object)this.lastPosVec) && movementVec.equals((Object)this.lastMovementVec)) {
            return;
        }
        this.lastPosVec = pos;
        this.lastMovementVec = movementVec;
        BlockPos blockpos = this.func_226268_ag_();
        BlockState blockstate = this.getCache().func_180495_p(blockpos);
        if (this.field_70122_E && this.field_70143_R > 0.0f && ConfigurationCache.multiEntities) {
            this.mainThreadQue.offer(new BlockFallAction(movementVec.field_72448_b, this.field_70122_E, blockstate, blockpos));
        } else {
            this.func_184231_a(movementVec.field_72448_b, this.field_70122_E, blockstate, blockpos);
        }
        Block block = blockstate.func_177230_c();
        if (pos.field_72448_b != movementVec.field_72448_b) {
            block.func_176216_a((IBlockReader)this.getCache(), (Entity)this);
        }
        if (this.field_70122_E && !this.func_226271_bk_()) {
            if (ConfigurationCache.multiEntities) {
                this.mainThreadQue.offer(new BlockWalkAction(block, this.field_70170_p, blockpos));
            } else {
                block.func_176199_a(this.field_70170_p, blockpos, (Entity)this);
            }
        }
        if (this.func_225502_at_() && !this.func_184218_aH()) {
            double d0 = movementVec.field_72450_a;
            double d1 = movementVec.field_72448_b;
            double d2 = movementVec.field_72449_c;
            if (block != Blocks.field_150468_ap && block != Blocks.field_222420_lI) {
                d1 = 0.0;
            }
            this.field_70140_Q = (float)((double)this.field_70140_Q + (double)MathHelper.func_76133_a((double)LivingEntityMixin.func_213296_b((Vec3d)movementVec)) * 0.6);
            this.field_82151_R = (float)((double)this.field_82151_R + (double)MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2)) * 0.6);
            if (this.field_82151_R > this.field_70150_b && !blockstate.isAir((IBlockReader)this.getCache(), blockpos)) {
                this.field_70150_b = this.func_203009_ad();
                if (this.func_70090_H()) {
                    LivingEntityMixin entity = this.func_184207_aI() && this.func_184179_bs() != null ? this.func_184179_bs() : this;
                    float f = entity == this ? 0.35f : 0.4f;
                    Vec3d vec3d2 = entity.func_213322_ci();
                    float f1 = MathHelper.func_76133_a((double)(vec3d2.field_72450_a * vec3d2.field_72450_a * (double)0.2f + vec3d2.field_72448_b * vec3d2.field_72448_b + vec3d2.field_72449_c * vec3d2.field_72449_c * (double)0.2f)) * f;
                    if (f1 > 1.0f) {
                        f1 = 1.0f;
                    }
                    this.func_203006_d(f1);
                } else {
                    this.func_180429_a(blockpos, blockstate);
                }
            } else if (this.field_82151_R > this.field_191959_ay && this.func_191957_ae() && blockstate.isAir((IBlockReader)this.getCache(), blockpos)) {
                this.field_191959_ay = this.func_191954_d(this.field_82151_R);
            }
        }
    }

    @Inject(method={"getBlockState"}, at={@At(value="HEAD")}, cancellable=true)
    public void OngetBlockState(CallbackInfoReturnable<BlockState> c) {
        if (this instanceof IThreadedMoveEntity) {
            c.setReturnValue((Object)this.getCache().func_180495_p(new BlockPos((Entity)this.self)));
        }
    }

    protected BlockPos func_226268_ag_() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f));
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        BlockPos blockpos = new BlockPos(i, j, k);
        if (this.getCache().func_175623_d(blockpos)) {
            BlockPos blockpos1 = blockpos.func_177977_b();
            BlockState blockstate = this.getCache().func_180495_p(blockpos1);
            if (blockstate.collisionExtendsVertically((IBlockReader)this.getCache(), blockpos1, (Entity)this)) {
                return blockpos1;
            }
        }
        return blockpos;
    }

    public boolean func_70072_I() {
        if (!this.hasMovedForCalc && this.tickCounter % 20 != 0) {
            return this.lastHandleWaterMovement;
        }
        if (this.func_184187_bx() instanceof BoatEntity) {
            this.field_70171_ac = false;
        } else if (this.func_210500_b((Tag<Fluid>)FluidTags.field_206959_a)) {
            if (!this.field_70171_ac && !this.field_70148_d) {
                this.func_71061_d_();
            }
            this.field_70143_R = 0.0f;
            this.field_70171_ac = true;
            this.func_70066_B();
        } else {
            this.field_70171_ac = false;
        }
        this.lastHandleWaterMovement = this.field_70171_ac;
        return this.lastHandleWaterMovement;
    }

    public boolean func_210500_b(Tag<Fluid> p_210500_1_) {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_186664_h(0.001);
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76143_f((double)axisalignedbb.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        double d0 = 0.0;
        boolean flag = this.func_96092_aw();
        boolean flag1 = false;
        Vec3d vec3d = Vec3d.field_186680_a;
        int k1 = 0;
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = k; i2 < l; ++i2) {
                for (int j2 = i1; j2 < j1; ++j2) {
                    double d1;
                    BlockPos posToCheck = new BlockPos(l1, i2, j2);
                    IFluidState ifluidstate = this.getCache().func_204610_c(posToCheck);
                    if (!ifluidstate.func_206884_a(p_210500_1_) || !((d1 = (double)((float)i2 + ifluidstate.func_215679_a((IBlockReader)this.getCache(), posToCheck))) >= axisalignedbb.field_72338_b)) continue;
                    flag1 = true;
                    d0 = Math.max(d1 - axisalignedbb.field_72338_b, d0);
                    if (!flag) continue;
                    Vec3d vec3d1 = ifluidstate.func_215673_c((IBlockReader)this.getCache(), posToCheck);
                    if (d0 < 0.4) {
                        vec3d1 = vec3d1.func_186678_a(d0);
                    }
                    vec3d = vec3d.func_178787_e(vec3d1);
                    ++k1;
                }
            }
        }
        if (vec3d.func_72433_c() > 0.0) {
            if (k1 > 0) {
                vec3d = vec3d.func_186678_a(1.0 / (double)k1);
            }
            if (!(this.self instanceof PlayerEntity)) {
                vec3d = vec3d.func_72432_b();
            }
            this.func_213317_d(this.func_213322_ci().func_178787_e(vec3d.func_186678_a(0.014)));
        }
        this.field_211517_W = d0;
        return flag1;
    }

    public boolean func_203008_ap() {
        if (!this.hasMovedForCalc && this.tickCounter % 5 != 0) {
            return this.isInWaterRainOrBubbleColumn;
        }
        this.isInWaterRainOrBubbleColumn = super.func_203008_ap();
        return this.isInWaterRainOrBubbleColumn;
    }

    public boolean func_70094_T() {
        if (this.tickCounter % 5 != 0) {
            return this.lastIsEntityInsideOpaqueBlock;
        }
        if (this.field_70145_X) {
            this.lastIsEntityInsideOpaqueBlock = false;
            return false;
        }
        BlockPos checkPos = new BlockPos((Entity)this.self);
        for (int i = 0; i < 8; ++i) {
            int j = MathHelper.func_76128_c((double)(this.func_226278_cu_() + (double)(((float)((i >> 0) % 2) - 0.5f) * 0.1f) + (double)this.self.func_70047_e()));
            int k = MathHelper.func_76128_c((double)(this.func_226277_ct_() + (double)(((float)((i >> 1) % 2) - 0.5f) * this.self.func_213311_cf() * 0.8f)));
            int l = MathHelper.func_76128_c((double)(this.func_226281_cx_() + (double)(((float)((i >> 2) % 2) - 0.5f) * this.self.func_213311_cf() * 0.8f)));
            if (checkPos.func_177958_n() == k && checkPos.func_177956_o() == j && checkPos.func_177952_p() == l) continue;
            checkPos = new BlockPos(k, j, l);
            if (!this.getCache().func_180495_p(checkPos).func_229980_m_((IBlockReader)this.getCache(), checkPos)) continue;
            this.lastIsEntityInsideOpaqueBlock = true;
            return true;
        }
        this.lastIsEntityInsideOpaqueBlock = false;
        return false;
    }

    @Override
    public boolean shouldRun() {
        return this.self.func_70089_S();
    }

    private void checkFireArea() {
        if (this.func_70045_F()) {
            return;
        }
        if (this.tickCounter % 5 == 0) {
            this.isFlammableWithin = this.getCache().isFlammableWithin(this.func_174813_aQ().func_186664_h(0.001));
        }
        if (this.isFlammableWithin) {
            if (!this.func_203008_ap()) {
                ++this.field_190534_ay;
                if (this.field_190534_ay == 0) {
                    this.func_70015_d(8);
                }
            }
            this.func_70081_e(1);
        } else if (this.field_190534_ay <= 0) {
            this.field_190534_ay = -this.func_190531_bD();
        }
        if (this.isInWaterRainOrBubbleColumn && this.func_70027_ad()) {
            this.func_184185_a(SoundEvents.field_187541_bC, 0.7f, 1.6f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
            this.field_190534_ay = -this.func_190531_bD();
        }
    }

    private void checkBlockCollisions() {
        this.field_213329_S = false;
        this.changeDim = false;
        this.func_145775_I();
    }

    public Entity changeDimension(DimensionType destination, ITeleporter teleporter) {
        Entity rVal = super.changeDimension(destination, teleporter);
        this.changeDim = true;
        this.chunkCache = null;
        return rVal;
    }

    protected void func_145775_I() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        try (BlockPos.PooledMutable blockpos$pooledmutable = BlockPos.PooledMutable.func_185345_c((double)(axisalignedbb.field_72340_a + 0.001), (double)(axisalignedbb.field_72338_b + 0.001), (double)(axisalignedbb.field_72339_c + 0.001));
             BlockPos.PooledMutable blockpos$pooledmutable1 = BlockPos.PooledMutable.func_185345_c((double)(axisalignedbb.field_72336_d - 0.001), (double)(axisalignedbb.field_72337_e - 0.001), (double)(axisalignedbb.field_72334_f - 0.001));
             BlockPos.PooledMutable blockpos$pooledmutable2 = BlockPos.PooledMutable.func_185346_s();){
            for (int i = blockpos$pooledmutable.func_177958_n(); i <= blockpos$pooledmutable1.func_177958_n(); ++i) {
                for (int j = blockpos$pooledmutable.func_177956_o(); j <= blockpos$pooledmutable1.func_177956_o(); ++j) {
                    for (int k = blockpos$pooledmutable.func_177952_p(); k <= blockpos$pooledmutable1.func_177952_p(); ++k) {
                        blockpos$pooledmutable2.func_181079_c(i, j, k);
                        BlockState blockstate = this.getCache().func_180495_p((BlockPos)blockpos$pooledmutable2);
                        try {
                            if (blockstate.func_177230_c() == Blocks.field_150350_a) continue;
                            this.mainThreadQue.offer(new BlockCollideAction(new BlockPos((Vec3i)blockpos$pooledmutable2), blockstate));
                            this.func_191955_a(blockstate);
                            continue;
                        }
                        catch (Throwable throwable) {
                            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Colliding entity with block");
                            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being collided with");
                            CrashReportCategory.func_175750_a((CrashReportCategory)crashreportcategory, (BlockPos)blockpos$pooledmutable2, (BlockState)blockstate);
                            throw new ReportedException(crashreport);
                        }
                    }
                }
            }
        }
    }

    private Vec3d getAllowedMovement(Vec3d vec) {
        boolean flag3;
        if (!this.hasMovedForCalc && vec.field_72450_a == this.lastVecX && vec.field_72448_b == this.lastVecY && vec.field_72449_c == this.lastVecZ && this.tickCounter % 10 != 0 && this.lastVector != null) {
            return this.lastVector;
        }
        this.lastVecX = vec.field_72450_a;
        this.lastVecY = vec.field_72448_b;
        this.lastVecZ = vec.field_72449_c;
        AxisAlignedBB boundingBox = this.func_174813_aQ();
        ISelectionContext iselectioncontext = ISelectionContext.func_216374_a((Entity)this);
        ArrayList<VoxelShape> entityVoxelShapes = new ArrayList<VoxelShape>();
        if (vec.field_72450_a != 0.0 || vec.field_72449_c != 0.0) {
            entityVoxelShapes.addAll(this.getEntityCollisionBoxes(this, boundingBox.func_216361_a(vec), (Set<Entity>)ImmutableSet.of()));
        }
        Vec3d vec3d = vec.func_189985_c() == 0.0 ? vec : this.collideBoundingBoxHeuristically(this, vec, boundingBox, this.getCache(), iselectioncontext, entityVoxelShapes);
        boolean flag = vec.field_72450_a != vec3d.field_72450_a;
        boolean flag1 = vec.field_72448_b != vec3d.field_72448_b;
        boolean flag2 = vec.field_72449_c != vec3d.field_72449_c;
        boolean bl = flag3 = this.field_70122_E || flag1 && vec.field_72448_b < 0.0;
        if (this.field_70138_W > 0.0f && flag3 && (flag || flag2)) {
            Vec3d vec3d3;
            Vec3d vec3d1 = this.collideBoundingBoxHeuristically(this, new Vec3d(vec.field_72450_a, (double)this.field_70138_W, vec.field_72449_c), boundingBox, this.getCache(), iselectioncontext, entityVoxelShapes);
            Vec3d vec3d2 = this.collideBoundingBoxHeuristically(this, new Vec3d(0.0, (double)this.field_70138_W, 0.0), boundingBox.func_72321_a(vec.field_72450_a, 0.0, vec.field_72449_c), this.getCache(), iselectioncontext, entityVoxelShapes);
            if (vec3d2.field_72448_b < (double)this.field_70138_W && LivingEntityMixin.func_213296_b((Vec3d)(vec3d3 = this.collideBoundingBoxHeuristically(this, new Vec3d(vec.field_72450_a, 0.0, vec.field_72449_c), boundingBox.func_191194_a(vec3d2), this.getCache(), iselectioncontext, entityVoxelShapes).func_178787_e(vec3d2))) > LivingEntityMixin.func_213296_b((Vec3d)vec3d1)) {
                vec3d1 = vec3d3;
            }
            if (LivingEntityMixin.func_213296_b((Vec3d)vec3d1) > LivingEntityMixin.func_213296_b((Vec3d)vec3d)) {
                this.lastVector = vec3d1.func_178787_e(this.collideBoundingBoxHeuristically(this, new Vec3d(0.0, -vec3d1.field_72448_b + vec.field_72448_b, 0.0), boundingBox.func_191194_a(vec3d1), this.getCache(), iselectioncontext, entityVoxelShapes));
                return this.lastVector;
            }
        }
        this.lastVector = vec3d;
        return this.lastVector;
    }

    public Vec3d collideBoundingBoxHeuristically(@Nullable Entity entity, Vec3d vec3d, AxisAlignedBB axisAlignedBB, ChunkCache world, ISelectionContext iSelectionContext, List<VoxelShape> entityVoxelShapes) {
        boolean hasXMovement = vec3d.field_72450_a != 0.0;
        boolean hasYMovement = vec3d.field_72448_b != 0.0;
        boolean hasZMovement = vec3d.field_72449_c != 0.0;
        this.lastHeuristicResult = !(!hasXMovement && !hasYMovement || !hasXMovement && !hasZMovement || !hasYMovement && !hasZMovement) ? this.collideBoundingBoxSingle(entity, vec3d, axisAlignedBB, entityVoxelShapes) : this.getAllowedMovement(vec3d, axisAlignedBB, world, iSelectionContext, entityVoxelShapes);
        return this.lastHeuristicResult;
    }

    private Vec3d collideBoundingBoxSingle(Entity entity, Vec3d vec3d, AxisAlignedBB axisAlignedBB, List<VoxelShape> entityCollisionBoxes) {
        boolean flag;
        AxisAlignedBB expandedaxisAlignedBB = axisAlignedBB.func_216361_a(vec3d);
        int minX = MathHelper.func_76128_c((double)(expandedaxisAlignedBB.field_72340_a - 1.0E-7)) - 1;
        int maxX = MathHelper.func_76128_c((double)(expandedaxisAlignedBB.field_72336_d + 1.0E-7)) + 1;
        int minY = MathHelper.func_76128_c((double)(expandedaxisAlignedBB.field_72338_b - 1.0E-7)) - 1;
        int maxY = MathHelper.func_76128_c((double)(expandedaxisAlignedBB.field_72337_e + 1.0E-7)) + 1;
        int minZ = MathHelper.func_76128_c((double)(expandedaxisAlignedBB.field_72339_c - 1.0E-7)) - 1;
        int maxZ = MathHelper.func_76128_c((double)(expandedaxisAlignedBB.field_72334_f + 1.0E-7)) + 1;
        ISelectionContext iselectioncontext = entity == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a((Entity)entity);
        CubeCoordinateIterator cubecoordinateiterator = new CubeCoordinateIterator(minX, minY, minZ, maxX, maxY, maxZ);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        VoxelShape entityVoxelShape = VoxelShapes.func_197881_a((AxisAlignedBB)expandedaxisAlignedBB);
        ArrayList<VoxelShape> allCollisionShapes = new ArrayList<VoxelShape>(entityCollisionBoxes);
        LivingEntityMixin.addShapesForBlockCollision(allCollisionShapes, cubecoordinateiterator, blockpos$mutable, this.getCache(), iselectioncontext, entityVoxelShape);
        double xMotion = vec3d.field_72450_a;
        double yMotion = vec3d.field_72448_b;
        double zMotion = vec3d.field_72449_c;
        this.lastminX = minX;
        this.lastmaxX = maxX;
        this.lastminY = minY;
        this.lastmaxY = maxY;
        this.lastminZ = minZ;
        this.lastmaxZ = maxZ;
        this.preVec = vec3d;
        if (yMotion != 0.0 && (yMotion = LivingEntityMixin.getAllowedOffset(Direction.Axis.Y, axisAlignedBB, allCollisionShapes, yMotion)) != 0.0) {
            axisAlignedBB = axisAlignedBB.func_72317_d(0.0, yMotion, 0.0);
        }
        boolean bl = flag = Math.abs(xMotion) < Math.abs(zMotion);
        if (flag && zMotion != 0.0 && (zMotion = LivingEntityMixin.getAllowedOffset(Direction.Axis.Z, axisAlignedBB, allCollisionShapes, zMotion)) != 0.0) {
            axisAlignedBB = axisAlignedBB.func_72317_d(0.0, 0.0, zMotion);
        }
        if (xMotion != 0.0) {
            xMotion = LivingEntityMixin.getAllowedOffset(Direction.Axis.X, axisAlignedBB, allCollisionShapes, xMotion);
            if (!flag && xMotion != 0.0) {
                axisAlignedBB = axisAlignedBB.func_72317_d(xMotion, 0.0, 0.0);
            }
        }
        if (!flag && zMotion != 0.0) {
            zMotion = LivingEntityMixin.getAllowedOffset(Direction.Axis.Z, axisAlignedBB, allCollisionShapes, zMotion);
        }
        return new Vec3d(xMotion, yMotion, zMotion);
    }

    private static double getAllowedOffset(Direction.Axis axis, AxisAlignedBB bb, List<VoxelShape> collisionShapes, double offSet) {
        Iterator<VoxelShape> iterator = collisionShapes.iterator();
        while (iterator.hasNext()) {
            if (Math.abs(offSet) < 1.0E-7) {
                return 0.0;
            }
            offSet = iterator.next().func_212430_a(axis, bb, offSet);
        }
        return offSet;
    }

    private static void addShapesForBlockCollision(List<VoxelShape> shapeCollisionList, CubeCoordinateIterator cubeToCheck, BlockPos.Mutable mutablePos, ChunkCache world, ISelectionContext iselectioncontext, VoxelShape voxelShapeToCheckForCollisions) {
        while (cubeToCheck.func_218301_a()) {
            VoxelShape voxelshape2;
            VoxelShape nextShape;
            int coordX = cubeToCheck.func_218304_b();
            int coordY = cubeToCheck.func_218302_c();
            int coordZ = cubeToCheck.func_218303_d();
            int numBoundariesTouched = cubeToCheck.func_223473_e();
            if (numBoundariesTouched == 3) continue;
            mutablePos.func_181079_c(coordX, coordY, coordZ);
            BlockState blockstate = world.func_180495_p((BlockPos)mutablePos);
            if (numBoundariesTouched == 1 && !blockstate.func_215704_f() || numBoundariesTouched == 2 && blockstate.func_177230_c() != Blocks.field_196603_bb || !VoxelShapes.func_197879_c((VoxelShape)voxelShapeToCheckForCollisions, (VoxelShape)(nextShape = (voxelshape2 = blockstate.func_215685_b((IBlockReader)world, (BlockPos)mutablePos, iselectioncontext)).func_197751_a((double)coordX, (double)coordY, (double)coordZ)), (IBooleanFunction)IBooleanFunction.field_223238_i_)) continue;
            shapeCollisionList.add(nextShape);
        }
    }

    private Vec3d getAllowedMovement(Vec3d vec, AxisAlignedBB collisionBox, ChunkCache worldIn, ISelectionContext selectionContext, List<VoxelShape> potentialHits) {
        boolean flag;
        double xMotion = vec.field_72450_a;
        double yMotion = vec.field_72448_b;
        double zMotion = vec.field_72449_c;
        if (yMotion != 0.0 && (yMotion = this.getAllowedOffset(Direction.Axis.Y, collisionBox, worldIn, yMotion, selectionContext, potentialHits)) != 0.0) {
            collisionBox = collisionBox.func_72317_d(0.0, yMotion, 0.0);
        }
        boolean bl = flag = Math.abs(xMotion) < Math.abs(zMotion);
        if (flag && zMotion != 0.0 && (zMotion = this.getAllowedOffset(Direction.Axis.Z, collisionBox, worldIn, zMotion, selectionContext, potentialHits)) != 0.0) {
            collisionBox = collisionBox.func_72317_d(0.0, 0.0, zMotion);
        }
        if (xMotion != 0.0) {
            xMotion = this.getAllowedOffset(Direction.Axis.X, collisionBox, worldIn, xMotion, selectionContext, potentialHits);
            if (!flag && xMotion != 0.0) {
                collisionBox = collisionBox.func_72317_d(xMotion, 0.0, 0.0);
            }
        }
        if (!flag && zMotion != 0.0) {
            zMotion = this.getAllowedOffset(Direction.Axis.Z, collisionBox, worldIn, zMotion, selectionContext, potentialHits);
        }
        return new Vec3d(xMotion, yMotion, zMotion);
    }

    private double getAllowedOffset(Direction.Axis p_216383_0_, AxisAlignedBB p_216383_1_, IWorldReader p_216383_2_, double p_216383_3_, ISelectionContext p_216383_5_, List<VoxelShape> p_216383_6_) {
        return this.getAllowedOffset(p_216383_1_, p_216383_2_, p_216383_3_, p_216383_5_, AxisRotation.func_197516_a((Direction.Axis)p_216383_0_, (Direction.Axis)Direction.Axis.Z), p_216383_6_);
    }

    private double getAllowedOffset(AxisAlignedBB collisionBox, IWorldReader worldReader, double desiredOffset, ISelectionContext selectionContext, AxisRotation rotationAxis, List<VoxelShape> possibleHits) {
        if (!(collisionBox.func_216364_b() < 1.0E-6 || collisionBox.func_216360_c() < 1.0E-6 || collisionBox.func_216362_d() < 1.0E-6)) {
            if (Math.abs(desiredOffset) < 1.0E-7) {
                return 0.0;
            }
            AxisRotation axisrotation = rotationAxis.func_197514_a();
            Direction.Axis direction$axis = axisrotation.func_197513_a(Direction.Axis.X);
            Direction.Axis direction$axis1 = axisrotation.func_197513_a(Direction.Axis.Y);
            Direction.Axis direction$axis2 = axisrotation.func_197513_a(Direction.Axis.Z);
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            int i = MathHelper.func_76128_c((double)(collisionBox.func_197745_a(direction$axis) - 1.0E-7)) - 1;
            int j = MathHelper.func_76128_c((double)(collisionBox.func_197742_b(direction$axis) + 1.0E-7)) + 1;
            int k = MathHelper.func_76128_c((double)(collisionBox.func_197745_a(direction$axis1) - 1.0E-7)) - 1;
            int l = MathHelper.func_76128_c((double)(collisionBox.func_197742_b(direction$axis1) + 1.0E-7)) + 1;
            double d0 = collisionBox.func_197745_a(direction$axis2) - 1.0E-7;
            double d1 = collisionBox.func_197742_b(direction$axis2) + 1.0E-7;
            boolean flag = desiredOffset > 0.0;
            int i1 = flag ? MathHelper.func_76128_c((double)(collisionBox.func_197742_b(direction$axis2) - 1.0E-7)) - 1 : MathHelper.func_76128_c((double)(collisionBox.func_197745_a(direction$axis2) + 1.0E-7)) + 1;
            int j1 = LivingEntityMixin.getDifferenceFloored(desiredOffset, d0, d1);
            int k1 = flag ? 1 : -1;
            int l1 = i1;
            while (!(flag ? l1 > j1 : l1 < j1)) {
                for (int i2 = i; i2 <= j; ++i2) {
                    for (int j2 = k; j2 <= l; ++j2) {
                        int k2 = 0;
                        if (i2 == i || i2 == j) {
                            ++k2;
                        }
                        if (j2 == k || j2 == l) {
                            ++k2;
                        }
                        if (l1 == i1 || l1 == j1) {
                            ++k2;
                        }
                        if (k2 >= 3) continue;
                        blockpos$mutable.func_218295_a(axisrotation, i2, j2, l1);
                        BlockState blockstate = this.getCache().func_180495_p((BlockPos)blockpos$mutable);
                        if (k2 == 1 && !blockstate.func_215704_f() || k2 == 2 && blockstate.func_177230_c() != Blocks.field_196603_bb) continue;
                        desiredOffset = blockstate.func_215685_b((IBlockReader)worldReader, (BlockPos)blockpos$mutable, selectionContext).func_212430_a(direction$axis2, collisionBox.func_72317_d((double)(-blockpos$mutable.func_177958_n()), (double)(-blockpos$mutable.func_177956_o()), (double)(-blockpos$mutable.func_177952_p())), desiredOffset);
                        if (Math.abs(desiredOffset) < 1.0E-7) {
                            return 0.0;
                        }
                        j1 = LivingEntityMixin.getDifferenceFloored(desiredOffset, d0, d1);
                    }
                }
                l1 += k1;
            }
            for (VoxelShape shape : possibleHits) {
                desiredOffset = shape.func_212430_a(direction$axis2, collisionBox, desiredOffset);
            }
            return desiredOffset;
        }
        return desiredOffset;
    }

    private static int getDifferenceFloored(double desiredOffset, double min, double max) {
        return desiredOffset > 0.0 ? MathHelper.func_76128_c((double)(max + desiredOffset)) + 1 : MathHelper.func_76128_c((double)(min + desiredOffset)) - 1;
    }

    private List<VoxelShape> getEntityCollisionBoxes(@Nullable Entity entity, AxisAlignedBB boundingBox, Set<Entity> excludedEntities) {
        if (boundingBox.func_72320_b() < 1.0E-7) {
            this.entityCollisionBoxes = new ArrayList<VoxelShape>();
            return new ArrayList<VoxelShape>();
        }
        ArrayList<VoxelShape> result = new ArrayList<VoxelShape>();
        AxisAlignedBB grownBB = boundingBox.func_186662_g(1.0E-7);
        for (Entity currentEntity : this.getCache().getEntitiesInAABBexcluding(entity, grownBB, EntityPredicates.field_180132_d)) {
            AxisAlignedBB currentCBB;
            if (currentEntity == null || entity != null && entity.func_184223_x(currentEntity) || excludedEntities.contains(currentEntity) || (currentCBB = currentEntity.func_70046_E()) == null || !grownBB.func_72326_a(currentCBB)) continue;
            result.add(VoxelShapes.func_197881_a((AxisAlignedBB)currentCBB));
        }
        this.entityCollisionBoxes = result;
        return result;
    }

    public boolean func_70038_c(double x, double y, double z) {
        if (x == 0.0 && z == 0.0 && this.tickCounter % 20 != 0) {
            return this.isOffsetPosInLiquidres;
        }
        this.isOffsetPosInLiquidres = this.getCache().func_226665_a__(this, this.func_174813_aQ().func_72317_d(x, y, z)) && !this.getCache().func_72953_d(this.func_174813_aQ().func_72317_d(x, y, z));
        return this.isOffsetPosInLiquidres;
    }

    public float func_225515_ai_() {
        if (this.tickCounter % 5 != 0) {
            return this.lastSpeedFactor;
        }
        Block block = this.getCache().func_180495_p(new BlockPos((Entity)this)).func_177230_c();
        float f = block.func_226891_m_();
        this.lastSpeedFactor = block != Blocks.field_150355_j && block != Blocks.field_203203_C ? ((double)f == 1.0 ? this.getCache().func_180495_p(this.func_226270_aj_()).func_177230_c().func_226891_m_() : f) : f;
        return this.lastSpeedFactor;
    }

    @Overwrite
    public void func_85033_bc() {
        if (this.tickCounter % 3 != 0) {
            return;
        }
        if (!this.field_70170_p.field_72995_K && ConfigurationCache.multiEntities && !(this.self instanceof PlayerEntity)) {
            MoveThread.enqueEntityColl(this.self);
        } else {
            this.callEntityCollisions();
        }
    }

    @Override
    public void callEntityCollisions() {
        List<Entity> list = this.getCache().getEntitiesInAABBexcluding(this, this.func_174813_aQ(), EntityPredicates.func_200823_a((Entity)this));
        if (!list.isEmpty()) {
            int i = this.field_70170_p.func_82736_K().func_223592_c(GameRules.field_223616_s);
            if (i > 0 && list.size() > i - 1 && this.field_70146_Z.nextInt(4) == 0) {
                int j = 0;
                for (int k = 0; k < list.size(); ++k) {
                    if (list.get(k).func_184218_aH()) continue;
                    ++j;
                }
                if (j > i - 1) {
                    this.func_70097_a(DamageSource.field_191291_g, 6.0f);
                }
            }
            for (int l = 0; l < list.size(); ++l) {
                Entity entity = list.get(l);
                this.collideWithEntity(entity);
            }
        }
    }

    private void updateLadderState() {
        if (this.tickCounter % 5 != 0 && !this.hasMovedForCalc) {
            return;
        }
        BlockState blockstate = this.getCache().func_180495_p(new BlockPos((Entity)this));
        boolean isSpectator = this.func_175149_v();
        if (isSpectator) {
            this.lastIsOnLadder = false;
            return;
        }
        if (!this.forgeLadderCheck) {
            this.lastIsOnLadder = blockstate.isLadder((IWorldReader)this.getCache(), new BlockPos((Entity)this), this.self);
            return;
        }
        AxisAlignedBB bb = this.self.func_174813_aQ();
        int mX = MathHelper.func_76128_c((double)bb.field_72340_a);
        int mY = MathHelper.func_76128_c((double)bb.field_72338_b);
        int mZ = MathHelper.func_76128_c((double)bb.field_72339_c);
        int y2 = mY;
        while ((double)y2 < bb.field_72337_e) {
            int x2 = mX;
            while ((double)x2 < bb.field_72336_d) {
                int z2 = mZ;
                while ((double)z2 < bb.field_72334_f) {
                    BlockPos tmp = new BlockPos(x2, y2, z2);
                    blockstate = this.getCache().func_180495_p(tmp);
                    if (blockstate.isLadder((IWorldReader)this.field_70170_p, tmp, this.self)) {
                        this.lastIsOnLadder = true;
                        return;
                    }
                    ++z2;
                }
                ++x2;
            }
            ++y2;
        }
        this.lastIsOnLadder = false;
    }

    @Overwrite
    public boolean func_70617_f_() {
        if (this.func_175149_v()) {
            return false;
        }
        return this.lastIsOnLadder;
    }

    protected void collideWithEntity(Entity entityIn) {
        entityIn.func_70108_f((Entity)this);
    }

    public boolean func_213290_a(Tag<Fluid> p_213290_1_, boolean checkChunkLoaded) {
        if (this.tickCounter % 10 != 0) {
            return this.areEyesInFluid;
        }
        if (this.func_184187_bx() instanceof BoatEntity) {
            this.areEyesInFluid = false;
        } else {
            double d0 = this.func_226280_cw_();
            BlockPos blockpos = new BlockPos(this.func_226277_ct_(), d0, this.func_226281_cx_());
            if (checkChunkLoaded && !this.getCache().func_217354_b(blockpos.func_177958_n() >> 4, blockpos.func_177952_p() >> 4)) {
                this.areEyesInFluid = false;
            } else {
                IFluidState ifluidstate = this.getCache().func_204610_c(blockpos);
                this.areEyesInFluid = ifluidstate.isEntityInside((IWorldReader)this.getCache(), blockpos, (Entity)this, d0, p_213290_1_, true);
            }
        }
        return this.areEyesInFluid;
    }

    public void func_205343_av() {
        if (this.tickCounter % 5 != 0) {
            return;
        }
        super.func_205343_av();
    }

    public void func_174829_m() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        this.func_226288_n_((axisalignedbb.field_72340_a + axisalignedbb.field_72336_d) / 2.0, axisalignedbb.field_72338_b, (axisalignedbb.field_72339_c + axisalignedbb.field_72334_f) / 2.0);
    }

    private void chunkCheck(Entity entityIn) {
        int i = MathHelper.func_76128_c((double)(entityIn.func_226277_ct_() / 16.0));
        int j = MathHelper.func_76128_c((double)(entityIn.func_226278_cu_() / 16.0));
        int k = MathHelper.func_76128_c((double)(entityIn.func_226281_cx_() / 16.0));
        if (!entityIn.field_70175_ag || entityIn.field_70176_ah != i || entityIn.field_70162_ai != j || entityIn.field_70164_aj != k) {
            if (entityIn.field_70175_ag && this.getCache().func_217354_b(entityIn.field_70176_ah, entityIn.field_70164_aj)) {
                ((Chunk)this.getCache().func_212866_a_(entityIn.field_70176_ah, entityIn.field_70164_aj)).func_76608_a(entityIn, entityIn.field_70162_ai);
            }
            if (!entityIn.func_184189_br() && !this.getCache().func_217354_b(i, k)) {
                entityIn.field_70175_ag = false;
            } else {
                this.getCache().func_212866_a_(i, k).func_76612_a(entityIn);
            }
        }
    }

    @Overwrite
    protected void func_226295_cZ_() {
        if (!this.func_174814_R()) {
            int i = MathHelper.func_76128_c((double)this.func_226277_ct_());
            int j = MathHelper.func_76128_c((double)(this.func_226278_cu_() - (double)0.2f));
            int k = MathHelper.func_76128_c((double)this.func_226281_cx_());
            BlockPos pos = new BlockPos(i, j, k);
            BlockState blockstate = this.getCache().func_180495_p(pos);
            if (!blockstate.isAir((IBlockReader)this.getCache(), pos)) {
                SoundType soundtype = blockstate.getSoundType((IWorldReader)this.getCache(), pos, (Entity)this);
                this.func_184185_a(soundtype.func_185842_g(), soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b() * 0.75f);
            }
        }
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        if (!blockIn.func_185904_a().func_76224_d()) {
            BlockState blockstate = this.getCache().func_180495_p(pos.func_177984_a());
            SoundType soundtype = blockstate.func_177230_c() == Blocks.field_150433_aE ? blockstate.getSoundType((IWorldReader)this.field_70170_p, pos, (Entity)this) : blockIn.getSoundType((IWorldReader)this.getCache(), pos, (Entity)this);
            this.func_184185_a(soundtype.func_185844_d(), soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
        }
    }

    @Override
    public void clearCache() {
        this.chunkCache = null;
    }

    @Override
    public void clearQueue() {
        this.mainThreadQue.clear();
    }
}

