/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.entity.ai;

import com.google.common.collect.Sets;
import com.performant.coremod.Performant;
import com.performant.coremod.commands.ReportData;
import com.performant.coremod.config.ConfigurationCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.profiler.IProfiler;
import org.jetbrains.annotations.NotNull;

public class CustomGoalSelector
extends GoalSelector {
    private static final PrioritizedGoal DUMMY = new PrioritizedGoal(Integer.MAX_VALUE, new Goal(){

        public boolean func_75250_a() {
            return false;
        }
    }){

        public boolean func_220773_g() {
            return false;
        }
    };
    private final PrioritizedGoal[] flagGoalsArray = new PrioritizedGoal[FLAG_COUNT];
    public Set<PrioritizedGoal> field_220892_d = Sets.newHashSet();
    private IProfiler profiler;
    private final boolean[] disabledFlagsArray = new boolean[FLAG_COUNT];
    private static final int FLAG_COUNT = Goal.Flag.values().length;
    private boolean ticking = false;
    private boolean goalsChanged = false;
    private Set<PrioritizedGoal> toAdd = Sets.newHashSet();
    private List<Goal> toRemove = new ArrayList<Goal>();
    int counter = 0;
    private long avgTick = 0L;
    private int avgTickCount = 1;
    public static final int SHOULD_EXECUTE_INTERVAL = (Integer)Performant.getConfig().getCommon().goalSelectorTickRate.get() - 1;
    private MobEntity entity = null;
    private int pauseTicks = 0;
    private int pauseTickDelay = 0;
    private long slowest = 0L;
    private Goal slowestGoal = null;
    long preTick = 0L;
    long preTask = 0L;
    long tempTime = 0L;
    private static final int MIN_ERROR_REPORT_PERCENT = 20;
    private static final int MIN_DEBUG_LAG = 5;

    public CustomGoalSelector(@NotNull GoalSelector old, MobEntity entity) {
        super(old.field_75781_c);
        this.importFrom(old);
        ((GoalSelector)this).field_220892_d = this.field_220892_d;
        this.field_75781_c = this.profiler;
        this.entity = entity;
    }

    public CustomGoalSelector(@NotNull IProfiler profiler) {
        super(profiler);
        this.profiler = profiler;
        ((GoalSelector)this).field_220892_d = this.field_220892_d;
        this.field_75781_c = this.profiler;
        for (Goal.Flag flag : Goal.Flag.values()) {
            this.flagGoalsArray[flag.ordinal()] = DUMMY;
        }
    }

    public void importFrom(GoalSelector selector) {
        if (selector == null) {
            return;
        }
        for (Goal.Flag flag : Goal.Flag.values()) {
            this.flagGoalsArray[flag.ordinal()] = selector.field_220891_c.getOrDefault(flag, DUMMY);
        }
        this.field_220892_d = selector.field_220892_d;
        LinkedHashSet<PrioritizedGoal> tempGoals = new LinkedHashSet<PrioritizedGoal>();
        for (PrioritizedGoal goal : this.field_220892_d) {
            this.addGoalOrCustomToList(goal.func_220770_h(), goal.func_220772_j(), tempGoals);
        }
        this.field_220892_d = tempGoals;
        selector.field_220892_d = tempGoals;
        this.profiler = selector.field_75781_c;
        for (Goal.Flag flag : selector.field_220893_f) {
            this.disabledFlagsArray[flag.ordinal()] = true;
        }
    }

    private void addGoalOrCustomToList(int priority, Goal goal, Set<PrioritizedGoal> goalList) {
        goalList.add(Performant.goalData.getPriotizedGoalFor(priority, goal, this));
    }

    public void func_75776_a(int priority, Goal task) {
        if (this.field_220892_d.size() >= 100) {
            Performant.LOGGER.info("AI tried to add over 100 goals, removing entity", (Throwable)new Exception("Too many AI Tasks"));
            this.entity.func_70106_y();
            return;
        }
        if (this.ticking) {
            this.goalsChanged = true;
            this.addGoalOrCustomToList(priority, task, this.toAdd);
        } else {
            this.addGoalOrCustomToList(priority, task, this.field_220892_d);
        }
    }

    public void func_85156_a(Goal task) {
        if (this.ticking) {
            this.goalsChanged = true;
            this.toRemove.add(task);
        } else {
            CustomGoalSelector.removeGoalFromList(this.field_220892_d, task);
        }
    }

    private static void removeGoalFromList(Collection<PrioritizedGoal> goalList, Goal taskToRemove) {
        Iterator<PrioritizedGoal> i = goalList.iterator();
        while (i.hasNext()) {
            PrioritizedGoal goal = i.next();
            if (goal.func_220772_j() != taskToRemove) continue;
            if (goal.func_220773_g()) {
                goal.func_75251_c();
            }
            i.remove();
        }
    }

    private boolean goalContainsDisabledFlag(PrioritizedGoal goal) {
        for (int i = 0; i < FLAG_COUNT; ++i) {
            if (!this.disabledFlagsArray[i] || !goal.func_220686_i().contains(Goal.Flag.values()[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isPreemptedByAll(PrioritizedGoal goal1) {
        for (int i = 0; i < FLAG_COUNT; ++i) {
            PrioritizedGoal compareGoal = this.flagGoalsArray[i];
            if (!compareGoal.func_220773_g() || compareGoal.func_220771_a(goal1) || !goal1.func_220686_i().contains(Goal.Flag.values()[i])) continue;
            return false;
        }
        return true;
    }

    public void func_75774_a() {
        if (this.pauseTicks-- > 0) {
            return;
        }
        this.pauseTicks = this.pauseTickDelay;
        this.slowest = 0L;
        this.ticking = true;
        ++this.counter;
        this.preTick = System.currentTimeMillis();
        for (PrioritizedGoal currentGoal : this.field_220892_d) {
            if (ConfigurationCache.AILoadBalancing && ConfigurationCache.logEntityAILag && this.pauseTickDelay > 0) {
                this.preTask = System.nanoTime();
            }
            if (currentGoal.func_220773_g() && (this.goalContainsDisabledFlag(currentGoal) || !currentGoal.func_75253_b())) {
                currentGoal.func_75251_c();
            }
            if (this.counter == 1 && !currentGoal.func_220773_g() && !this.goalContainsDisabledFlag(currentGoal) && this.isPreemptedByAll(currentGoal) && currentGoal.func_75250_a()) {
                for (Goal.Flag flag : currentGoal.func_220686_i()) {
                    PrioritizedGoal prioritizedgoal = this.flagGoalsArray[flag.ordinal()];
                    prioritizedgoal.func_75251_c();
                    this.flagGoalsArray[flag.ordinal()] = currentGoal;
                }
                currentGoal.func_75249_e();
            }
            if (currentGoal.func_220773_g()) {
                currentGoal.func_75246_d();
            }
            if (!ConfigurationCache.AILoadBalancing || !ConfigurationCache.logEntityAILag || this.pauseTickDelay <= 0) continue;
            this.tempTime = System.nanoTime() - this.preTask;
            if (this.tempTime <= this.slowest) continue;
            this.slowest = this.tempTime;
            this.slowestGoal = currentGoal.func_220772_j();
        }
        this.avgTick += System.currentTimeMillis() - this.preTick;
        ++this.avgTickCount;
        if (this.avgTickCount == 20) {
            if (ConfigurationCache.AILoadBalancing && ConfigurationCache.CURRENT_MEAN_TICK_TIME > (double)ConfigurationCache.meanTickAITH) {
                if (this.avgTick > 0L) {
                    this.pauseTicks = (int)this.avgTick * 100 / ConfigurationCache.timeForAI;
                    if (ConfigurationCache.generateReport && this.pauseTicks > 0) {
                        ReportData data = new ReportData();
                        data.lagGoal = this.slowestGoal;
                        data.goalTime = (int)this.avgTick;
                        data.entity = this.entity;
                        ReportData.addEntityReport((Entity)this.entity, data);
                    }
                    if (this.pauseTicks > 20) {
                        if (ConfigurationCache.logEntityAILag && this.pauseTickDelay >= 5) {
                            Performant.LOGGER.info("Entiy" + this.entity.func_200600_R().func_212546_e().func_150254_d() + " at:" + this.entity.func_180425_c() + " dim: " + this.entity.field_70170_p.field_73011_w.func_186058_p().func_186068_a() + " is lagging, likely culprit task is:" + this.slowestGoal.toString());
                            Performant.LOGGER.info("Pausing entity AI due to lag, last 20 ticks took:" + this.avgTick + "ms. Stacktrace below, let the mod author know(not performant, the entities mod author)", (Throwable)new Exception("Entity AI Task lag"));
                        }
                        this.pauseTicks = 200;
                    }
                }
                this.pauseTickDelay = this.pauseTicks;
            } else {
                this.pauseTickDelay = 0;
            }
            this.avgTickCount = 0;
            this.avgTick = 0L;
        }
        if (this.counter > SHOULD_EXECUTE_INTERVAL) {
            this.counter = 0;
        }
        this.ticking = false;
        if (this.goalsChanged) {
            this.goalsChanged = false;
            this.field_220892_d.addAll(this.toAdd);
            this.toAdd.clear();
            for (Goal goal : this.toRemove) {
                CustomGoalSelector.removeGoalFromList(this.field_220892_d, goal);
            }
            this.toRemove.clear();
        }
    }

    public Stream<PrioritizedGoal> func_220888_c() {
        return this.field_220892_d.stream().filter(PrioritizedGoal::func_220773_g);
    }

    public void func_220880_a(Goal.Flag flag) {
        this.disabledFlagsArray[flag.ordinal()] = true;
    }

    public void func_220886_b(Goal.Flag flag) {
        this.disabledFlagsArray[flag.ordinal()] = false;
    }

    public void func_220878_a(Goal.Flag flag, boolean enabled) {
        if (enabled) {
            this.func_220886_b(flag);
        } else {
            this.func_220880_a(flag);
        }
    }
}

