/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.transmitters.grid;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import mekanism.api.Coord4D;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.common.MekanismLang;
import mekanism.common.content.transporter.PathfinderCache;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.util.MekanismUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.IChunk;

public class InventoryNetwork
extends DynamicNetwork<TileEntity, InventoryNetwork, Void> {
    public InventoryNetwork() {
    }

    public InventoryNetwork(UUID networkID) {
        super(networkID);
    }

    public InventoryNetwork(Collection<InventoryNetwork> networks) {
        for (InventoryNetwork net : networks) {
            if (net == null) continue;
            this.adoptTransmittersAndAcceptorsFrom(net);
            net.deregister();
        }
        this.register();
    }

    public List<AcceptorData> calculateAcceptors(TransitRequest request, TransporterStack stack, Long2ObjectMap<IChunk> chunkMap) {
        ArrayList<AcceptorData> toReturn = new ArrayList<AcceptorData>();
        for (Coord4D coord : this.possibleAcceptors) {
            TileEntity acceptor;
            EnumSet sides;
            if (coord == null || coord.equals(stack.homeLocation) || (sides = (EnumSet)this.acceptorDirections.get(coord)) == null || sides.isEmpty() || (acceptor = MekanismUtils.getTileEntity((IWorld)this.getWorld(), chunkMap, coord)) == null) continue;
            AcceptorData data = null;
            for (Direction side : sides) {
                Direction opposite = side.func_176734_d();
                TransitRequest.TransitResponse response = TransporterManager.getPredictedInsert(acceptor, stack.color, request, opposite);
                if (response.isEmpty()) continue;
                if (data == null) {
                    data = new AcceptorData(coord, response, opposite);
                    toReturn.add(data);
                    continue;
                }
                data.sides.add(opposite);
            }
        }
        return toReturn;
    }

    @Override
    public void commit() {
        super.commit();
        PathfinderCache.onChanged(this);
    }

    @Override
    public void deregister() {
        super.deregister();
        PathfinderCache.onChanged(this);
    }

    @Override
    public void absorbBuffer(IGridTransmitter<TileEntity, InventoryNetwork, Void> transmitter) {
    }

    @Override
    public void clampBuffer() {
    }

    @Override
    protected synchronized void updateCapacity(IGridTransmitter<TileEntity, InventoryNetwork, Void> transmitter) {
    }

    @Override
    public synchronized void updateCapacity() {
    }

    public String toString() {
        return "[InventoryNetwork] " + this.transmitters.size() + " transmitters, " + this.possibleAcceptors.size() + " acceptors.";
    }

    @Override
    public ITextComponent getNeededInfo() {
        return null;
    }

    @Override
    public ITextComponent getStoredInfo() {
        return null;
    }

    @Override
    public ITextComponent getFlowInfo() {
        return null;
    }

    @Override
    public ITextComponent getTextComponent() {
        return MekanismLang.NETWORK_DESCRIPTION.translate(MekanismLang.INVENTORY_NETWORK, this.transmitters.size(), this.possibleAcceptors.size());
    }

    public static class AcceptorData {
        private Coord4D location;
        private TransitRequest.TransitResponse response;
        private Set<Direction> sides;

        public AcceptorData(Coord4D coord, TransitRequest.TransitResponse ret, Direction side) {
            this.location = coord;
            this.response = ret;
            this.sides = EnumSet.of(side);
        }

        public TransitRequest.TransitResponse getResponse() {
            return this.response;
        }

        public Coord4D getLocation() {
            return this.location;
        }

        public Set<Direction> getSides() {
            return this.sides;
        }
    }
}

