/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.transmitters;

import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.math.FloatingLong;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.transmitters.Transmitter;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class TransmitterImpl<ACCEPTOR, NETWORK extends DynamicNetwork<ACCEPTOR, NETWORK, BUFFER>, BUFFER>
extends Transmitter<ACCEPTOR, NETWORK, BUFFER> {
    public TileEntityTransmitter<ACCEPTOR, NETWORK, BUFFER> containingTile;

    public TransmitterImpl(TileEntityTransmitter<ACCEPTOR, NETWORK, BUFFER> transmitter) {
        this.setTileEntity(transmitter);
    }

    @Override
    @Nonnull
    public FloatingLong getCapacityAsFloatingLong() {
        return this.getTileEntity().getCapacityAsFloatingLong();
    }

    @Override
    public long getCapacity() {
        return this.getTileEntity().getCapacity();
    }

    @Override
    public World world() {
        return this.getTileEntity().func_145831_w();
    }

    @Override
    public Coord4D coord() {
        return new Coord4D(this.getTileEntity().func_174877_v(), (IWorldReader)this.world());
    }

    @Override
    public Coord4D getAdjacentConnectableTransmitterCoord(Direction side) {
        Coord4D sideCoord = this.coord().offset(side);
        TileEntity potentialTransmitterTile = MekanismUtils.getTileEntity((IBlockReader)this.world(), sideCoord.getPos());
        if (!this.containingTile.canConnectMutual(side, potentialTransmitterTile)) {
            return null;
        }
        Optional<IGridTransmitter<?, ?, ?>> gridTransmitter = MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)potentialTransmitterTile, Capabilities.GRID_TRANSMITTER_CAPABILITY, side.func_176734_d()));
        if (gridTransmitter.isPresent() && TransmissionType.checkTransmissionType(gridTransmitter.get(), this.getTransmissionType()) && this.containingTile.isValidTransmitter(potentialTransmitterTile)) {
            return sideCoord;
        }
        return null;
    }

    @Override
    public boolean isCompatibleWith(IGridTransmitter<ACCEPTOR, NETWORK, BUFFER> other) {
        if (other instanceof TransmitterImpl) {
            return this.containingTile.isValidTransmitter(((TransmitterImpl)other).containingTile);
        }
        return true;
    }

    @Override
    public ACCEPTOR getAcceptor(Direction side) {
        return this.getTileEntity().getCachedAcceptor(side);
    }

    @Override
    public boolean isValid() {
        TileEntityTransmitter<ACCEPTOR, NETWORK, BUFFER> cont = this.getTileEntity();
        if (cont == null) {
            return false;
        }
        return !cont.func_145837_r() && MekanismUtils.getTileEntity((IBlockReader)this.world(), cont.func_174877_v()) == cont && cont.getTransmitter() == this;
    }

    @Override
    public NETWORK createEmptyNetwork() {
        return this.getTileEntity().createNewNetwork();
    }

    @Override
    public NETWORK createEmptyNetworkWithID(UUID networkID) {
        return this.getTileEntity().createNewNetworkWithID(networkID);
    }

    @Override
    public NETWORK getExternalNetwork(Coord4D from) {
        IGridTransmitter<?, ?, ?> transmitter;
        Optional<IGridTransmitter<?, ?, ?>> gridTransmitter = MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)MekanismUtils.getTileEntity((IBlockReader)this.world(), from.getPos()), Capabilities.GRID_TRANSMITTER_CAPABILITY, null));
        if (gridTransmitter.isPresent() && TransmissionType.checkTransmissionType(transmitter = gridTransmitter.get(), this.getTransmissionType())) {
            return (NETWORK)transmitter.getTransmitterNetwork();
        }
        return null;
    }

    @Override
    public void takeShare() {
        this.containingTile.takeShare();
    }

    @Override
    @Nullable
    public BUFFER releaseShare() {
        return this.getTileEntity().releaseShare();
    }

    @Override
    @Nullable
    public BUFFER getBufferWithFallback() {
        return this.getTileEntity().getBufferWithFallback();
    }

    @Override
    public NETWORK mergeNetworks(Collection<NETWORK> toMerge) {
        return this.getTileEntity().createNetworkByMerging(toMerge);
    }

    @Override
    public TransmissionType getTransmissionType() {
        return this.getTileEntity().getTransmissionType();
    }

    @Override
    public void setRequestsUpdate() {
        this.getTileEntity().requestsUpdate();
    }

    public TileEntityTransmitter<ACCEPTOR, NETWORK, BUFFER> getTileEntity() {
        return this.containingTile;
    }

    public void setTileEntity(TileEntityTransmitter<ACCEPTOR, NETWORK, BUFFER> containingPart) {
        this.containingTile = containingPart;
    }
}

