/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.BasicGasTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.recipes.GasToGasRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.GasToGasCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.base.IBoundingBlock;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.GasInventorySlot;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.ITileCachedRecipeHolder;
import mekanism.common.util.GasUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class TileEntitySolarNeutronActivator
extends TileEntityMekanism
implements IBoundingBlock,
ITileCachedRecipeHolder<GasToGasRecipe> {
    public static final long MAX_GAS = 10000L;
    public BasicGasTank inputTank;
    public BasicGasTank outputTank;
    public long gasOutput = 256L;
    private CachedRecipe<GasToGasRecipe> cachedRecipe;
    private boolean settingsChecked;
    private boolean needsRainCheck;
    private final IOutputHandler<@NonNull GasStack> outputHandler;
    private final IInputHandler<@NonNull GasStack> inputHandler = InputHelper.getInputHandler(this.inputTank);
    private GasInventorySlot inputSlot;
    private GasInventorySlot outputSlot;

    public TileEntitySolarNeutronActivator() {
        super(MekanismBlocks.SOLAR_NEUTRON_ACTIVATOR);
        this.outputHandler = OutputHelper.getOutputHandler(this.outputTank);
    }

    @Override
    @Nonnull
    protected IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        ChemicalTankHelper<Gas, GasStack, IGasTank> builder = ChemicalTankHelper.forSideGas(this::getDirection);
        this.inputTank = BasicGasTank.input(10000L, gas -> this.containsRecipe(recipe -> recipe.getInput().testType((Gas)gas)), this);
        builder.addTank(this.inputTank, RelativeSide.BOTTOM);
        this.outputTank = BasicGasTank.output(10000L, this);
        builder.addTank(this.outputTank, RelativeSide.FRONT);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.inputSlot = GasInventorySlot.fill(this.inputTank, this, 5, 56);
        builder.addSlot(this.inputSlot, RelativeSide.BOTTOM, RelativeSide.TOP, RelativeSide.RIGHT, RelativeSide.LEFT, RelativeSide.BACK);
        this.outputSlot = GasInventorySlot.drain(this.outputTank, this, 155, 56);
        builder.addSlot(this.outputSlot, RelativeSide.FRONT);
        this.inputSlot.setSlotType(ContainerSlotType.INPUT);
        this.inputSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.outputSlot.setSlotType(ContainerSlotType.OUTPUT);
        this.outputSlot.setSlotOverlay(SlotOverlay.PLUS);
        return builder.build();
    }

    protected void recheckSettings() {
        Biome b = this.field_145850_b.func_225523_d_().func_226836_a_(this.func_174877_v());
        this.needsRainCheck = b.func_201851_b() != Biome.RainType.NONE;
        this.settingsChecked = true;
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (!this.settingsChecked) {
            this.recheckSettings();
        }
        this.inputSlot.fillTank();
        this.outputSlot.drainTank();
        this.cachedRecipe = this.getUpdatedCache(0);
        if (this.cachedRecipe != null) {
            this.cachedRecipe.process();
        }
        GasUtils.emit(EnumSet.of(this.getDirection()), this.outputTank, this, this.gasOutput);
    }

    @Override
    @Nonnull
    public MekanismRecipeType<GasToGasRecipe> getRecipeType() {
        return MekanismRecipeType.ACTIVATING;
    }

    @Override
    @Nullable
    public CachedRecipe<GasToGasRecipe> getCachedRecipe(int cacheIndex) {
        return this.cachedRecipe;
    }

    @Override
    @Nullable
    public GasToGasRecipe getRecipe(int cacheIndex) {
        GasStack gas = this.inputHandler.getInput();
        if (gas.isEmpty()) {
            return null;
        }
        return (GasToGasRecipe)this.findFirstRecipe(recipe -> recipe.test(gas));
    }

    private boolean canFunction(BlockPos positionAbove) {
        boolean seesSun;
        boolean bl = seesSun = this.field_145850_b.func_72935_r() && this.field_145850_b.func_175710_j(positionAbove) && !this.field_145850_b.func_201675_m().func_177495_o();
        if (this.needsRainCheck) {
            seesSun &= !this.field_145850_b.func_72896_J() && !this.field_145850_b.func_72911_I();
        }
        return seesSun && MekanismUtils.canFunction(this);
    }

    @Override
    @Nullable
    public CachedRecipe<GasToGasRecipe> createNewCachedRecipe(@Nonnull GasToGasRecipe recipe, int cacheIndex) {
        BlockPos positionAbove = this.func_174877_v().func_177984_a();
        return new GasToGasCachedRecipe(recipe, this.inputHandler, this.outputHandler).setCanHolderFunction(() -> this.canFunction(positionAbove)).setActive(this::setActive).setOnFinish(() -> this.markDirty(false)).setPostProcessOperations(currentMax -> {
            if (currentMax <= 0) {
                return currentMax;
            }
            return Math.min((int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED)), currentMax);
        });
    }

    @Override
    public void onPlace() {
        MekanismUtils.makeBoundingBlock((IWorld)this.func_145831_w(), this.func_174877_v().func_177984_a(), this.func_174877_v());
    }

    @Override
    public void onBreak() {
        World world = this.func_145831_w();
        if (world != null) {
            world.func_217377_a(this.func_174877_v().func_177984_a(), false);
            world.func_217377_a(this.func_174877_v(), false);
        }
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 2, 1));
    }

    public double getProgress() {
        if (this.getActive()) {
            return 0.16 * (double)(1L + this.field_145850_b.func_72820_D() % 6L);
        }
        return 0.0;
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.inputTank.getStored(), this.inputTank.getCapacity());
    }
}

