/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Upgrade;
import mekanism.api.block.IHasTileEntity;
import mekanism.api.sustained.ISustainedInventory;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.recipe.upgrade.EnergyRecipeData;
import mekanism.common.recipe.upgrade.FluidRecipeData;
import mekanism.common.recipe.upgrade.GasRecipeData;
import mekanism.common.recipe.upgrade.InfusionRecipeData;
import mekanism.common.recipe.upgrade.ItemRecipeData;
import mekanism.common.recipe.upgrade.RecipeUpgradeType;
import mekanism.common.recipe.upgrade.SecurityRecipeData;
import mekanism.common.recipe.upgrade.UpgradesRecipeData;
import mekanism.common.security.ISecurityItem;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

@ParametersAreNonnullByDefault
public interface RecipeUpgradeData<TYPE extends RecipeUpgradeData<TYPE>> {
    @Nullable
    public TYPE merge(TYPE var1);

    public boolean applyToStack(ItemStack var1);

    @Nonnull
    public static Set<RecipeUpgradeType> getSupportedTypes(ItemStack stack) {
        if (stack.func_190926_b()) {
            return Collections.emptySet();
        }
        EnumSet<RecipeUpgradeType> supportedTypes = EnumSet.noneOf(RecipeUpgradeType.class);
        Item item = stack.func_77973_b();
        TileEntityMekanism tile = null;
        if (item instanceof BlockItem) {
            TileEntity tileEntity;
            Block block = ((BlockItem)item).func_179223_d();
            if (block instanceof IHasTileEntity && (tileEntity = ((IHasTileEntity)block).getTileType().func_200968_a()) instanceof TileEntityMekanism) {
                tile = (TileEntityMekanism)tileEntity;
            }
            if (Attribute.has(block, AttributeUpgradeSupport.class)) {
                supportedTypes.add(RecipeUpgradeType.UPGRADE);
            }
        }
        if (stack.getCapability(Capabilities.STRICT_ENERGY_CAPABILITY).isPresent() || tile != null && tile.handles(SubstanceType.ENERGY)) {
            supportedTypes.add(RecipeUpgradeType.ENERGY);
        }
        if (stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent() || tile != null && tile.handles(SubstanceType.FLUID)) {
            supportedTypes.add(RecipeUpgradeType.FLUID);
        }
        if (stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).isPresent() || tile != null && tile.handles(SubstanceType.GAS)) {
            supportedTypes.add(RecipeUpgradeType.GAS);
        }
        if (stack.getCapability(Capabilities.INFUSION_HANDLER_CAPABILITY).isPresent() || tile != null && tile.handles(SubstanceType.INFUSION)) {
            supportedTypes.add(RecipeUpgradeType.INFUSION);
        }
        if (item instanceof ISustainedInventory || tile != null && tile.persistInventory()) {
            supportedTypes.add(RecipeUpgradeType.ITEM);
        }
        if (item instanceof ISecurityItem) {
            supportedTypes.add(RecipeUpgradeType.SECURITY);
        }
        return supportedTypes;
    }

    @Nullable
    public static RecipeUpgradeData<?> getUpgradeData(@Nonnull RecipeUpgradeType type, @Nonnull ItemStack stack) {
        Item item = stack.func_77973_b();
        switch (type) {
            case ENERGY: {
                return new EnergyRecipeData(ItemDataUtils.getList(stack, "EnergyContainers"));
            }
            case FLUID: {
                return new FluidRecipeData(ItemDataUtils.getList(stack, "FluidTanks"));
            }
            case GAS: {
                return new GasRecipeData(ItemDataUtils.getList(stack, "GasTanks"));
            }
            case INFUSION: {
                return new InfusionRecipeData(ItemDataUtils.getList(stack, "InfusionTanks"));
            }
            case ITEM: {
                return new ItemRecipeData(((ISustainedInventory)item).getInventory(stack));
            }
            case SECURITY: {
                ISecurityItem securityItem = (ISecurityItem)item;
                UUID ownerUUID = securityItem.getOwnerUUID(stack);
                return ownerUUID == null ? null : new SecurityRecipeData(ownerUUID, securityItem.getSecurity(stack));
            }
            case UPGRADE: {
                CompoundNBT componentUpgrade = ItemDataUtils.getCompound(stack, "componentUpgrade");
                return componentUpgrade.isEmpty() ? null : new UpgradesRecipeData(Upgrade.buildMap(componentUpgrade));
            }
        }
        return null;
    }

    @Nullable
    public static <TYPE extends RecipeUpgradeData<TYPE>> TYPE mergeUpgradeData(List<RecipeUpgradeData<?>> upgradeData) {
        if (upgradeData.isEmpty()) {
            return null;
        }
        RecipeUpgradeData<?> data = upgradeData.get(0);
        for (int i = 1; i < upgradeData.size(); ++i) {
            if ((data = data.merge(upgradeData.get(i))) != null) continue;
            return null;
        }
        return (TYPE)data;
    }
}

