/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import mekanism.api.Action;
import mekanism.api.Coord4D;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.frequency.FrequencyType;
import mekanism.common.item.ItemPortableTeleporter;
import mekanism.common.network.BasePacketHandler;
import mekanism.common.network.PacketPortableTeleporter;
import mekanism.common.network.PacketPortalFX;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PacketPortableTeleporterGui {
    private PortableTeleporterPacketType packetType;
    private Frequency frequency;
    private Hand currentHand;

    public PacketPortableTeleporterGui(PortableTeleporterPacketType type, Hand hand, Frequency freq) {
        this.packetType = type;
        this.currentHand = hand;
        this.frequency = freq;
    }

    public static void handle(PacketPortableTeleporterGui message, Supplier<NetworkEvent.Context> context) {
        PlayerEntity player = BasePacketHandler.getPlayer(context);
        if (player == null) {
            return;
        }
        context.get().enqueueWork(() -> {
            ItemStack stack = player.func_184586_b(message.currentHand);
            World world = player.field_70170_p;
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemPortableTeleporter) {
                ItemPortableTeleporter item = (ItemPortableTeleporter)stack.func_77973_b();
                switch (message.packetType) {
                    case DATA_REQUEST: {
                        PacketPortableTeleporterGui.sendDataResponse(message.frequency, world, player, item, stack, message.currentHand);
                        break;
                    }
                    case SET_FREQ: {
                        FrequencyManager manager1 = PacketPortableTeleporterGui.getManager(message.frequency.isPublic() ? null : player.func_110124_au(), world);
                        Frequency toUse = null;
                        for (Frequency freq : manager1.getFrequencies()) {
                            if (!freq.name.equals(message.frequency.name)) continue;
                            toUse = freq;
                            break;
                        }
                        if (toUse == null) {
                            toUse = new Frequency(message.frequency.name, player.func_110124_au()).setPublic(message.frequency.isPublic());
                            manager1.addFrequency(toUse);
                        }
                        item.setFrequency(stack, toUse);
                        PacketPortableTeleporterGui.sendDataResponse(toUse, world, player, item, stack, message.currentHand);
                        break;
                    }
                    case DEL_FREQ: {
                        FrequencyManager manager = PacketPortableTeleporterGui.getManager(message.frequency.isPublic() ? null : player.func_110124_au(), world);
                        manager.remove(message.frequency.name, player.func_110124_au());
                        item.setFrequency(stack, null);
                        break;
                    }
                    case TELEPORT: {
                        ServerWorld teleWorld;
                        TileEntityTeleporter teleporter;
                        Coord4D coords;
                        FrequencyManager manager2 = PacketPortableTeleporterGui.getManager(message.frequency.isPublic() ? null : player.func_110124_au(), world);
                        Frequency found = null;
                        for (Frequency freq : manager2.getFrequencies()) {
                            if (!message.frequency.name.equals(freq.name)) continue;
                            found = freq;
                            break;
                        }
                        if (found == null || (coords = found.getClosestCoords(new Coord4D((Entity)player))) == null || (teleporter = MekanismUtils.getTileEntity(TileEntityTeleporter.class, (IBlockReader)(teleWorld = ServerLifecycleHooks.getCurrentServer().func_71218_a(coords.dimension)), coords.getPos())) == null) break;
                        try {
                            if (!player.func_184812_l_()) {
                                FloatingLong energyCost = TileEntityTeleporter.calculateEnergyCost((Entity)player, coords);
                                IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
                                if (energyContainer == null || energyContainer.extract(energyCost, Action.SIMULATE, AutomationType.MANUAL).smallerThan(energyCost)) break;
                                energyContainer.extract(energyCost, Action.EXECUTE, AutomationType.MANUAL);
                            }
                            teleporter.didTeleport.add(player.func_110124_au());
                            teleporter.teleDelay = 5;
                            if (player instanceof ServerPlayerEntity) {
                                ((ServerPlayerEntity)player).field_71135_a.field_147365_f = 0;
                            }
                            player.func_71053_j();
                            Mekanism.packetHandler.sendToAllTracking(new PacketPortalFX(player.func_180425_c()), world, coords.getPos());
                            TileEntityTeleporter.teleportEntityTo((Entity)player, coords, teleporter);
                            if (player instanceof ServerPlayerEntity) {
                                TileEntityTeleporter.alignPlayer((ServerPlayerEntity)player, coords);
                            }
                            world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                            Mekanism.packetHandler.sendToAllTracking(new PacketPortalFX(coords), (World)teleWorld, coords.getPos());
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void encode(PacketPortableTeleporterGui pkt, PacketBuffer buf) {
        buf.func_179249_a((Enum)pkt.packetType);
        buf.func_179249_a((Enum)pkt.currentHand);
        if (pkt.frequency == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.func_180714_a(pkt.frequency.name);
            buf.writeBoolean(pkt.frequency.publicFreq);
        }
    }

    public static PacketPortableTeleporterGui decode(PacketBuffer buf) {
        PortableTeleporterPacketType packetType = (PortableTeleporterPacketType)buf.func_179257_a(PortableTeleporterPacketType.class);
        Hand currentHand = (Hand)buf.func_179257_a(Hand.class);
        Frequency frequency = null;
        if (buf.readBoolean()) {
            frequency = new Frequency(BasePacketHandler.readString(buf), null).setPublic(buf.readBoolean());
        }
        return new PacketPortableTeleporterGui(packetType, currentHand, frequency);
    }

    private static void sendDataResponse(Frequency given, World world, PlayerEntity player, ItemPortableTeleporter item, ItemStack stack, Hand hand) {
        List<Frequency> publicFreqs = PacketPortableTeleporterGui.getManager(null, world).getFrequencies();
        List<Frequency> privateFreqs = PacketPortableTeleporterGui.getManager(player.func_110124_au(), world).getFrequencies();
        int status = 3;
        if (given != null) {
            List<Frequency> frequencies = given.isPublic() ? publicFreqs : privateFreqs;
            for (Frequency iterFreq : frequencies) {
                Coord4D coords;
                if (!given.equals(iterFreq)) continue;
                given = iterFreq;
                if (given.activeCoords.isEmpty()) break;
                if (!player.func_184812_l_() && (coords = given.getClosestCoords(new Coord4D((Entity)player))) != null) {
                    FloatingLong energyNeeded = TileEntityTeleporter.calculateEnergyCost((Entity)player, coords);
                    IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
                    if (energyContainer == null || energyContainer.extract(energyNeeded, Action.SIMULATE, AutomationType.MANUAL).smallerThan(energyNeeded)) {
                        status = 4;
                        break;
                    }
                }
                status = 1;
                break;
            }
        }
        Mekanism.packetHandler.sendTo(new PacketPortableTeleporter(hand, given, (byte)status, publicFreqs, privateFreqs), (ServerPlayerEntity)player);
    }

    public static FrequencyManager getManager(UUID owner, World world) {
        if (owner == null) {
            return Mekanism.publicTeleporters;
        }
        if (!Mekanism.privateTeleporters.containsKey(owner)) {
            FrequencyManager manager = new FrequencyManager(FrequencyType.BASE, "Teleporter", owner);
            Mekanism.privateTeleporters.put(owner, manager);
            if (!world.func_201670_d()) {
                manager.createOrLoad();
            }
        }
        return Mekanism.privateTeleporters.get(owner);
    }

    public static enum PortableTeleporterPacketType {
        DATA_REQUEST,
        SET_FREQ,
        DEL_FREQ,
        TELEPORT;

    }
}

