/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.IDisableableEnum;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTranslationKey;
import mekanism.client.render.item.ISTERProvider;
import mekanism.common.MekanismLang;
import mekanism.common.base.ILangEntry;
import mekanism.common.block.BlockBounding;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.IItemHUDProvider;
import mekanism.common.item.IModeItem;
import mekanism.common.item.ItemEnergized;
import mekanism.common.tags.MekanismTags;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ShovelItem;
import net.minecraft.state.IProperty;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;

public class ItemAtomicDisassembler
extends ItemEnergized
implements IItemHUDProvider,
IModeItem {
    public ItemAtomicDisassembler(Item.Properties properties) {
        super(MekanismConfig.gear.disassemblerChargeRate, MekanismConfig.gear.disassemblerMaxEnergy, properties.setNoRepair().setISTER(ISTERProvider::disassembler));
    }

    public boolean func_150897_b(@Nonnull BlockState state) {
        return state.func_177230_c() != Blocks.field_150357_h;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        DisassemblerMode mode = this.getMode(stack);
        tooltip.add((ITextComponent)MekanismLang.MODE.translate(new Object[]{EnumColor.INDIGO, mode}));
        tooltip.add((ITextComponent)MekanismLang.DISASSEMBLER_EFFICIENCY.translate(new Object[]{EnumColor.INDIGO, mode.getEfficiency()}));
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        FloatingLong energy = energyContainer == null ? FloatingLong.ZERO : energyContainer.getEnergy();
        FloatingLong energyCost = (FloatingLong)MekanismConfig.gear.disassemblerEnergyUsageWeapon.get();
        int minDamage = MekanismConfig.gear.disassemblerMinDamage.get();
        int damageDifference = MekanismConfig.gear.disassemblerMaxDamage.get() - minDamage;
        double percent = 1.0;
        if (energy.smallerThan(energyCost)) {
            percent = energy.divideToLevel(energyCost);
        }
        float damage = (float)((double)minDamage + (double)damageDifference * percent);
        if (attacker instanceof PlayerEntity) {
            target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)attacker)), damage);
        } else {
            target.func_70097_a(DamageSource.func_76358_a((LivingEntity)attacker), damage);
        }
        if (energyContainer != null && !energy.isZero()) {
            energyContainer.extract(energyCost, Action.EXECUTE, AutomationType.MANUAL);
        }
        return false;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        return energyContainer == null || energyContainer.isEmpty() ? 1.0f : (float)this.getMode(stack).getEfficiency();
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entityliving) {
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer != null) {
            energyContainer.extract(this.getDestroyEnergy(stack, state.func_185887_b((IBlockReader)world, pos)), Action.EXECUTE, AutomationType.MANUAL);
        }
        return true;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        World world = player.field_70170_p;
        if (!world.field_72995_K && !player.func_184812_l_()) {
            boolean extended;
            IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
            if (energyContainer == null) {
                return super.onBlockStartBreak(stack, pos, player);
            }
            DisassemblerMode mode = this.getMode(stack);
            boolean bl = extended = mode == DisassemblerMode.EXTENDED_VEIN;
            if (extended || mode == DisassemblerMode.VEIN) {
                BlockState state = world.func_180495_p(pos);
                if (state.func_177230_c() instanceof BlockBounding) {
                    return super.onBlockStartBreak(stack, pos, player);
                }
                if (extended || state.func_203425_a(MekanismTags.Blocks.ATOMIC_DISASSEMBLER_ORE)) {
                    ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)player;
                    List<BlockPos> found = ItemAtomicDisassembler.findPositions(state, pos, world, extended ? MekanismConfig.gear.disassemblerMiningRange.get() : -1);
                    for (BlockPos foundPos : found) {
                        int exp;
                        BlockState foundState;
                        FloatingLong destroyEnergy;
                        if (pos.equals((Object)foundPos) || energyContainer.extract(destroyEnergy = this.getDestroyEnergy(stack, (foundState = world.func_180495_p(foundPos)).func_185887_b((IBlockReader)world, foundPos)), Action.SIMULATE, AutomationType.MANUAL).smallerThan(destroyEnergy) || (exp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)serverPlayerEntity.field_71134_c.func_73081_b(), (ServerPlayerEntity)serverPlayerEntity, (BlockPos)foundPos)) == -1) continue;
                        Block block = foundState.func_177230_c();
                        TileEntity tileEntity = MekanismUtils.getTileEntity((IBlockReader)world, foundPos);
                        boolean removed = foundState.removedByPlayer(world, foundPos, player, true, world.func_204610_c(foundPos));
                        if (!removed) continue;
                        block.func_176206_d((IWorld)world, foundPos, foundState);
                        block.func_180657_a(world, player, foundPos, foundState, tileEntity, stack);
                        player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                        if (exp > 0) {
                            block.func_180637_b(world, foundPos, exp);
                        }
                        energyContainer.extract(destroyEnergy, Action.EXECUTE, AutomationType.MANUAL);
                    }
                }
            }
        }
        return super.onBlockStartBreak(stack, pos, player);
    }

    private static List<BlockPos> findPositions(BlockState state, BlockPos location, World world, int maxRange) {
        ArrayList<BlockPos> found = new ArrayList<BlockPos>();
        ObjectOpenHashSet checked = new ObjectOpenHashSet();
        found.add(location);
        Block startBlock = state.func_177230_c();
        int maxCount = MekanismConfig.gear.disassemblerMiningCount.get() - 1;
        for (int i = 0; i < found.size(); ++i) {
            BlockPos blockPos = (BlockPos)found.get(i);
            checked.add(blockPos);
            for (BlockPos pos : BlockPos.func_218278_a((BlockPos)blockPos.func_177982_a(-1, -1, -1), (BlockPos)blockPos.func_177982_a(1, 1, 1))) {
                if (checked.contains(pos) || maxRange != -1 && !(Math.sqrt(location.func_177951_i((Vec3i)pos)) <= (double)maxRange) || !world.func_195588_v(pos) || startBlock != world.func_180495_p(pos).func_177230_c()) continue;
                found.add(pos.func_185334_h());
                if (found.size() <= maxCount) continue;
                return found;
            }
        }
        return found;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        return MekanismUtils.performActions(this.stripLogsAOE(context), () -> this.tillAOE(context, ShovelItem.field_195955_e, ctx -> ItemAtomicDisassembler.onToolUse(ctx.func_195999_j(), ctx.func_221531_n(), ctx.func_195995_a(), ctx.func_196000_l()) ? 0 : -1, SoundEvents.field_187771_eN, (FloatingLong)MekanismConfig.gear.disassemblerEnergyUsageShovel.get()), () -> this.tillAOE(context, HoeItem.field_195973_b, ForgeEventFactory::onHoeUse, SoundEvents.field_187693_cj, (FloatingLong)MekanismConfig.gear.disassemblerEnergyUsageHoe.get()));
    }

    private ActionResultType tillAOE(ItemUseContext context, Map<Block, BlockState> lookup, ToIntFunction<ItemUseContext> onItemUse, SoundEvent sound, FloatingLong energyUsage) {
        BlockPos pos;
        PlayerEntity player = context.func_195999_j();
        if (player == null || player.func_225608_bj_()) {
            return ActionResultType.PASS;
        }
        Direction sideHit = context.func_196000_l();
        if (sideHit == Direction.DOWN) {
            return ActionResultType.PASS;
        }
        Hand hand = context.func_221531_n();
        ItemStack stack = player.func_184586_b(hand);
        int diameter = this.getMode(stack).getDiameter();
        if (diameter == 0) {
            return ActionResultType.PASS;
        }
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer == null) {
            return ActionResultType.FAIL;
        }
        FloatingLong energy = energyContainer.getEnergy();
        if (energy.smallerThan(energyUsage)) {
            return ActionResultType.FAIL;
        }
        World world = context.func_195991_k();
        BlockState tilledState = lookup.get(world.func_180495_p(pos = context.func_195995_a()).func_177230_c());
        if (tilledState == null) {
            return ActionResultType.PASS;
        }
        BlockPos abovePos = pos.func_177984_a();
        BlockState aboveState = world.func_180495_p(abovePos);
        if (aboveState.func_200015_d((IBlockReader)world, abovePos)) {
            return ActionResultType.PASS;
        }
        int useResult = onItemUse.applyAsInt(context);
        if (useResult < 0) {
            return ActionResultType.PASS;
        }
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (useResult == 0) {
            world.func_180501_a(pos, tilledState, 11);
            Material aboveMaterial = aboveState.func_185904_a();
            if (aboveMaterial == Material.field_151585_k || aboveMaterial == Material.field_151582_l) {
                world.func_175655_b(abovePos, true);
            }
            world.func_184133_a(player, pos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        FloatingLong energyUsed = energyUsage.copy();
        int radius = (diameter - 1) / 2;
        for (BlockPos newPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-radius, 0, -radius), (BlockPos)pos.func_177982_a(radius, 0, radius))) {
            if (pos.equals((Object)newPos)) continue;
            if (energyUsed.add(energyUsage).greaterThan(energy)) break;
            BlockState stateAbove = world.func_180495_p(newPos.func_177984_a());
            if (stateAbove.func_200015_d((IBlockReader)world, newPos.func_177984_a()) || tilledState != lookup.get(world.func_180495_p(newPos).func_177230_c()) || (useResult = onItemUse.applyAsInt(new ItemUseContext(player, hand, new BlockRayTraceResult(Vec3d.field_186680_a, Direction.UP, newPos = newPos.func_185334_h(), false)))) < 0) continue;
            energyUsed = energyUsed.plusEqual(energyUsage);
            if (useResult > 0) continue;
            world.func_180501_a(newPos, tilledState, 11);
            Material aboveMaterial = stateAbove.func_185904_a();
            if (aboveMaterial == Material.field_151585_k || aboveMaterial == Material.field_151582_l) {
                world.func_175655_b(newPos.func_177984_a(), true);
            }
            world.func_184133_a(player, newPos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        energyContainer.extract(energyUsed, Action.EXECUTE, AutomationType.MANUAL);
        return ActionResultType.SUCCESS;
    }

    private ActionResultType stripLogsAOE(ItemUseContext context) {
        BlockPos pos;
        FloatingLong energyUsage;
        PlayerEntity player = context.func_195999_j();
        if (player == null || player.func_225608_bj_()) {
            return ActionResultType.PASS;
        }
        Hand hand = context.func_221531_n();
        ItemStack stack = player.func_184586_b(hand);
        int diameter = this.getMode(stack).getDiameter();
        if (diameter == 0) {
            return ActionResultType.PASS;
        }
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer == null) {
            return ActionResultType.FAIL;
        }
        FloatingLong energy = energyContainer.getEnergy();
        if (energy.smallerThan(energyUsage = (FloatingLong)MekanismConfig.gear.disassemblerEnergyUsageAxe.get())) {
            return ActionResultType.FAIL;
        }
        Map lookup = AxeItem.field_203176_a;
        World world = context.func_195991_k();
        BlockState clickedState = world.func_180495_p(pos = context.func_195995_a());
        Block strippedBlock = (Block)lookup.get(clickedState.func_177230_c());
        if (strippedBlock == null) {
            return ActionResultType.PASS;
        }
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        Direction.Axis axis = (Direction.Axis)clickedState.func_177229_b((IProperty)RotatedPillarBlock.field_176298_M);
        BlockState strippedState = (BlockState)strippedBlock.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)axis);
        world.func_180501_a(pos, strippedState, 11);
        world.func_184133_a(player, pos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
        Direction side = context.func_196000_l();
        FloatingLong energyUsed = energyUsage.copy();
        for (BlockPos newPos : ItemAtomicDisassembler.getStrippingArea(pos, side, (diameter - 1) / 2)) {
            if (pos.equals((Object)newPos)) continue;
            if (energyUsed.add(energyUsage).greaterThan(energy)) break;
            BlockState state = world.func_180495_p(newPos);
            if (strippedBlock != lookup.get(state.func_177230_c()) || axis != state.func_177229_b((IProperty)RotatedPillarBlock.field_176298_M) || !ItemAtomicDisassembler.onToolUse(player, hand, newPos = newPos.func_185334_h(), side)) continue;
            energyUsed = energyUsed.plusEqual(energyUsage);
            world.func_180501_a(newPos, strippedState, 11);
            world.func_184133_a(player, pos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        energyContainer.extract(energyUsed, Action.EXECUTE, AutomationType.MANUAL);
        return ActionResultType.SUCCESS;
    }

    private static Iterable<BlockPos> getStrippingArea(BlockPos pos, Direction direction, int radius) {
        AxisAlignedBB box;
        switch (direction) {
            case EAST: 
            case WEST: {
                box = new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() - radius), (double)(pos.func_177952_p() - radius), (double)pos.func_177958_n(), (double)(pos.func_177956_o() + radius), (double)(pos.func_177952_p() + radius));
                break;
            }
            case UP: 
            case DOWN: {
                box = new AxisAlignedBB((double)(pos.func_177958_n() - radius), (double)pos.func_177956_o(), (double)(pos.func_177952_p() - radius), (double)(pos.func_177958_n() + radius), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + radius));
                break;
            }
            case SOUTH: 
            case NORTH: {
                box = new AxisAlignedBB((double)(pos.func_177958_n() - radius), (double)(pos.func_177956_o() - radius), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + radius), (double)(pos.func_177956_o() + radius), (double)pos.func_177952_p());
                break;
            }
            default: {
                return BlockPos.func_218278_a((BlockPos)BlockPos.field_177992_a, (BlockPos)BlockPos.field_177992_a);
            }
        }
        return BlockPos.func_218278_a((BlockPos)new BlockPos(box.field_72340_a, box.field_72338_b, box.field_72339_c), (BlockPos)new BlockPos(box.field_72336_d, box.field_72337_e, box.field_72334_f));
    }

    private static boolean onToolUse(PlayerEntity player, Hand hand, BlockPos pos, Direction face) {
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((PlayerEntity)player, (Hand)hand, (BlockPos)pos, (Direction)face);
        return !event.isCanceled() && event.getUseItem() != Event.Result.DENY;
    }

    private FloatingLong getDestroyEnergy(ItemStack itemStack, float hardness) {
        FloatingLong destroyEnergy = ((FloatingLong)MekanismConfig.gear.disassemblerEnergyUsage.get()).multiply(this.getMode(itemStack).getEfficiency());
        return hardness == 0.0f ? destroyEnergy.divide(2L) : destroyEnergy;
    }

    public DisassemblerMode getMode(ItemStack itemStack) {
        return DisassemblerMode.byIndexStatic(ItemDataUtils.getInt(itemStack, "mode"));
    }

    public void setMode(ItemStack itemStack, DisassemblerMode mode) {
        ItemDataUtils.setInt(itemStack, "mode", mode.ordinal());
    }

    @Nonnull
    @Deprecated
    public Multimap<String, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        Multimap multiMap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EquipmentSlotType.MAINHAND) {
            multiMap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.4f, AttributeModifier.Operation.ADDITION));
        }
        return multiMap;
    }

    @Override
    public void addHUDStrings(List<ITextComponent> list, ItemStack stack, EquipmentSlotType slotType) {
        DisassemblerMode mode = this.getMode(stack);
        list.add((ITextComponent)MekanismLang.MODE.translate(new Object[]{EnumColor.INDIGO, mode}));
        list.add((ITextComponent)MekanismLang.DISASSEMBLER_EFFICIENCY.translate(new Object[]{EnumColor.INDIGO, mode.getEfficiency()}));
    }

    @Override
    public void changeMode(@Nonnull PlayerEntity player, @Nonnull ItemStack stack, int shift, boolean displayChangeMessage) {
        DisassemblerMode newMode;
        DisassemblerMode mode = this.getMode(stack);
        if (mode != (newMode = (DisassemblerMode)mode.adjust(shift))) {
            this.setMode(stack, newMode);
            if (displayChangeMessage) {
                player.func_145747_a(MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, MekanismLang.DISASSEMBLER_MODE_CHANGE.translateColored(EnumColor.GRAY, new Object[]{EnumColor.INDIGO, newMode, EnumColor.AQUA, newMode.getEfficiency()})));
            }
        }
    }

    @Override
    @Nonnull
    public ITextComponent getScrollTextComponent(@Nonnull ItemStack stack) {
        DisassemblerMode mode = this.getMode(stack);
        return MekanismLang.GENERIC_WITH_PARENTHESIS.translateColored(EnumColor.INDIGO, new Object[]{mode, EnumColor.AQUA, mode.getEfficiency()});
    }

    public static enum DisassemblerMode implements IDisableableEnum<DisassemblerMode>,
    IHasTranslationKey
    {
        NORMAL(MekanismLang.DISASSEMBLER_NORMAL, 20, 3, () -> true),
        SLOW(MekanismLang.DISASSEMBLER_SLOW, 8, 1, MekanismConfig.gear.disassemblerSlowMode),
        FAST(MekanismLang.DISASSEMBLER_FAST, 128, 5, MekanismConfig.gear.disassemblerFastMode),
        VEIN(MekanismLang.DISASSEMBLER_VEIN, 20, 3, MekanismConfig.gear.disassemblerVeinMining),
        EXTENDED_VEIN(MekanismLang.DISASSEMBLER_EXTENDED_VEIN, 20, 3, MekanismConfig.gear.disassemblerExtendedMining),
        OFF(MekanismLang.DISASSEMBLER_OFF, 0, 0, () -> true);

        private static final DisassemblerMode[] MODES;
        private final BooleanSupplier checkEnabled;
        private final ILangEntry langEntry;
        private final int efficiency;
        private final int diameter;

        private DisassemblerMode(ILangEntry langEntry, int efficiency, int diameter, BooleanSupplier checkEnabled) {
            this.langEntry = langEntry;
            this.efficiency = efficiency;
            this.diameter = diameter;
            this.checkEnabled = checkEnabled;
        }

        public static DisassemblerMode byIndexStatic(int index) {
            DisassemblerMode mode = MathUtils.getByIndexMod(MODES, index);
            return mode.isEnabled() ? mode : NORMAL;
        }

        @Override
        @Nonnull
        public DisassemblerMode byIndex(int index) {
            return MathUtils.getByIndexMod(MODES, index);
        }

        @Override
        public String getTranslationKey() {
            return this.langEntry.getTranslationKey();
        }

        public int getEfficiency() {
            return this.efficiency;
        }

        public int getDiameter() {
            return this.diameter;
        }

        @Override
        public boolean isEnabled() {
            return this.checkEnabled.getAsBoolean();
        }

        static {
            MODES = DisassemblerMode.values();
        }
    }
}

